/*

Copyright (C) 2009 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */
package com.clustercontrol.accesscontrol.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.bean.RoleConstant;
import com.clustercontrol.accesscontrol.bean.UserConstant;
import com.clustercontrol.accesscontrol.bean.UserRoleList;
import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.ws.access.UserInfo;

/**
 * ユーザ情報のDTOとプロパティを相互変換するためのユーティリティクラスです。
 * 
 * @version 4.0.0
 */
public class UserPropertyUtil {
	/** ログ出力のインスタンス */
	private static Log m_log = LogFactory.getLog(UserPropertyUtil.class);

	/** Roleリスト */
	private final static List<String> m_roles = new ArrayList<String>();

	/** ReadRoleリスト */
	public final static List<String> m_readRoles = new ArrayList<String>();

	/** WriteRoleリスト */
	public final static List<String> m_writeRoles = new ArrayList<String>();

	/** ExecRoleリスト */
	public final static List<String> m_execRoles = new ArrayList<String>();

	static {
		/** メイン処理 */
		m_log.debug("initialize RoleConstant...");

		m_roles.add(RoleConstant.HINEMOS_USER);
		m_roles.add(RoleConstant.REPOSITORY_READ);
		m_roles.add(RoleConstant.REPOSITORY_WRITE);
		m_roles.add(RoleConstant.REPOSITORY_EXECUTE);
		m_roles.add(RoleConstant.ACCESSCONTROL_READ);
		m_roles.add(RoleConstant.ACCESSCONTROL_WRITE);
		m_roles.add(RoleConstant.JOBMANAGEMENT_READ);
		m_roles.add(RoleConstant.JOBMANAGEMENT_WRITE);
		m_roles.add(RoleConstant.JOBMANAGEMENT_EXECUTE);
		m_roles.add(RoleConstant.COLLECTIVERUN_READ);
		m_roles.add(RoleConstant.COLLECTIVERUN_WRITE);
		m_roles.add(RoleConstant.COLLECTIVERUN_EXECUTE);
		m_roles.add(RoleConstant.PERFORMANCE_READ);
		m_roles.add(RoleConstant.PERFORMANCE_EXECUTE);
		m_roles.add(RoleConstant.MONITOR_RESULT_READ);
		m_roles.add(RoleConstant.MONITOR_RESULT_WRITE);
		m_roles.add(RoleConstant.MONITOR_SETTING_READ);
		m_roles.add(RoleConstant.MONITOR_SETTING_WRITE);
		m_roles.add(RoleConstant.CALENDAR_READ);
		m_roles.add(RoleConstant.CALENDAR_WRITE);
		m_roles.add(RoleConstant.NOTIFY_READ);
		m_roles.add(RoleConstant.NOTIFY_WRITE);
		m_roles.add(RoleConstant.MAINTENANCE_READ);
		m_roles.add(RoleConstant.MAINTENANCE_WRITE);

		/** Read/Write/ExecRoleリスト */
		// 参照権限
		m_readRoles.add(RoleConstant.REPOSITORY_READ);
		m_readRoles.add(RoleConstant.ACCESSCONTROL_READ);
		m_readRoles.add(RoleConstant.JOBMANAGEMENT_READ);
		m_readRoles.add(RoleConstant.COLLECTIVERUN_READ);
		m_readRoles.add(RoleConstant.PERFORMANCE_READ);
		m_readRoles.add(RoleConstant.MONITOR_RESULT_READ);
		m_readRoles.add(RoleConstant.MONITOR_SETTING_READ);
		m_readRoles.add(RoleConstant.CALENDAR_READ);
		m_readRoles.add(RoleConstant.NOTIFY_READ);
		m_readRoles.add(RoleConstant.MAINTENANCE_READ);

		// 設定権限
		m_writeRoles.add(RoleConstant.REPOSITORY_WRITE);
		m_writeRoles.add(RoleConstant.ACCESSCONTROL_WRITE);
		m_writeRoles.add(RoleConstant.JOBMANAGEMENT_WRITE);
		m_writeRoles.add(RoleConstant.COLLECTIVERUN_WRITE);
		m_writeRoles.add(RoleConstant.MONITOR_RESULT_WRITE);
		m_writeRoles.add(RoleConstant.MONITOR_SETTING_WRITE);
		m_writeRoles.add(RoleConstant.CALENDAR_WRITE);
		m_writeRoles.add(RoleConstant.NOTIFY_WRITE);
		m_writeRoles.add(RoleConstant.MAINTENANCE_WRITE);

		// 実行権限
		m_execRoles.add(RoleConstant.REPOSITORY_EXECUTE);
		m_execRoles.add(RoleConstant.JOBMANAGEMENT_EXECUTE);
		m_execRoles.add(RoleConstant.COLLECTIVERUN_EXECUTE);
		m_execRoles.add(RoleConstant.PERFORMANCE_EXECUTE);
		m_execRoles.add(RoleConstant.VMMANAGEMENT_EXECUTE);

		// VM Option関連
		m_roles.add(RoleConstant.VMMANAGEMENT_READ);
		m_roles.add(RoleConstant.VMMANAGEMENT_WRITE);
		m_roles.add(RoleConstant.VMMANAGEMENT_EXECUTE);

		m_readRoles.add(RoleConstant.VMMANAGEMENT_READ);
		m_writeRoles.add(RoleConstant.VMMANAGEMENT_WRITE);
		m_execRoles.add(RoleConstant.VMMANAGEMENT_EXECUTE);

		// CLOUD Option関連
		m_roles.add(RoleConstant.CLOUDMANAGEMENT_READ);
		m_roles.add(RoleConstant.CLOUDMANAGEMENT_WRITE);
		m_roles.add(RoleConstant.CLOUDMANAGEMENT_EXECUTE);

		m_readRoles.add(RoleConstant.CLOUDMANAGEMENT_READ);
		m_writeRoles.add(RoleConstant.CLOUDMANAGEMENT_WRITE);
		m_execRoles.add(RoleConstant.CLOUDMANAGEMENT_EXECUTE);

		// HA Option関連
		// No Necessity
	}

	public static UserInfo property2dto(Property property){
		UserInfo info = new UserInfo();
		info.setCreateDate(0L);
		info.setModifyDate(0L);

		ArrayList object = null;

		//UID
		object = PropertyUtil.getPropertyValue(property, UserConstant.UID);
		if (object.size() > 0) {
			info.setId((String)object.get(0));
		}
		//名前
		object = PropertyUtil.getPropertyValue(property, UserConstant.NAME);
		if (object.size() > 0) {
			info.setName((String)object.get(0));
		}
		//説明
		object = PropertyUtil.getPropertyValue(property, UserConstant.DESCRIPTION);
		if (object.size() > 0) {
			info.setDescription((String)object.get(0));
		}
		//登録者
		object = PropertyUtil.getPropertyValue(property, UserConstant.CREATOR_NAME);
		if (object.size() > 0) {
			info.setCreateUserId((String)object.get(0));
		}
		//登録日時
		object = PropertyUtil.getPropertyValue(property, UserConstant.CREATE_TIME);
		if (object.size() > 0 && object.get(0) != null && !object.get(0).toString().equals("")) {
			info.setCreateDate(((Date) (object.get(0))).getTime());
		}
		//更新者
		object = PropertyUtil.getPropertyValue(property, UserConstant.MODIFIER_NAME);
		if (object.size() > 0) {
			info.setModifyUserId((String)object.get(0));
		}
		//更新日時
		object = PropertyUtil.getPropertyValue(property, UserConstant.MODIFY_TIME);
		if (object.size() > 0 && object.get(0) != null && !object.get(0).toString().equals("")) {
			info.setModifyDate(((Date) (object.get(0))).getTime());
		}
		//所属Role
		object = PropertyUtil.getProperty(property, UserConstant.ACCESS);
		if (object.size() > 0) {
			Property accessProperty = (Property)object.get(0);
			for(String role : getRoleList().getRoles()){
				ArrayList roleProperties = PropertyUtil.getProperty(accessProperty, role);
				if(roleProperties.size() > 0 && (Boolean)((Property)roleProperties.get(0)).getValue()){
					List<String> roleList = info.getRoleList();
					roleList.add(role);
				}
			}
		}

		return info;
	}

	public static Property dto2property(UserInfo info, int mode, Locale locale){
		Property property = getProperty(mode, locale);
		ArrayList propertyList = null;

		if(info != null){
			//UID
			propertyList = PropertyUtil.getProperty(property, UserConstant.UID);
			((Property)propertyList.get(0)).setValue(info.getId());
			//名前
			propertyList = PropertyUtil.getProperty(property, UserConstant.NAME);
			if(info.getName() != null && info.getName().compareTo("") != 0){
				((Property)propertyList.get(0)).setValue(info.getName());
			}
			//説明
			propertyList = PropertyUtil.getProperty(property, UserConstant.DESCRIPTION);
			if(info.getDescription() != null && info.getDescription().compareTo("") != 0){
				((Property)propertyList.get(0)).setValue(info.getDescription());
			}
			//登録者
			propertyList = PropertyUtil.getProperty(property, UserConstant.CREATOR_NAME);
			if(info.getCreateUserId() != null && info.getCreateUserId().compareTo("") != 0){
				((Property)propertyList.get(0)).setValue(info.getCreateUserId());
			}
			//登録日時
			propertyList = PropertyUtil.getProperty(property, UserConstant.CREATE_TIME);
			if(info.getCreateDate() != null){
				((Property)propertyList.get(0)).setValue( new Date(info.getCreateDate()) );
			}
			//更新者
			propertyList = PropertyUtil.getProperty(property, UserConstant.MODIFIER_NAME);
			if(info.getModifyUserId() != null && info.getModifyUserId().compareTo("") != 0){
				((Property)propertyList.get(0)).setValue(info.getModifyUserId());
			}
			//更新日時
			propertyList = PropertyUtil.getProperty(property, UserConstant.MODIFY_TIME);
			if(info.getModifyDate() != null){
				((Property)propertyList.get(0)).setValue( new Date(info.getModifyDate()) );
			}

			//アクセス権限
			propertyList = PropertyUtil.getProperty(property, UserConstant.ACCESS);
			Property accessProperty = (Property)propertyList.get(0);

			//所属Role
			for (String role : info.getRoleList()) {
				propertyList = PropertyUtil.getProperty(accessProperty, role);
				if(propertyList.size() > 0) {
					((Property)propertyList.get(0)).setValue(Boolean.valueOf(true));
				}
			}

		}
		return property;
	}

	/**
	 * ユーザ用プロパティを返却する
	 * 
	 * @param mode PropertyConstant.MODE_ADDまたはMODE_MODIFY
	 * @param locale
	 * @return
	 */
	public static Property getProperty(int mode, Locale locale) {
		//UID
		Property uid =
			new Property(UserConstant.UID, Messages.getString("user.id", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		//名前
		Property name =
			new Property(UserConstant.NAME, Messages.getString("name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_128);
		//説明
		Property description =
			new Property(UserConstant.DESCRIPTION, Messages.getString("description", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_256);
		//登録日時
		Property createTime =
			new Property(UserConstant.CREATE_TIME, Messages.getString("create.time", locale), PropertyConstant.EDITOR_DATETIME);
		//登録者
		Property creatorName =
			new Property(UserConstant.CREATOR_NAME, Messages.getString("creator.name", locale), PropertyConstant.EDITOR_TEXT);
		//更新日時
		Property modifyTime =
			new Property(UserConstant.MODIFY_TIME, Messages.getString("update.time", locale), PropertyConstant.EDITOR_DATETIME);
		//更新者
		Property modifierName =
			new Property(UserConstant.MODIFIER_NAME, Messages.getString("modifier.name", locale), PropertyConstant.EDITOR_TEXT);

		//アクセス権限
		Property access =
			new Property(UserConstant.ACCESS, Messages.getString("access.permission", locale), PropertyConstant.EDITOR_TEXT);
		//リポジトリ参照
		Property repositoryRead =
			new Property(RoleConstant.REPOSITORY_READ, Messages.getString("repository.read", locale), PropertyConstant.EDITOR_BOOL);
		//リポジトリ設定
		Property repositoryWrite =
			new Property(RoleConstant.REPOSITORY_WRITE, Messages.getString("repository.write", locale), PropertyConstant.EDITOR_BOOL);
		//リポジトリ実行
		Property repositoryExecute =
			new Property(RoleConstant.REPOSITORY_EXECUTE, Messages.getString("repository.execute", locale), PropertyConstant.EDITOR_BOOL);
		//ユーザ管理参照
		Property accessRead =
			new Property(RoleConstant.ACCESSCONTROL_READ, Messages.getString("accesscontrol.read", locale), PropertyConstant.EDITOR_BOOL);
		//ユーザ管理設定
		Property accessWrite =
			new Property(RoleConstant.ACCESSCONTROL_WRITE, Messages.getString("accesscontrol.write", locale), PropertyConstant.EDITOR_BOOL);
		//監視結果参照
		Property monitorResultRead =
			new Property(RoleConstant.MONITOR_RESULT_READ, Messages.getString("monitor.result.read", locale), PropertyConstant.EDITOR_BOOL);
		//監視結果設定
		Property monitorResultWrite =
			new Property(RoleConstant.MONITOR_RESULT_WRITE, Messages.getString("monitor.result.write", locale), PropertyConstant.EDITOR_BOOL);
		//監視結果参照
		Property monitorSettingRead =
			new Property(RoleConstant.MONITOR_SETTING_READ, Messages.getString("monitor.setting.read", locale), PropertyConstant.EDITOR_BOOL);
		//監視結果設定
		Property monitorSettingWrite =
			new Property(RoleConstant.MONITOR_SETTING_WRITE, Messages.getString("monitor.setting.write", locale), PropertyConstant.EDITOR_BOOL);
		//ジョブ管理参照
		Property jobManagementRead =
			new Property(RoleConstant.JOBMANAGEMENT_READ, Messages.getString("jobmanagement.read", locale), PropertyConstant.EDITOR_BOOL);
		//ジョブ設定
		Property jobManagementWrite =
			new Property(RoleConstant.JOBMANAGEMENT_WRITE, Messages.getString("jobmanagement.write", locale), PropertyConstant.EDITOR_BOOL);
		//ジョブ実行
		Property jobManagementExecute =
			new Property(RoleConstant.JOBMANAGEMENT_EXECUTE, Messages.getString("jobmanagement.execute", locale), PropertyConstant.EDITOR_BOOL);
		//性能管理参照
		Property performanceRead =
			new Property(RoleConstant.PERFORMANCE_READ, Messages.getString("performance.read", locale), PropertyConstant.EDITOR_BOOL);
		//性能管理実行
		Property performanceExecute =
			new Property(RoleConstant.PERFORMANCE_EXECUTE, Messages.getString("performance.execute", locale), PropertyConstant.EDITOR_BOOL);
		//一括制御参照
		Property collectiverunRead =
			new Property(RoleConstant.COLLECTIVERUN_READ, Messages.getString("collectiverun.read", locale), PropertyConstant.EDITOR_BOOL);
		//一括制御設定
		Property collectiverunWrite =
			new Property(RoleConstant.COLLECTIVERUN_WRITE, Messages.getString("collectiverun.write", locale), PropertyConstant.EDITOR_BOOL);
		//一括制御実行
		Property collectiverunExecute =
			new Property(RoleConstant.COLLECTIVERUN_EXECUTE, Messages.getString("collectiverun.execute", locale), PropertyConstant.EDITOR_BOOL);
		//カレンダ参照
		Property calendarRead =
			new Property(RoleConstant.CALENDAR_READ, Messages.getString("calendar.read", locale), PropertyConstant.EDITOR_BOOL);
		//カレンダ設定
		Property calendarWrite =
			new Property(RoleConstant.CALENDAR_WRITE, Messages.getString("calendar.write", locale), PropertyConstant.EDITOR_BOOL);
		//通知参照
		Property notifyRead =
			new Property(RoleConstant.NOTIFY_READ, Messages.getString("notify.id.read", locale), PropertyConstant.EDITOR_BOOL);
		//通知設定
		Property notifyWrite =
			new Property(RoleConstant.NOTIFY_WRITE, Messages.getString("notify.id.write", locale), PropertyConstant.EDITOR_BOOL);
		//履歴情報削除参照
		Property maintenanceRead =
			new Property(RoleConstant.MAINTENANCE_READ, Messages.getString("maintenance.delete.history.read", locale), PropertyConstant.EDITOR_BOOL);
		//履歴情報削除設定
		Property maintenanceWrite =
			new Property(RoleConstant.MAINTENANCE_WRITE, Messages.getString("maintenance.delete.history.write", locale), PropertyConstant.EDITOR_BOOL);
		//仮想化管理参照
		Property vmManagementRead =
			new Property(RoleConstant.VMMANAGEMENT_READ, Messages.getString("vm.management.read", locale), PropertyConstant.EDITOR_BOOL);
		//仮想化管理設定
		Property vmManagementWrite =
			new Property(RoleConstant.VMMANAGEMENT_WRITE, Messages.getString("vm.management.write", locale), PropertyConstant.EDITOR_BOOL);
		//仮想化管理実行
		Property vmManagementExecute =
			new Property(RoleConstant.VMMANAGEMENT_EXECUTE, Messages.getString("vm.management.execute", locale), PropertyConstant.EDITOR_BOOL);
		//クラウド管理参照
		Property cloudManagementRead =
			new Property(RoleConstant.CLOUDMANAGEMENT_READ, Messages.getString("cloud.management.read", locale), PropertyConstant.EDITOR_BOOL);
		//クラウド管理設定
		Property cloudManagementWrite =
			new Property(RoleConstant.CLOUDMANAGEMENT_WRITE, Messages.getString("cloud.management.write", locale), PropertyConstant.EDITOR_BOOL);
		//クラウド管理実行
		Property cloudManagementExecute =
			new Property(RoleConstant.CLOUDMANAGEMENT_EXECUTE, Messages.getString("cloud.management.execute", locale), PropertyConstant.EDITOR_BOOL);

		//値を初期化
		uid.setValue("");
		name.setValue("");
		description.setValue("");
		createTime.setValue("");
		creatorName.setValue("");
		modifyTime.setValue("");
		modifierName.setValue("");

		access.setValue("");
		repositoryRead.setValue(Boolean.valueOf(true));
		repositoryWrite.setValue(Boolean.valueOf(false));
		repositoryExecute.setValue(Boolean.valueOf(false));
		accessRead.setValue(Boolean.valueOf(false));
		accessWrite.setValue(Boolean.valueOf(false));
		monitorResultRead.setValue(Boolean.valueOf(false));
		monitorResultWrite.setValue(Boolean.valueOf(false));
		monitorSettingRead.setValue(Boolean.valueOf(false));
		monitorSettingWrite.setValue(Boolean.valueOf(false));
		jobManagementRead.setValue(Boolean.valueOf(false));
		jobManagementWrite.setValue(Boolean.valueOf(false));
		jobManagementExecute.setValue(Boolean.valueOf(false));
		performanceRead.setValue(Boolean.valueOf(false));
		performanceExecute.setValue(Boolean.valueOf(false));
		collectiverunRead.setValue(Boolean.valueOf(false));
		collectiverunWrite.setValue(Boolean.valueOf(false));
		collectiverunExecute.setValue(Boolean.valueOf(false));
		calendarRead.setValue(Boolean.valueOf(false));
		calendarWrite.setValue(Boolean.valueOf(false));
		notifyRead.setValue(Boolean.valueOf(false));
		notifyWrite.setValue(Boolean.valueOf(false));
		maintenanceRead.setValue(Boolean.valueOf(false));
		maintenanceWrite.setValue(Boolean.valueOf(false));
		vmManagementRead.setValue(Boolean.valueOf(false));
		vmManagementWrite.setValue(Boolean.valueOf(false));
		vmManagementExecute.setValue(Boolean.valueOf(false));
		cloudManagementRead.setValue(Boolean.valueOf(false));
		cloudManagementWrite.setValue(Boolean.valueOf(false));
		cloudManagementExecute.setValue(Boolean.valueOf(false));

		//モードにより、変更可及びコピー可を設定
		if(mode == PropertyConstant.MODE_ADD){
			uid.setModify(PropertyConstant.MODIFY_OK);
			name.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
			repositoryWrite.setModify(PropertyConstant.MODIFY_OK);
			repositoryExecute.setModify(PropertyConstant.MODIFY_OK);
			accessRead.setModify(PropertyConstant.MODIFY_OK);
			accessWrite.setModify(PropertyConstant.MODIFY_OK);
			monitorResultRead.setModify(PropertyConstant.MODIFY_OK);
			monitorResultWrite.setModify(PropertyConstant.MODIFY_OK);
			monitorSettingRead.setModify(PropertyConstant.MODIFY_OK);
			monitorSettingWrite.setModify(PropertyConstant.MODIFY_OK);
			jobManagementRead.setModify(PropertyConstant.MODIFY_OK);
			jobManagementWrite.setModify(PropertyConstant.MODIFY_OK);
			jobManagementExecute.setModify(PropertyConstant.MODIFY_OK);
			performanceRead.setModify(PropertyConstant.MODIFY_OK);
			performanceExecute.setModify(PropertyConstant.MODIFY_OK);
			collectiverunRead.setModify(PropertyConstant.MODIFY_OK);
			collectiverunWrite.setModify(PropertyConstant.MODIFY_OK);
			collectiverunExecute.setModify(PropertyConstant.MODIFY_OK);
			calendarRead.setModify(PropertyConstant.MODIFY_OK);
			calendarWrite.setModify(PropertyConstant.MODIFY_OK);
			notifyRead.setModify(PropertyConstant.MODIFY_OK);
			notifyWrite.setModify(PropertyConstant.MODIFY_OK);
			maintenanceRead.setModify(PropertyConstant.MODIFY_OK);
			maintenanceWrite.setModify(PropertyConstant.MODIFY_OK);
			vmManagementRead.setModify(PropertyConstant.MODIFY_OK);
			vmManagementWrite.setModify(PropertyConstant.MODIFY_OK);
			vmManagementExecute.setModify(PropertyConstant.MODIFY_OK);
			cloudManagementRead.setModify(PropertyConstant.MODIFY_OK);
			cloudManagementWrite.setModify(PropertyConstant.MODIFY_OK);
			cloudManagementExecute.setModify(PropertyConstant.MODIFY_OK);
		}
		else if(mode == PropertyConstant.MODE_MODIFY){
			name.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
			repositoryWrite.setModify(PropertyConstant.MODIFY_OK);
			repositoryExecute.setModify(PropertyConstant.MODIFY_OK);
			accessRead.setModify(PropertyConstant.MODIFY_OK);
			accessWrite.setModify(PropertyConstant.MODIFY_OK);
			monitorResultRead.setModify(PropertyConstant.MODIFY_OK);
			monitorResultWrite.setModify(PropertyConstant.MODIFY_OK);
			monitorSettingRead.setModify(PropertyConstant.MODIFY_OK);
			monitorSettingWrite.setModify(PropertyConstant.MODIFY_OK);
			jobManagementRead.setModify(PropertyConstant.MODIFY_OK);
			jobManagementWrite.setModify(PropertyConstant.MODIFY_OK);
			jobManagementExecute.setModify(PropertyConstant.MODIFY_OK);
			performanceRead.setModify(PropertyConstant.MODIFY_OK);
			performanceExecute.setModify(PropertyConstant.MODIFY_OK);
			collectiverunRead.setModify(PropertyConstant.MODIFY_OK);
			collectiverunWrite.setModify(PropertyConstant.MODIFY_OK);
			collectiverunExecute.setModify(PropertyConstant.MODIFY_OK);
			calendarRead.setModify(PropertyConstant.MODIFY_OK);
			calendarWrite.setModify(PropertyConstant.MODIFY_OK);
			notifyRead.setModify(PropertyConstant.MODIFY_OK);
			notifyWrite.setModify(PropertyConstant.MODIFY_OK);
			maintenanceRead.setModify(PropertyConstant.MODIFY_OK);
			maintenanceWrite.setModify(PropertyConstant.MODIFY_OK);
			vmManagementRead.setModify(PropertyConstant.MODIFY_OK);
			vmManagementWrite.setModify(PropertyConstant.MODIFY_OK);
			vmManagementExecute.setModify(PropertyConstant.MODIFY_OK);
			cloudManagementRead.setModify(PropertyConstant.MODIFY_OK);
			cloudManagementWrite.setModify(PropertyConstant.MODIFY_OK);
			cloudManagementExecute.setModify(PropertyConstant.MODIFY_OK);
		}

		Property property = new Property(null, null, "");

		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(uid);
		property.addChildren(name);
		property.addChildren(description);
		property.addChildren(createTime);
		property.addChildren(creatorName);
		property.addChildren(modifyTime);
		property.addChildren(modifierName);
		property.addChildren(access);

		// アクセス権限ツリー
		access.removeChildren();
		access.addChildren(repositoryRead);
		access.addChildren(repositoryWrite);
		access.addChildren(repositoryExecute);
		access.addChildren(accessRead);
		access.addChildren(accessWrite);
		access.addChildren(monitorResultRead);
		access.addChildren(monitorResultWrite);
		access.addChildren(monitorSettingRead);
		access.addChildren(monitorSettingWrite);
		access.addChildren(jobManagementRead);
		access.addChildren(jobManagementWrite);
		access.addChildren(jobManagementExecute);
		access.addChildren(performanceRead);
		access.addChildren(performanceExecute);
		access.addChildren(collectiverunRead);
		access.addChildren(collectiverunWrite);
		access.addChildren(collectiverunExecute);
		access.addChildren(calendarRead);
		access.addChildren(calendarWrite);
		access.addChildren(notifyRead);
		access.addChildren(notifyWrite);
		access.addChildren(maintenanceRead);
		access.addChildren(maintenanceWrite);

		// VM管理オプションが適用されている場合
		access.addChildren(vmManagementRead);
		access.addChildren(vmManagementWrite);
		access.addChildren(vmManagementExecute);

		// クラウド管理オプションが適用されている場合
		access.addChildren(cloudManagementRead);
		access.addChildren(cloudManagementWrite);
		access.addChildren(cloudManagementExecute);
		
		return property;
	}

	/**
	 * 権限名の配列を返します。
	 * 
	 * @return 権限名の配列
	 */
	public static UserRoleList getRoleList() {
		return new UserRoleList(m_roles, m_readRoles, m_writeRoles, m_execRoles);
	}
}
