/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.bean;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.collectiverun.bean.CollectiveRunStatusConstant;

/**
 * 一括制御状態イメージ定数を定義するクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CollectiveRunStatusImageConstant extends
CollectiveRunStatusConstant {
	private static Image running = null;

	private static Image end = null;

	private static Image waiting = null;

	private static Image runError = null;

	/**
	 * 種別からImageに変換します。<BR>
	 * 
	 * @param type
	 * @return Image
	 */
	public static Image typeToImage(int type) {
		ImageRegistry registry = ClusterControlPlugin.getDefault()
		.getImageRegistry();

		if (type == TYPE_RUNNING) {
			if (running == null)
				running = registry.getDescriptor(
						ClusterControlPlugin.IMG_STATUS_BLUE).createImage();
			return running;
		} else if (type == TYPE_END) {
			if (end == null)
				end = registry.getDescriptor(
						ClusterControlPlugin.IMG_STATUS_GREEN).createImage();
			return end;
		} else if (type == TYPE_WAITING) {
			if (waiting == null)
				waiting = registry.getDescriptor(
						ClusterControlPlugin.IMG_STATUS_WHITE).createImage();
			return waiting;
		} else if (type == TYPE_ERROR) {
			if (runError == null)
				runError = registry.getDescriptor(
						ClusterControlPlugin.IMG_STATUS_RED).createImage();
			return runError;
		}

		return null;
	}
}