#!/bin/bash

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../../hinemos.cfg
. ${SCRIPT_DIR}/../hinemos_utility.sh

export PROG=`basename $0`
DIR=`dirname $0`
USER=`/usr/bin/whoami`
HOST=`hostname`

########################################
#  Local Variable
########################################

VERSION=`cat ${HINEMOS_HOME}/_version`

PGPORT=24001
DBNAME=hinemos
USER=hinemos

PSQLCMD="${PG_HOME}/bin/psql -p ${PGPORT} -U ${USER} -d ${DBNAME} "

########################################
#  Local Message
########################################

# INFO
MSG_I001="clearing temporary queue data (messages in queue and transaction files)"
MSG_I002="   - hinemos version (installed) : "
MSG_I003="removed cc_log_async_task records."
MSG_I004="successful in clearing queue temporary data."

# WARN
#MSG_W001="xxx"

# ERROR
MSG_E001="failed to truncate cc_log_async_task table."
MSG_E002="failed to clear temporary data."

########################################
# Function
########################################

#
# show usage
#
function usage {
	echo "usage : ${PROG}"
	echo "  -w passwd  set password (for Hinemos RDBM Server)"
}

#
# truncate async worker persistence tables in PostgreSQL
#
function clean_asynctask_table {
	AskPostgreSQLPasswd
	
	MSG=`${PSQLCMD} -c "TRUNCATE TABLE cc_log_async_task" > /dev/null 2>&1`
	RET=$?
	if [ ${RET} -ne 0 ]
	then
		Logging "$MSG"
		Logging "${MSG_E001}"
		RET=$((16 + ${RET}))
		return ${RET}
	fi
	Logging "${MSG_I003}"
	
	return 0
}

########################################
# SHELL
########################################

# check parameters
for OPT in $@
do
	case $OPT in
		--help)
			usage
			exit 0
			;;
	esac
done

# option check
while getopts w: OPT
do
	case $OPT in
		w)
			export PGPASSWORD=${OPTARG}
			;;
		*)
			ExitIllegalOptionErrorWithoutLogger
			;;
	esac
done

shift $(( $OPTIND - 1 ))

if [ ! $# = 0 ]
then
	ExitIllegalArgumentError
fi

# chekc user
CheckUser ${JVM_USER}

# check process
CheckJVMProcessStopped
CheckPostgreSQLProcessRunning

# main
Logging "${MSG_I001}"
Logging "${MSG_I002}${VERSION}"

clean_asynctask_table
RET=$?
if [ ${RET} -ne 0 ]
then
	Logging "${MSG_E002}"

	exit ${RET}
fi

########################################
# Termination Processing
########################################

Logging "${MSG_I004}"
exit ${RET}
