package com.clustercontrol.performance.monitor.model;

import java.io.Serializable;
import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;


import java.util.List;


/**
 * The persistent class for the cc_snmp_value_type_mst database table.
 * 
 */
@Entity
@Table(name="cc_snmp_value_type_mst")
@Cacheable(true)
public class SnmpValueTypeMstEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private String valueType;
	private List<CollectorPollingMstEntity> collectorPollingMstEntities;

	@Deprecated
	public SnmpValueTypeMstEntity() {
	}

	public SnmpValueTypeMstEntity(String valueType) {
		this.setValueType(valueType);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
	}


	@Id
	@Column(name="value_type")
	public String getValueType() {
		return this.valueType;
	}

	public void setValueType(String valueType) {
		this.valueType = valueType;
	}


	//bi-directional many-to-one association to CollectorPollingMstEntity
	@OneToMany(mappedBy="snmpValueTypeMstEntity", fetch=FetchType.LAZY)
	public List<CollectorPollingMstEntity> getCollectorPollingMstEntities() {
		return this.collectorPollingMstEntities;
	}

	public void setCollectorPollingMstEntities(List<CollectorPollingMstEntity> collectorPollingMstEntities) {
		this.collectorPollingMstEntities = collectorPollingMstEntities;
	}

}