package com.clustercontrol.notify.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;


/**
 * The persistent class for the cc_notify_command_info database table.
 * 
 */
@Entity
@Table(name="cc_notify_command_info")
@Cacheable(true)
public class NotifyCommandInfoEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private NotifyCommandInfoEntityPK id;
	private String command;
	private Long commandTimeout;
	private String effectiveUser;
	private Integer setEnvironment;
	private Integer validFlg;
	private NotifyInfoEntity notifyInfoEntity;

	@Deprecated
	public NotifyCommandInfoEntity() {
	}

	public NotifyCommandInfoEntity(NotifyCommandInfoEntityPK pk,
			NotifyInfoEntity notifyInfoEntity) {
		this.setId(pk);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
		this.relateToNotifyInfoEntity(notifyInfoEntity);
	}

	public NotifyCommandInfoEntity(String notifyId, Integer priority,
			NotifyInfoEntity notifyInfoEntity) {
		this(new NotifyCommandInfoEntityPK(notifyId, priority), notifyInfoEntity);
	}


	@EmbeddedId
	public NotifyCommandInfoEntityPK getId() {
		return this.id;
	}

	public void setId(NotifyCommandInfoEntityPK id) {
		this.id = id;
	}


	public String getCommand() {
		return this.command;
	}

	public void setCommand(String command) {
		this.command = command;
	}


	@Column(name="command_timeout")
	public Long getCommandTimeout() {
		return this.commandTimeout;
	}

	public void setCommandTimeout(Long commandTimeout) {
		this.commandTimeout = commandTimeout;
	}


	@Column(name="effective_user")
	public String getEffectiveUser() {
		return this.effectiveUser;
	}

	public void setEffectiveUser(String effectiveUser) {
		this.effectiveUser = effectiveUser;
	}


	@Column(name="set_environment")
	public Integer getSetEnvironment() {
		return this.setEnvironment;
	}

	public void setSetEnvironment(Integer setEnvironment) {
		this.setEnvironment = setEnvironment;
	}


	@Column(name="valid_flg")
	public Integer getValidFlg() {
		return this.validFlg;
	}

	public void setValidFlg(Integer validFlg) {
		this.validFlg = validFlg;
	}


	//bi-directional many-to-one association to NotifyInfoEntity
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="notify_id", insertable=false, updatable=false)
	public NotifyInfoEntity getNotifyInfoEntity() {
		return this.notifyInfoEntity;
	}

	@Deprecated
	public void setNotifyInfoEntity(NotifyInfoEntity notifyInfoEntity) {
		this.notifyInfoEntity = notifyInfoEntity;
	}

	/**
	 * NotifyInfoEntityオブジェクト参照設定<BR>
	 * 
	 * NotifyInfoEntity設定時はSetterに代わりこちらを使用すること。
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void relateToNotifyInfoEntity(NotifyInfoEntity notifyInfoEntity) {
		this.setNotifyInfoEntity(notifyInfoEntity);
		if (notifyInfoEntity != null) {
			List<NotifyCommandInfoEntity> list = notifyInfoEntity.getNotifyCommandInfoEntities();
			if (list == null) {
				list = new ArrayList<NotifyCommandInfoEntity>();
			} else {
				for(NotifyCommandInfoEntity entity : list){
					if (entity.getId().equals(this.getId())) {
						return;
					}
				}
			}
			list.add(this);
			notifyInfoEntity.setNotifyCommandInfoEntities(list);
		}
	}

	/**
	 * 削除前処理<BR>
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void unchain() {

		// NotifyInfoEntity
		if (this.notifyInfoEntity != null) {
			List<NotifyCommandInfoEntity> list = this.notifyInfoEntity.getNotifyCommandInfoEntities();
			if (list != null) {
				Iterator<NotifyCommandInfoEntity> iter = list.iterator();
				while(iter.hasNext()) {
					NotifyCommandInfoEntity entity = iter.next();
					if (entity.getId().equals(this.getId())){
						iter.remove();
						break;
					}
				}
			}
		}
	}

}