package com.clustercontrol.collectiverun.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;


/**
 * The persistent class for the cc_crun_session_param database table.
 * 
 */
@Entity
@Table(name="cc_crun_session_param")
public class CrunSessionParamEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private CrunSessionParamEntityPK id;
	private String paramValue;
	private CrunSessionEntity crunSessionEntity;

	@Deprecated
	public CrunSessionParamEntity() {
	}

	public CrunSessionParamEntity(CrunSessionParamEntityPK pk,
			CrunSessionEntity crunSessionEntity) {
		this.setId(pk);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
		this.relateToCrunSessionEntity(crunSessionEntity);
	}

	public CrunSessionParamEntity(CrunSessionEntity crunSessionEntity, String paramId) {
		this(new CrunSessionParamEntityPK(
				crunSessionEntity.getSessionId(),
				paramId), crunSessionEntity);
	}

	@EmbeddedId
	public CrunSessionParamEntityPK getId() {
		return this.id;
	}

	public void setId(CrunSessionParamEntityPK id) {
		this.id = id;
	}


	@Column(name="param_value")
	public String getParamValue() {
		return this.paramValue;
	}

	public void setParamValue(String paramValue) {
		this.paramValue = paramValue;
	}


	//bi-directional many-to-one association to CrunSessionEntity
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="session_id", insertable=false, updatable=false)
	public CrunSessionEntity getCrunSessionEntity() {
		return this.crunSessionEntity;
	}

	@Deprecated
	public void setCrunSessionEntity(CrunSessionEntity crunSessionEntity) {
		this.crunSessionEntity = crunSessionEntity;
	}

	/**
	 * CrunSessionEntityオブジェクト参照設定<BR>
	 * 
	 * CrunSessionEntity設定時はSetterに代わりこちらを使用すること。
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void relateToCrunSessionEntity(CrunSessionEntity crunSessionEntity) {
		this.setCrunSessionEntity(crunSessionEntity);
		if (crunSessionEntity != null) {
			List<CrunSessionParamEntity> list = crunSessionEntity.getCrunSessionParamEntities();
			if (list == null) {
				list = new ArrayList<CrunSessionParamEntity>();
			} else {
				for(CrunSessionParamEntity entity : list){
					if (entity.getId().equals(this.getId())) {
						return;
					}
				}
			}
			list.add(this);
			crunSessionEntity.setCrunSessionParamEntities(list);
		}
	}

	/**
	 * 削除前処理<BR>
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void unchain() {

		// CrunSessionEntity
		if (this.crunSessionEntity != null) {
			List<CrunSessionParamEntity> list = this.crunSessionEntity.getCrunSessionParamEntities();
			if (list != null) {
				Iterator<CrunSessionParamEntity> iter = list.iterator();
				while(iter.hasNext()) {
					CrunSessionParamEntity entity = iter.next();
					if (entity.getId().equals(this.getId())){
						iter.remove();
						break;
					}
				}
			}
		}
	}

}