/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.jpasecurity.ExceptionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXmlParser<H extends DefaultHandler> {
    private static final Log LOG = LogFactory.getLog(AbstractXmlParser.class);
    private H handler;
    private ExceptionFactory exceptionFactory;

    public AbstractXmlParser(H xmlHandler, ExceptionFactory factory) {
        this.handler = xmlHandler;
        this.exceptionFactory = factory;
    }

    protected H getHandler() {
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(URL url) throws IOException {
        LOG.info((Object)("parsing " + url));
        InputStream stream = url.openStream();
        try {
            this.parse(stream);
        }
        finally {
            stream.close();
        }
    }

    public void parse(InputStream xml) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            SAXParser parser = factory.newSAXParser();
            parser.parse(xml, (DefaultHandler)this.handler);
        }
        catch (ParserConfigurationException e) {
            throw this.exceptionFactory.createRuntimeException(e);
        }
        catch (SAXException e) {
            throw this.exceptionFactory.createRuntimeException(e);
        }
        catch (IOException e) {
            throw this.exceptionFactory.createRuntimeException(e);
        }
    }
}

