/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.security.authentication;

import java.io.IOException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.jpasecurity.configuration.AuthenticationProvider;
import net.sf.jpasecurity.mapping.MappingInformation;
import net.sf.jpasecurity.mapping.MappingInformationReceiver;
import net.sf.jpasecurity.security.authentication.DeclareRolesParser;
import net.sf.jpasecurity.security.rules.WebXmlRolesParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRoleBasedAuthenticationProvider
implements AuthenticationProvider,
MappingInformationReceiver {
    private Set<String> roles = new HashSet<String>();

    @Override
    public void setMappingInformation(MappingInformation mappingInformation) {
        this.roles.addAll(new DeclareRolesParser().parseDeclaredRoles(mappingInformation.getSecureClasses()));
    }

    @Override
    public Object getPrincipal() {
        Principal principal = this.getCallerPrincipal();
        return principal != null ? principal.getName() : null;
    }

    public Collection<String> getRoles() {
        ArrayList<String> filteredRoles = new ArrayList<String>();
        for (String role : this.roles) {
            if (!this.isCallerInRole(role)) continue;
            filteredRoles.add(role);
        }
        return filteredRoles;
    }

    @Override
    public void setMappingProperties(Map<String, Object> properties) {
    }

    protected abstract Principal getCallerPrincipal();

    protected abstract boolean isCallerInRole(String var1);

    protected void parseWebXml(URL webXml) throws IOException {
        WebXmlRolesParser parser = new WebXmlRolesParser();
        parser.parse(webXml);
        this.roles.addAll(parser.getRoles());
    }
}

