/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.jpasecurity.SecureEntity;
import net.sf.jpasecurity.proxy.Decorator;
import net.sf.jpasecurity.proxy.MethodInterceptor;
import net.sf.jpasecurity.proxy.SecureEntityMethods;
import net.sf.jpasecurity.proxy.SecureEntityProxyFactory;
import net.sf.jpasecurity.proxy.SuperMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CgLibSecureEntityProxyFactory
implements SecureEntityProxyFactory {
    @Override
    public SecureEntity createSecureEntityProxy(Class<?> entityType, MethodInterceptor interceptor, Decorator<SecureEntity> decorator) {
        SecureEntity entity = (SecureEntity)Enhancer.create(entityType, (Class[])new Class[]{SecureEntity.class}, (Callback)new CgLibMethodInterceptor(interceptor, decorator));
        decorator.setDelegate(entity);
        return entity;
    }

    @Override
    public MethodInterceptor getInterceptor(SecureEntity entity) {
        return this.getCgLibMethodInterceptor(entity).interceptor;
    }

    @Override
    public Decorator<SecureEntity> getDecorator(SecureEntity entity) {
        return this.getCgLibMethodInterceptor(entity).decorator;
    }

    private CgLibMethodInterceptor getCgLibMethodInterceptor(SecureEntity entity) {
        try {
            for (Callback callback : this.getCallbacks(entity)) {
                if (!(callback instanceof CgLibMethodInterceptor)) continue;
                return (CgLibMethodInterceptor)callback;
            }
            throw new IllegalArgumentException("The specified object was not created by this factory");
        }
        catch (SecurityException e) {
            if (e.getCause() instanceof NoSuchMethodException) {
                throw new IllegalArgumentException("The specified object was not created by this factory");
            }
            throw e;
        }
    }

    private Callback[] getCallbacks(SecureEntity entity) {
        if (entity instanceof Factory) {
            return ((Factory)entity).getCallbacks();
        }
        throw new IllegalArgumentException("The specified object was not created by this factory");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CgLibSecureEntityMethod
    implements SuperMethod {
        private Decorator<SecureEntity> secureEntityDecorator;
        private Method method;

        public CgLibSecureEntityMethod(Decorator<SecureEntity> secureEntityDecorator, Method method) {
            this.secureEntityDecorator = secureEntityDecorator;
            this.method = method;
        }

        @Override
        public Object invoke(Object object, Object ... args) throws IllegalAccessException, InvocationTargetException {
            return this.method.invoke(this.secureEntityDecorator, args);
        }
    }

    private class CgLibSuperMethod
    implements SuperMethod {
        private MethodProxy proxy;

        public CgLibSuperMethod(MethodProxy proxy) {
            this.proxy = proxy;
        }

        public Object invoke(Object object, Object ... args) throws IllegalAccessException, InvocationTargetException {
            try {
                return this.proxy.invokeSuper(object, args);
            }
            catch (Throwable e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CgLibMethodInterceptor
    implements net.sf.cglib.proxy.MethodInterceptor {
        private MethodInterceptor interceptor;
        private Decorator<SecureEntity> decorator;

        public CgLibMethodInterceptor(MethodInterceptor interceptor, Decorator<SecureEntity> decorator) {
            this.interceptor = interceptor;
            this.decorator = decorator;
        }

        public Object intercept(Object object, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            SuperMethod superMethod = SecureEntityMethods.contains(method) ? new CgLibSecureEntityMethod(this.decorator, method) : new CgLibSuperMethod(proxy);
            return this.interceptor.intercept(object, method, superMethod, args);
        }
    }
}

