/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.mapping;

import java.util.Collections;
import java.util.Set;
import net.sf.jpasecurity.CascadeType;
import net.sf.jpasecurity.ExceptionFactory;
import net.sf.jpasecurity.FetchType;
import net.sf.jpasecurity.mapping.ClassMappingInformation;
import net.sf.jpasecurity.mapping.PropertyAccessStrategy;
import net.sf.jpasecurity.mapping.PropertyMappingInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyMappingInformation
implements PropertyMappingInformation {
    private String name;
    private ClassMappingInformation containingClassMapping;
    private boolean idProperty;
    private boolean versionProperty;
    private boolean generatedValue;
    private PropertyAccessStrategy propertyAccessStrategy;

    AbstractPropertyMappingInformation(String propertyName, ClassMappingInformation classMapping, PropertyAccessStrategy accessStrategy, ExceptionFactory exceptionFactory) {
        if (propertyName == null) {
            throw new IllegalArgumentException("property name not specified");
        }
        if (classMapping == null) {
            throw exceptionFactory.createMappingException("class is no entity class");
        }
        if (accessStrategy == null) {
            throw new IllegalArgumentException("PropertyAccessStrategy may not be null");
        }
        this.name = propertyName;
        this.containingClassMapping = classMapping;
        this.propertyAccessStrategy = accessStrategy;
    }

    public PropertyAccessStrategy getPropertyAccessStrategy() {
        return this.propertyAccessStrategy;
    }

    @Override
    public boolean isSingleValued() {
        return true;
    }

    @Override
    public boolean isManyValued() {
        return !this.isSingleValued();
    }

    @Override
    public boolean isRelationshipMapping() {
        return false;
    }

    @Override
    public boolean isIdProperty() {
        return this.idProperty;
    }

    void setIdProperty(boolean idProperty) {
        this.idProperty = idProperty;
    }

    @Override
    public boolean isVersionProperty() {
        return this.versionProperty;
    }

    void setVersionProperty(boolean versionProperty) {
        this.versionProperty = versionProperty;
    }

    @Override
    public boolean isGeneratedValue() {
        return this.generatedValue;
    }

    void setGeneratedValue(boolean generatedValue) {
        this.generatedValue = generatedValue;
    }

    @Override
    public String getPropertyName() {
        return this.name;
    }

    @Override
    public abstract Class<?> getProperyType();

    @Override
    public FetchType getFetchType() {
        return FetchType.EAGER;
    }

    @Override
    public Set<CascadeType> getCascadeTypes() {
        return Collections.emptySet();
    }

    @Override
    public Object getPropertyValue(Object target) {
        return this.propertyAccessStrategy.getPropertyValue(target);
    }

    @Override
    public void setPropertyValue(Object target, Object value) {
        this.propertyAccessStrategy.setPropertyValue(target, value);
    }

    @Override
    public ClassMappingInformation getContainingClassMapping() {
        return this.containingClassMapping;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.name + ",containingClassMapping=" + this.containingClassMapping.getEntityType().getSimpleName() + "]";
    }
}

