/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.jpql.compiler;

import java.util.HashSet;
import java.util.Set;
import net.sf.jpasecurity.ExceptionFactory;
import net.sf.jpasecurity.configuration.SecurityContext;
import net.sf.jpasecurity.jpql.parser.JpqlFromItem;
import net.sf.jpasecurity.jpql.parser.JpqlInnerFetchJoin;
import net.sf.jpasecurity.jpql.parser.JpqlInnerJoin;
import net.sf.jpasecurity.jpql.parser.JpqlOuterFetchJoin;
import net.sf.jpasecurity.jpql.parser.JpqlOuterJoin;
import net.sf.jpasecurity.jpql.parser.JpqlPath;
import net.sf.jpasecurity.jpql.parser.JpqlSubselect;
import net.sf.jpasecurity.jpql.parser.JpqlVisitorAdapter;
import net.sf.jpasecurity.jpql.parser.Node;
import net.sf.jpasecurity.mapping.Alias;
import net.sf.jpasecurity.mapping.ClassMappingInformation;
import net.sf.jpasecurity.mapping.MappingInformation;
import net.sf.jpasecurity.mapping.PropertyMappingInformation;
import net.sf.jpasecurity.mapping.SimplePropertyMappingInformation;
import net.sf.jpasecurity.mapping.TypeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingEvaluator
extends JpqlVisitorAdapter<Set<TypeDefinition>> {
    private MappingInformation mappingInformation;
    private SecurityContext securityContext;
    private ExceptionFactory exceptionFactory;

    public MappingEvaluator(MappingInformation mappingInformation, SecurityContext securityContext, ExceptionFactory exceptionFactory) {
        if (mappingInformation == null) {
            throw new IllegalArgumentException("mappingInformation may not be null");
        }
        if (securityContext == null) {
            throw new IllegalArgumentException("securityContext may not be null");
        }
        if (exceptionFactory == null) {
            throw new IllegalArgumentException("exceptionFactory may not be null");
        }
        this.mappingInformation = mappingInformation;
        this.securityContext = securityContext;
        this.exceptionFactory = exceptionFactory;
    }

    public void evaluate(Node node, Set<TypeDefinition> typeDefinitions) {
        node.visit(this, typeDefinitions);
    }

    @Override
    public boolean visit(JpqlPath node, Set<TypeDefinition> typeDefinitions) {
        Alias alias = new Alias(node.jjtGetChild(0).getValue());
        Class<?> type = this.getType(alias, typeDefinitions);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            String propertyName;
            ClassMappingInformation classMapping = this.mappingInformation.getClassMapping(type);
            PropertyMappingInformation propertyMapping = classMapping.getPropertyMapping(propertyName = node.jjtGetChild(i).getValue());
            if (propertyMapping instanceof SimplePropertyMappingInformation && i < node.jjtGetNumChildren() - 1) {
                String error = "Cannot navigate through simple property in class " + type.getName();
                throw this.exceptionFactory.createInvalidPathException(propertyName, error);
            }
            type = propertyMapping.getProperyType();
        }
        return false;
    }

    @Override
    public boolean visit(JpqlSubselect node, Set<TypeDefinition> typeDefinitions) {
        HashSet<TypeDefinition> subselectDefinitions = new HashSet<TypeDefinition>(typeDefinitions);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).visit(this, subselectDefinitions);
        }
        node.jjtGetChild(0).visit(this, subselectDefinitions);
        return false;
    }

    @Override
    public boolean visit(JpqlFromItem node, Set<TypeDefinition> typeDefinitions) {
        String typeName = node.jjtGetChild(0).toString().trim();
        Alias alias = new Alias(node.jjtGetChild(1).toString().trim());
        typeDefinitions.add(new TypeDefinition(alias, this.mappingInformation.getClassMapping(typeName).getEntityType()));
        return false;
    }

    @Override
    public boolean visit(JpqlInnerJoin node, Set<TypeDefinition> typeDefinitions) {
        return this.visitJoin(node, typeDefinitions);
    }

    @Override
    public boolean visit(JpqlOuterJoin node, Set<TypeDefinition> typeDefinitions) {
        return this.visitJoin(node, typeDefinitions);
    }

    @Override
    public boolean visit(JpqlInnerFetchJoin node, Set<TypeDefinition> typeDefinitions) {
        return this.visitJoin(node, typeDefinitions);
    }

    @Override
    public boolean visit(JpqlOuterFetchJoin node, Set<TypeDefinition> typeDefinitions) {
        return this.visitJoin(node, typeDefinitions);
    }

    public boolean visitJoin(Node node, Set<TypeDefinition> typeDefinitions) {
        if (node.jjtGetNumChildren() != 2) {
            return false;
        }
        Node pathNode = node.jjtGetChild(0);
        Node aliasNode = node.jjtGetChild(1);
        Alias rootAlias = new Alias(pathNode.jjtGetChild(0).toString());
        Class<?> rootType = this.getType(rootAlias, typeDefinitions);
        ClassMappingInformation classMapping = this.mappingInformation.getClassMapping(rootType);
        for (int i = 1; i < pathNode.jjtGetNumChildren(); ++i) {
            Class<?> propertyType = classMapping.getPropertyMapping(pathNode.jjtGetChild(i).toString()).getProperyType();
            classMapping = this.mappingInformation.getClassMapping(propertyType);
        }
        typeDefinitions.add(new TypeDefinition(new Alias(aliasNode.toString()), classMapping.getEntityType()));
        return false;
    }

    public Class<?> getType(Alias alias, Set<TypeDefinition> typeDefinitions) {
        if (this.securityContext.getAliases().contains(alias)) {
            Object aliasValue = this.securityContext.getAliasValues(alias);
            if (aliasValue != null) {
                return aliasValue.getClass();
            }
            aliasValue = this.securityContext.getAliasValue(alias);
            return aliasValue == null ? Object.class : aliasValue.getClass();
        }
        for (TypeDefinition typeDefinition : typeDefinitions) {
            if (!alias.equals(typeDefinition.getAlias())) continue;
            return typeDefinition.getType();
        }
        throw this.exceptionFactory.createTypeDefinitionNotFoundException(alias.getName());
    }
}

