/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.jpql.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jpasecurity.ExceptionFactory;
import net.sf.jpasecurity.configuration.DefaultExceptionFactory;
import net.sf.jpasecurity.jpql.JpqlCompiledStatement;
import net.sf.jpasecurity.jpql.parser.JpqlConstructorParameter;
import net.sf.jpasecurity.jpql.parser.JpqlCount;
import net.sf.jpasecurity.jpql.parser.JpqlFromItem;
import net.sf.jpasecurity.jpql.parser.JpqlIdentificationVariable;
import net.sf.jpasecurity.jpql.parser.JpqlInCollection;
import net.sf.jpasecurity.jpql.parser.JpqlInnerFetchJoin;
import net.sf.jpasecurity.jpql.parser.JpqlInnerJoin;
import net.sf.jpasecurity.jpql.parser.JpqlNamedInputParameter;
import net.sf.jpasecurity.jpql.parser.JpqlOuterFetchJoin;
import net.sf.jpasecurity.jpql.parser.JpqlOuterJoin;
import net.sf.jpasecurity.jpql.parser.JpqlPath;
import net.sf.jpasecurity.jpql.parser.JpqlPositionalInputParameter;
import net.sf.jpasecurity.jpql.parser.JpqlSelectExpression;
import net.sf.jpasecurity.jpql.parser.JpqlStatement;
import net.sf.jpasecurity.jpql.parser.JpqlSubselect;
import net.sf.jpasecurity.jpql.parser.JpqlVisitorAdapter;
import net.sf.jpasecurity.jpql.parser.Node;
import net.sf.jpasecurity.jpql.parser.ToStringVisitor;
import net.sf.jpasecurity.mapping.Alias;
import net.sf.jpasecurity.mapping.ClassMappingInformation;
import net.sf.jpasecurity.mapping.MappingInformation;
import net.sf.jpasecurity.mapping.TypeDefinition;
import net.sf.jpasecurity.util.ValueHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpqlCompiler {
    protected final ExceptionFactory exceptionFactory;
    private final MappingInformation mappingInformation;
    private final SelectVisitor selectVisitor = new SelectVisitor();
    private final AliasVisitor aliasVisitor = new AliasVisitor();
    private final CountVisitor countVisitor = new CountVisitor();
    private final PathVisitor pathVisitor = new PathVisitor();
    private final NamedParameterVisitor namedParameterVisitor = new NamedParameterVisitor();
    private final PositionalParameterVisitor positionalParameterVisitor = new PositionalParameterVisitor();

    public JpqlCompiler(MappingInformation mappingInformation) {
        this(mappingInformation, new DefaultExceptionFactory());
    }

    public JpqlCompiler(MappingInformation mappingInformation, ExceptionFactory exceptionFactory) {
        this.mappingInformation = mappingInformation;
        this.exceptionFactory = exceptionFactory;
    }

    public JpqlCompiledStatement compile(JpqlStatement statement) {
        return this.compile((Node)statement);
    }

    public JpqlCompiledStatement compile(JpqlSubselect statement) {
        return this.compile((Node)statement);
    }

    private JpqlCompiledStatement compile(Node statement) {
        List<String> selectedPathes = this.getSelectedPaths(statement);
        Set<TypeDefinition> typeDefinitions = this.getAliasDefinitions(statement);
        Set<String> namedParameters = this.getNamedParameters(statement);
        return new JpqlCompiledStatement(statement, selectedPathes, typeDefinitions, namedParameters);
    }

    public List<String> getSelectedPaths(Node node) {
        if (node == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList selectedPaths = new ArrayList();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).visit(this.selectVisitor, selectedPaths);
        }
        return Collections.unmodifiableList(selectedPaths);
    }

    public Set<TypeDefinition> getAliasDefinitions(Node node) {
        if (node == null) {
            return Collections.emptySet();
        }
        HashSet typeDefinitions = new HashSet();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).visit(this.aliasVisitor, typeDefinitions);
        }
        return Collections.unmodifiableSet(typeDefinitions);
    }

    public Set<String> getNamedParameters(Node node) {
        if (node == null) {
            return Collections.emptySet();
        }
        HashSet namedParameters = new HashSet();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).visit(this.namedParameterVisitor, namedParameters);
        }
        return Collections.unmodifiableSet(namedParameters);
    }

    public Set<String> getPositionalParameters(Node node) {
        if (node == null) {
            return Collections.emptySet();
        }
        HashSet positionalParameters = new HashSet();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).visit(this.positionalParameterVisitor, positionalParameters);
        }
        return Collections.unmodifiableSet(positionalParameters);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CountVisitor
    extends JpqlVisitorAdapter<ValueHolder<Boolean>> {
        private CountVisitor() {
        }

        public boolean isCount(Node node) {
            ValueHolder<Boolean> result = new ValueHolder<Boolean>(Boolean.FALSE);
            node.visit(this, result);
            return result.getValue();
        }

        @Override
        public boolean visit(JpqlCount node, ValueHolder<Boolean> result) {
            result.setValue(Boolean.TRUE);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathVisitor
    extends JpqlVisitorAdapter<ValueHolder<String>> {
        private PathVisitor() {
        }

        public String getPath(Node node) {
            ValueHolder result = new ValueHolder();
            node.visit(this, result);
            return (String)result.getValue();
        }

        @Override
        public boolean visit(JpqlPath node, ValueHolder<String> result) {
            result.setValue(node.toString());
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PositionalParameterVisitor
    extends JpqlVisitorAdapter<Set<String>> {
        private PositionalParameterVisitor() {
        }

        @Override
        public boolean visit(JpqlPositionalInputParameter node, Set<String> positionalParameters) {
            positionalParameters.add(node.getValue());
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NamedParameterVisitor
    extends JpqlVisitorAdapter<Set<String>> {
        private NamedParameterVisitor() {
        }

        @Override
        public boolean visit(JpqlNamedInputParameter node, Set<String> namedParameters) {
            namedParameters.add(node.getValue());
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AliasVisitor
    extends JpqlVisitorAdapter<Set<TypeDefinition>> {
        private AliasVisitor() {
        }

        @Override
        public boolean visit(JpqlSelectExpression node, Set<TypeDefinition> typeDefinitions) {
            if (node.jjtGetNumChildren() == 1) {
                return false;
            }
            String path = JpqlCompiler.this.pathVisitor.getPath(node);
            Alias alias = this.getAlias(node);
            Class type = null;
            if (JpqlCompiler.this.countVisitor.isCount(node)) {
                type = Long.class;
            } else {
                try {
                    type = JpqlCompiler.this.mappingInformation.getType(path, typeDefinitions);
                }
                catch (TypeNotPresentException e) {
                    type = null;
                }
            }
            typeDefinitions.add(new TypeDefinition(alias, type, path, path.contains("."), false));
            return false;
        }

        @Override
        public boolean visit(JpqlFromItem node, Set<TypeDefinition> typeDefinitions) {
            String abstractSchemaName = node.jjtGetChild(0).toString().trim();
            Alias alias = this.getAlias(node);
            HashSet types = new HashSet();
            if (JpqlCompiler.this.mappingInformation.containsClassMapping(abstractSchemaName)) {
                types.add(JpqlCompiler.this.mappingInformation.getClassMapping(abstractSchemaName).getEntityType());
            } else {
                try {
                    Class<?> type = Thread.currentThread().getContextClassLoader().loadClass(abstractSchemaName);
                    Collection<ClassMappingInformation> collection = JpqlCompiler.this.mappingInformation.resolveClassMappings(type);
                    for (ClassMappingInformation classMapping : collection) {
                        types.add(classMapping.getEntityType());
                    }
                }
                catch (ClassNotFoundException e) {
                    throw JpqlCompiler.this.exceptionFactory.createTypeNotFoundException(abstractSchemaName.trim());
                }
            }
            if (types.isEmpty()) {
                throw JpqlCompiler.this.exceptionFactory.createTypeNotFoundException(abstractSchemaName.trim());
            }
            for (Class clazz : types) {
                typeDefinitions.add(new TypeDefinition(alias, clazz));
            }
            this.determinePreliminaryTypes(typeDefinitions);
            return false;
        }

        @Override
        public boolean visit(JpqlInCollection node, Set<TypeDefinition> typeDefinitions) {
            return this.visitJoin(node, typeDefinitions, true, false);
        }

        @Override
        public boolean visit(JpqlInnerJoin node, Set<TypeDefinition> typeDefinitions) {
            return this.visitJoin(node, typeDefinitions, true, false);
        }

        @Override
        public boolean visit(JpqlOuterJoin node, Set<TypeDefinition> typeDefinitions) {
            return this.visitJoin(node, typeDefinitions, false, false);
        }

        @Override
        public boolean visit(JpqlOuterFetchJoin node, Set<TypeDefinition> typeDefinitions) {
            return this.visitJoin(node, typeDefinitions, false, true);
        }

        @Override
        public boolean visit(JpqlInnerFetchJoin node, Set<TypeDefinition> typeDefinitions) {
            return this.visitJoin(node, typeDefinitions, true, true);
        }

        private boolean visitJoin(Node node, Set<TypeDefinition> typeDefinitions, boolean innerJoin, boolean fetchJoin) {
            String fetchPath = node.jjtGetChild(0).toString();
            Class type = JpqlCompiler.this.mappingInformation.getType(fetchPath, typeDefinitions);
            if (node.jjtGetNumChildren() == 1) {
                typeDefinitions.add(new TypeDefinition(type, fetchPath, innerJoin, fetchJoin));
            } else {
                Alias alias = this.getAlias(node);
                typeDefinitions.add(new TypeDefinition(alias, type, fetchPath, innerJoin, fetchJoin));
            }
            return false;
        }

        @Override
        public boolean visit(JpqlSubselect node, Set<TypeDefinition> typeDefinitions) {
            return false;
        }

        private Alias getAlias(Node node) {
            return new Alias(node.jjtGetChild(1).toString());
        }

        private void determinePreliminaryTypes(Set<TypeDefinition> typeDefinitions) {
            for (TypeDefinition typeDefinition : typeDefinitions) {
                if (!typeDefinition.isPreliminary()) continue;
                try {
                    Class type = JpqlCompiler.this.mappingInformation.getType(typeDefinition.getJoinPath(), typeDefinitions);
                    typeDefinition.setType(type);
                }
                catch (TypeNotPresentException e) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectPathVisitor
    extends JpqlVisitorAdapter<List<String>> {
        private final ToStringVisitor toStringVisitor = new ToStringVisitor();

        private SelectPathVisitor() {
        }

        @Override
        public boolean visit(JpqlPath node, List<String> selectedPaths) {
            return this.extractSelectedPath(node, selectedPaths);
        }

        @Override
        public boolean visit(JpqlIdentificationVariable node, List<String> selectedPaths) {
            return this.extractSelectedPath(node, selectedPaths);
        }

        private boolean extractSelectedPath(Node node, List<String> selectedPaths) {
            StringBuilder path = new StringBuilder();
            node.visit(this.toStringVisitor, path);
            selectedPaths.add(path.toString());
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectVisitor
    extends JpqlVisitorAdapter<List<String>> {
        private final SelectPathVisitor selectPathVisitor;

        private SelectVisitor() {
            this.selectPathVisitor = new SelectPathVisitor();
        }

        @Override
        public boolean visit(JpqlSelectExpression node, List<String> selectedPaths) {
            node.visit(this.selectPathVisitor, selectedPaths);
            return false;
        }

        @Override
        public boolean visit(JpqlConstructorParameter node, List<String> selectedPaths) {
            node.visit(this.selectPathVisitor, selectedPaths);
            return false;
        }

        @Override
        public boolean visit(JpqlSubselect node, List<String> selectedPaths) {
            return false;
        }
    }
}

