/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.jpql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jpasecurity.jpql.parser.JpqlFrom;
import net.sf.jpasecurity.jpql.parser.JpqlParserVisitor;
import net.sf.jpasecurity.jpql.parser.JpqlPath;
import net.sf.jpasecurity.jpql.parser.JpqlSubselect;
import net.sf.jpasecurity.jpql.parser.JpqlVisitorAdapter;
import net.sf.jpasecurity.jpql.parser.JpqlWhere;
import net.sf.jpasecurity.jpql.parser.Node;
import net.sf.jpasecurity.util.ValueHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpqlStatementHolder
implements Cloneable {
    private Node statement;
    private JpqlFrom fromClause;
    private JpqlWhere whereClause;
    private List<JpqlPath> whereClausePaths;

    public JpqlStatementHolder(Node statement) {
        this.statement = statement;
    }

    public Node getStatement() {
        return this.statement;
    }

    public JpqlFrom getFromClause() {
        if (this.fromClause == null) {
            FromVisitor visitor = new FromVisitor();
            ValueHolder fromClauseHolder = new ValueHolder();
            this.visit(visitor, fromClauseHolder);
            this.fromClause = (JpqlFrom)fromClauseHolder.getValue();
        }
        return this.fromClause;
    }

    public JpqlWhere getWhereClause() {
        if (this.whereClause == null) {
            WhereVisitor visitor = new WhereVisitor();
            ValueHolder whereClauseHolder = new ValueHolder();
            this.visit(visitor, whereClauseHolder);
            this.whereClause = (JpqlWhere)whereClauseHolder.getValue();
        }
        return this.whereClause;
    }

    public List<JpqlPath> getWhereClausePaths() {
        if (this.whereClausePaths == null) {
            PathVisitor visitor = new PathVisitor();
            ArrayList whereClausePaths = new ArrayList();
            JpqlWhere whereClause = this.getWhereClause();
            if (whereClause != null) {
                whereClause.visit(visitor, whereClausePaths);
            }
            this.whereClausePaths = Collections.unmodifiableList(whereClausePaths);
        }
        return this.whereClausePaths;
    }

    public JpqlStatementHolder clone() {
        try {
            JpqlStatementHolder statement = (JpqlStatementHolder)super.clone();
            statement.statement = statement.statement.clone();
            statement.fromClause = null;
            statement.whereClause = null;
            statement.whereClausePaths = null;
            return statement;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return this.getClass() + "[\"" + this.statement.toString() + "\"]";
    }

    protected <T> void visit(JpqlParserVisitor<T> visitor, T data) {
        this.statement.visit(visitor, data);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathVisitor
    extends JpqlVisitorAdapter<List<JpqlPath>> {
        private PathVisitor() {
        }

        @Override
        public boolean visit(JpqlPath path, List<JpqlPath> paths) {
            paths.add(path);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WhereVisitor
    extends JpqlVisitorAdapter<ValueHolder<JpqlWhere>> {
        private WhereVisitor() {
        }

        @Override
        public boolean visit(JpqlWhere whereClause, ValueHolder<JpqlWhere> whereClauseHolder) {
            whereClauseHolder.setValue(whereClause);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FromVisitor
    extends JpqlVisitorAdapter<ValueHolder<JpqlFrom>> {
        private FromVisitor() {
        }

        @Override
        public boolean visit(JpqlFrom fromClause, ValueHolder<JpqlFrom> fromClauseHolder) {
            fromClauseHolder.setValue(fromClause);
            return false;
        }

        @Override
        public boolean visit(JpqlSubselect node, ValueHolder<JpqlFrom> fromClauseHolder) {
            return false;
        }
    }
}

