/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.entity;

import net.sf.jpasecurity.AccessManager;
import net.sf.jpasecurity.AccessType;
import net.sf.jpasecurity.SecureEntity;
import net.sf.jpasecurity.entity.AbstractSecureObjectManager;
import net.sf.jpasecurity.mapping.BeanInitializer;
import net.sf.jpasecurity.mapping.ClassMappingInformation;
import net.sf.jpasecurity.proxy.Decorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureEntityDecorator
implements SecureEntity,
Decorator<SecureEntity> {
    private ClassMappingInformation mapping;
    private BeanInitializer beanInitializer;
    private AccessManager accessManager;
    private AbstractSecureObjectManager objectManager;
    private boolean initialized;
    boolean deleted;
    private SecureEntity delegate;
    private Object entity;
    private boolean isTransient;
    private transient ThreadLocal<Boolean> updating;

    public SecureEntityDecorator(ClassMappingInformation mapping, BeanInitializer beanInitializer, AccessManager accessManager, AbstractSecureObjectManager objectManager, Object entity) {
        this(mapping, beanInitializer, accessManager, objectManager, entity, false);
    }

    public SecureEntityDecorator(ClassMappingInformation mapping, BeanInitializer beanInitializer, AccessManager accessManager, AbstractSecureObjectManager objectManager, Object entity, boolean isTransient) {
        this.mapping = mapping;
        this.beanInitializer = beanInitializer;
        this.accessManager = accessManager;
        this.objectManager = objectManager;
        this.entity = entity;
        this.isTransient = isTransient;
    }

    @Override
    public void setDelegate(SecureEntity delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isAccessible(AccessType accessType) {
        return this.accessManager.isAccessible(accessType, this.entity);
    }

    @Override
    public boolean isRemoved() {
        return this.deleted;
    }

    @Override
    public void flush() {
        if (!this.isReadOnly() && this.isInitialized()) {
            this.objectManager.unsecureCopy(AccessType.UPDATE, this.delegate, this.entity);
        }
    }

    public boolean isReadOnly() {
        return this.isTransient;
    }

    @Override
    public void refresh() {
        this.refresh(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh(boolean checkAccess) {
        if (this.isUpdating()) {
            return;
        }
        try {
            this.setUpdating(true);
            boolean oldInitialized = this.initialized;
            this.entity = this.beanInitializer.initialize(this.entity);
            if (checkAccess && !this.accessManager.isAccessible(AccessType.READ, this.entity)) {
                throw new SecurityException("The current user is not permitted to access the specified object");
            }
            this.objectManager.secureCopy(this.entity, this.delegate);
            this.initialized = true;
            if (this.initialized != oldInitialized) {
                this.mapping.postLoad(this.delegate);
            }
        }
        finally {
            this.setUpdating(false);
        }
    }

    private boolean isUpdating() {
        return this.updating != null && this.updating.get() != null && this.updating.get() != false;
    }

    private void setUpdating(boolean isUpdating) {
        if (this.updating == null) {
            this.updating = new ThreadLocal();
        }
        if (isUpdating) {
            this.updating.set(true);
        } else {
            this.updating.remove();
        }
    }
}

