/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.configuration;

import java.lang.reflect.Member;
import net.sf.jpasecurity.ExceptionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExceptionFactory
implements ExceptionFactory {
    @Override
    public RuntimeException createTargetEntityNotFoundException(Member property) {
        String error = "Could not determine target entity for property \"" + property.getName() + "\" of class " + property.getDeclaringClass().getName();
        return this.createMappingException(error);
    }

    @Override
    public RuntimeException createMappingException(String message) {
        return this.createRuntimeException(message);
    }

    @Override
    public RuntimeException createTypeNotFoundException(Class<?> type) {
        return this.createTypeNotFoundException(type == null ? null : type.getName());
    }

    @Override
    public RuntimeException createTypeNotFoundException(String className) {
        return this.createRuntimeException("Mapping not found for type " + className);
    }

    @Override
    public RuntimeException createTypeDefinitionNotFoundException(String alias) {
        return this.createRuntimeException("Type not found for alias \"" + alias + '\"');
    }

    @Override
    public RuntimeException createPropertyNotFoundException(Class<?> type, String propertyName) {
        String message = "property \"" + propertyName + "\" of class \"" + type.getName() + "\" is not mapped";
        return this.createRuntimeException(message);
    }

    @Override
    public RuntimeException createInvalidPathException(String path, String error) {
        return this.createRuntimeException("invalid path " + path + ": " + error);
    }

    @Override
    public RuntimeException createRuntimeException(String message) {
        return this.createRuntimeException(message, null);
    }

    @Override
    public RuntimeException createRuntimeException(Throwable cause) {
        return this.createRuntimeException(null, cause);
    }

    @Override
    public abstract RuntimeException createRuntimeException(String var1, Throwable var2);
}

