package com.clustercontrol.notify.model;

import javax.persistence.*;

import com.clustercontrol.accesscontrol.annotation.HinemosObjectPrivilege;
import com.clustercontrol.accesscontrol.model.ObjectPrivilegeTargetEntity;
import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.commons.util.JpaTransactionManager;

import java.sql.Timestamp;
import java.util.List;


/**
 * The persistent class for the cc_notify_info database table.
 * 
 */
@Entity
@Table(name="cc_notify_info")
@Cacheable(true)
@HinemosObjectPrivilege(
		objectType=HinemosModuleConstant.PLATFORM_NOTIFY,
		isModifyCheck=true)
@AttributeOverride(name="objectId",
column=@Column(name="notify_id", insertable=false, updatable=false))
public class NotifyInfoEntity extends ObjectPrivilegeTargetEntity {
	private static final long serialVersionUID = 1L;
	private String notifyId;
	private String description;
	private Integer initialCount;
	private Integer notifyType;
	private Timestamp regDate;
	private String regUser;
	private Integer renotifyPeriod;
	private Integer renotifyType;
	private Timestamp updateDate;
	private String updateUser;
	private Integer validFlg;
	private List<NotifyCommandInfoEntity> notifyCommandInfoEntities;
	private List<NotifyEventInfoEntity> notifyEventInfoEntities;
	private List<NotifyHistoryEntity> notifyHistoryEntities;
	private List<NotifyJobInfoEntity> notifyJobInfoEntities;
	private List<NotifyLogEscalateInfoEntity> notifyLogEscalateInfoEntities;
	private List<NotifyMailInfoEntity> notifyMailInfoEntities;
	private List<NotifyStatusInfoEntity> notifyStatusInfoEntities;

	@Deprecated
	public NotifyInfoEntity() {
	}

	public NotifyInfoEntity(String notifyId) {
		this.setNotifyId(notifyId);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
		this.setObjectId(this.getNotifyId());
	}


	@Id
	@Column(name="notify_id")
	public String getNotifyId() {
		return this.notifyId;
	}

	public void setNotifyId(String notifyId) {
		this.notifyId = notifyId;
	}


	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}


	@Column(name="initial_count")
	public Integer getInitialCount() {
		return this.initialCount;
	}

	public void setInitialCount(Integer initialCount) {
		this.initialCount = initialCount;
	}


	@Column(name="notify_type")
	public Integer getNotifyType() {
		return this.notifyType;
	}

	public void setNotifyType(Integer notifyType) {
		this.notifyType = notifyType;
	}


	@Column(name="reg_date")
	public Timestamp getRegDate() {
		return this.regDate;
	}

	public void setRegDate(Timestamp regDate) {
		this.regDate = regDate;
	}


	@Column(name="reg_user")
	public String getRegUser() {
		return this.regUser;
	}

	public void setRegUser(String regUser) {
		this.regUser = regUser;
	}


	@Column(name="renotify_period")
	public Integer getRenotifyPeriod() {
		return this.renotifyPeriod;
	}

	public void setRenotifyPeriod(Integer renotifyPeriod) {
		this.renotifyPeriod = renotifyPeriod;
	}


	@Column(name="renotify_type")
	public Integer getRenotifyType() {
		return this.renotifyType;
	}

	public void setRenotifyType(Integer renotifyType) {
		this.renotifyType = renotifyType;
	}


	@Column(name="update_date")
	public Timestamp getUpdateDate() {
		return this.updateDate;
	}

	public void setUpdateDate(Timestamp updateDate) {
		this.updateDate = updateDate;
	}


	@Column(name="update_user")
	public String getUpdateUser() {
		return this.updateUser;
	}

	public void setUpdateUser(String updateUser) {
		this.updateUser = updateUser;
	}


	@Column(name="valid_flg")
	public Integer getValidFlg() {
		return this.validFlg;
	}

	public void setValidFlg(Integer validFlg) {
		this.validFlg = validFlg;
	}


	//bi-directional many-to-one association to NotifyCommandInfoEntity
	@OneToMany(mappedBy="notifyInfoEntity", cascade=CascadeType.ALL, orphanRemoval=true, fetch=FetchType.LAZY)
	public List<NotifyCommandInfoEntity> getNotifyCommandInfoEntities() {
		return this.notifyCommandInfoEntities;
	}

	public void setNotifyCommandInfoEntities(List<NotifyCommandInfoEntity> notifyCommandInfoEntities) {
		this.notifyCommandInfoEntities = notifyCommandInfoEntities;
	}


	//bi-directional many-to-one association to NotifyEventInfoEntity
	@OneToMany(mappedBy="notifyInfoEntity", cascade=CascadeType.ALL, orphanRemoval=true, fetch=FetchType.LAZY)
	public List<NotifyEventInfoEntity> getNotifyEventInfoEntities() {
		return this.notifyEventInfoEntities;
	}

	public void setNotifyEventInfoEntities(List<NotifyEventInfoEntity> notifyEventInfoEntities) {
		this.notifyEventInfoEntities = notifyEventInfoEntities;
	}


	/**
	 * ジョブからの通知はrelateされないので注意。
	 * relateするとメモリリークするので、relateしない設定となっています。
	 * @return
	 */
	//bi-directional many-to-one association to NotifyHistoryEntity
	@OneToMany(mappedBy="notifyInfoEntity", cascade=CascadeType.ALL, orphanRemoval=true, fetch=FetchType.LAZY)
	public List<NotifyHistoryEntity> getNotifyHistoryEntities() {
		return this.notifyHistoryEntities;
	}

	public void setNotifyHistoryEntities(List<NotifyHistoryEntity> notifyHistoryEntities) {
		this.notifyHistoryEntities = notifyHistoryEntities;
	}


	//bi-directional many-to-one association to NotifyJobInfoEntity
	@OneToMany(mappedBy="notifyInfoEntity", cascade=CascadeType.ALL, orphanRemoval=true, fetch=FetchType.LAZY)
	public List<NotifyJobInfoEntity> getNotifyJobInfoEntities() {
		return this.notifyJobInfoEntities;
	}

	public void setNotifyJobInfoEntities(List<NotifyJobInfoEntity> notifyJobInfoEntities) {
		this.notifyJobInfoEntities = notifyJobInfoEntities;
	}


	//bi-directional many-to-one association to NotifyLogEscalateInfoEntity
	@OneToMany(mappedBy="notifyInfoEntity", cascade=CascadeType.ALL, orphanRemoval=true, fetch=FetchType.LAZY)
	public List<NotifyLogEscalateInfoEntity> getNotifyLogEscalateInfoEntities() {
		return this.notifyLogEscalateInfoEntities;
	}

	public void setNotifyLogEscalateInfoEntities(List<NotifyLogEscalateInfoEntity> notifyLogEscalateInfoEntities) {
		this.notifyLogEscalateInfoEntities = notifyLogEscalateInfoEntities;
	}


	//bi-directional many-to-one association to NotifyMailInfoEntity
	@OneToMany(mappedBy="notifyInfoEntity", cascade=CascadeType.ALL, orphanRemoval=true, fetch=FetchType.LAZY)
	public List<NotifyMailInfoEntity> getNotifyMailInfoEntities() {
		return this.notifyMailInfoEntities;
	}

	public void setNotifyMailInfoEntities(List<NotifyMailInfoEntity> notifyMailInfoEntities) {
		this.notifyMailInfoEntities = notifyMailInfoEntities;
	}


	//bi-directional many-to-one association to NotifyStatusInfoEntity
	@OneToMany(mappedBy="notifyInfoEntity", cascade=CascadeType.ALL, orphanRemoval=true, fetch=FetchType.LAZY)
	public List<NotifyStatusInfoEntity> getNotifyStatusInfoEntities() {
		return this.notifyStatusInfoEntities;
	}

	public void setNotifyStatusInfoEntities(List<NotifyStatusInfoEntity> notifyStatusInfoEntities) {
		this.notifyStatusInfoEntities = notifyStatusInfoEntities;
	}

}