/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.util;

import com.clustercontrol.util.LoginManager;
import com.clustercontrol.ws.access.AccessEndpointService;
import com.clustercontrol.ws.calendar.CalendarEndpointService;
import com.clustercontrol.ws.collectiverun.CollectiveRunEndpointService;
import com.clustercontrol.ws.collectmaster.PerformanceCollectMasterEndpointService;
import com.clustercontrol.ws.collector.CollectorEndpointService;
import com.clustercontrol.ws.jobmanagement.JobEndpointService;
import com.clustercontrol.ws.jobmanagement.JobMapEndpointService;
import com.clustercontrol.ws.mailtemplate.MailTemplateEndpointService;
import com.clustercontrol.ws.maintenance.MaintenanceEndpointService;
import com.clustercontrol.ws.monitor.MonitorEndpointService;
import com.clustercontrol.ws.monitor.MonitorSettingEndpointService;
import com.clustercontrol.ws.monitor.MonitorSnmpTrapEndpointService;
import com.clustercontrol.ws.nodemap.NodeMapEndpointService;
import com.clustercontrol.ws.notify.NotifyEndpointService;
import com.clustercontrol.ws.repository.RepositoryEndpointService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EndpointManager {
    private static Log m_log = LogFactory.getLog(EndpointManager.class);
    private static EndpointList endpointList;
    private static final String ACCESS;
    private static final String CALENDAR;
    private static final String COLLECTIVE_RUN;
    private static final String COLLECTOR;
    private static final String JOB;
    private static final String JOBMAP;
    private static final String MAIL_TEMPLATE;
    private static final String MAINTENANCE;
    private static final String MONITOR;
    private static final String MONITOR_SETTING;
    private static final String MONITOR_SNMPTRAP;
    private static final String NODEMAP;
    private static final String NOTIFY;
    private static final String REPOSITORY;
    private static final String PERFORMANCE_COLLECT_MASTER;
    private static String username;
    private static String password;
    public static int m_httpConnectTimeout;
    public static int m_httpRequestTimeout;

    static {
        ACCESS = AccessEndpointService.class.getSimpleName();
        CALENDAR = CalendarEndpointService.class.getSimpleName();
        COLLECTIVE_RUN = CollectiveRunEndpointService.class.getSimpleName();
        COLLECTOR = CollectorEndpointService.class.getSimpleName();
        JOB = JobEndpointService.class.getSimpleName();
        JOBMAP = JobMapEndpointService.class.getSimpleName();
        MAIL_TEMPLATE = MailTemplateEndpointService.class.getSimpleName();
        MAINTENANCE = MaintenanceEndpointService.class.getSimpleName();
        MONITOR = MonitorEndpointService.class.getSimpleName();
        MONITOR_SETTING = MonitorSettingEndpointService.class.getSimpleName();
        MONITOR_SNMPTRAP = MonitorSnmpTrapEndpointService.class.getSimpleName();
        NODEMAP = NodeMapEndpointService.class.getSimpleName();
        NOTIFY = NotifyEndpointService.class.getSimpleName();
        REPOSITORY = RepositoryEndpointService.class.getSimpleName();
        PERFORMANCE_COLLECT_MASTER = PerformanceCollectMasterEndpointService.class.getSimpleName();
        username = "";
        password = "";
        m_httpConnectTimeout = 10;
        m_httpRequestTimeout = 60;
    }

    public static void init(String user, String pass, String managerAddressList, int httpConnectTimeout, int httpRequestTimeout) throws MalformedURLException {
        username = user;
        password = pass;
        endpointList = new EndpointList();
        m_httpConnectTimeout = httpConnectTimeout;
        m_httpRequestTimeout = httpRequestTimeout;
        String[] stringArray = managerAddressList.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String managerAddress = stringArray[n2];
            HashMap<String, EndpointSetting> map = new HashMap<String, EndpointSetting>();
            String wsdlPrefix = managerAddress.trim();
            map.put(ACCESS, new EndpointSetting(ACCESS, wsdlPrefix));
            map.put(CALENDAR, new EndpointSetting(CALENDAR, wsdlPrefix));
            map.put(COLLECTIVE_RUN, new EndpointSetting(COLLECTIVE_RUN, wsdlPrefix));
            map.put(COLLECTOR, new EndpointSetting(COLLECTOR, wsdlPrefix));
            map.put(JOB, new EndpointSetting(JOB, wsdlPrefix));
            map.put(JOBMAP, new EndpointSetting(JOBMAP, wsdlPrefix));
            map.put(MAIL_TEMPLATE, new EndpointSetting(MAIL_TEMPLATE, wsdlPrefix));
            map.put(MAINTENANCE, new EndpointSetting(MAINTENANCE, wsdlPrefix));
            map.put(MONITOR, new EndpointSetting(MONITOR, wsdlPrefix));
            map.put(MONITOR_SETTING, new EndpointSetting(MONITOR_SETTING, wsdlPrefix));
            map.put(MONITOR_SNMPTRAP, new EndpointSetting(MONITOR_SNMPTRAP, wsdlPrefix));
            map.put(NOTIFY, new EndpointSetting(NOTIFY, wsdlPrefix));
            map.put(NODEMAP, new EndpointSetting(NODEMAP, wsdlPrefix));
            map.put(REPOSITORY, new EndpointSetting(REPOSITORY, wsdlPrefix));
            map.put(PERFORMANCE_COLLECT_MASTER, new EndpointSetting(PERFORMANCE_COLLECT_MASTER, wsdlPrefix));
            EndpointManager.endpointList.add(map);
            ++n2;
        }
        m_log.info((Object)("manager instance = " + EndpointManager.endpointList.size()));
    }

    private static void setBindingProvider(Object o, String user, String password, String urlStr) {
        BindingProvider bp = (BindingProvider)o;
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", urlStr);
        bp.getRequestContext().put("javax.xml.ws.security.auth.username", user);
        bp.getRequestContext().put("javax.xml.ws.security.auth.password", password);
        bp.getRequestContext().put("com.sun.xml.internal.ws.connect.timeout", m_httpConnectTimeout * 1000);
        bp.getRequestContext().put("com.sun.xml.internal.ws.request.timeout", m_httpRequestTimeout * 1000);
        if (m_log.isTraceEnabled()) {
            m_log.trace((Object)("ws timeout updated : connectTimeout = " + m_httpConnectTimeout + ", requestTimeout = " + m_httpRequestTimeout));
        }
        ((SOAPBinding)bp.getBinding()).setMTOMEnabled(true);
    }

    public static ArrayList<EndpointSetting> getAccessEndpoint() {
        return EndpointManager.endpointList.getList(EndpointManager.ACCESS);
    }

    public static ArrayList<EndpointSetting> getCalendarEndpoint() {
        return EndpointManager.endpointList.getList(EndpointManager.CALENDAR);
    }

    public static ArrayList<EndpointSetting> getCollectiveRunEndpoint() {
        return EndpointManager.endpointList.getList(EndpointManager.COLLECTIVE_RUN);
    }

    public static ArrayList<EndpointSetting> getCollectorEndpoint() {
        return EndpointManager.endpointList.getList(EndpointManager.COLLECTOR);
    }

    public static ArrayList<EndpointSetting> getJobEndpoint() {
        return EndpointManager.endpointList.getList(EndpointManager.JOB);
    }

    public static ArrayList<EndpointSetting> getJobMapEndpoint() {
        return EndpointManager.endpointList.getList(EndpointManager.JOBMAP);
    }

    public static ArrayList<EndpointSetting> getMailTemplateEndpoint() {
        return EndpointManager.endpointList.getList(EndpointManager.MAIL_TEMPLATE);
    }

    public static ArrayList<EndpointSetting> getMaintenanceEndpoint() {
        return EndpointManager.endpointList.getList(EndpointManager.MAINTENANCE);
    }

    public static ArrayList<EndpointSetting> getMonitorEndpoint() {
        return EndpointManager.endpointList.getList(EndpointManager.MONITOR);
    }

    public static ArrayList<EndpointSetting> getMonitorSettingEndpoint() {
        return EndpointManager.endpointList.getList(EndpointManager.MONITOR_SETTING);
    }

    public static ArrayList<EndpointSetting> getMonitorSnmpTrapEndpoint() {
        return EndpointManager.endpointList.getList(EndpointManager.MONITOR_SNMPTRAP);
    }

    public static ArrayList<EndpointSetting> getNotifyEndpoint() {
        return EndpointManager.endpointList.getList(EndpointManager.NOTIFY);
    }

    public static ArrayList<EndpointSetting> getNodeMapEndpoint() {
        return EndpointManager.endpointList.getList(EndpointManager.NODEMAP);
    }

    public static ArrayList<EndpointSetting> getRepositoryEndpoint() {
        return EndpointManager.endpointList.getList(EndpointManager.REPOSITORY);
    }

    public static ArrayList<EndpointSetting> getPerformanceCollectMasterEndpoint() {
        return EndpointManager.endpointList.getList(EndpointManager.PERFORMANCE_COLLECT_MASTER);
    }

    public static void changeEndpoint() {
        EndpointManager.endpointList.changeEndpoint();
    }

    public static void logout() {
        m_log.debug((Object)"logout");
        username = null;
        password = null;
        if (endpointList == null) {
            return;
        }
        EndpointManager.endpointList.logout();
    }

    private static class EndpointList {
        private ArrayList<HashMap<String, EndpointSetting>> endpointList = new ArrayList();
        private HashMap<String, EndpointSetting> lastSuccessEndpoint = null;

        private EndpointList() {
        }

        private void add(HashMap<String, EndpointSetting> endpointMap) {
            if (this.lastSuccessEndpoint == null) {
                this.lastSuccessEndpoint = endpointMap;
            }
            this.endpointList.add(endpointMap);
        }

        private ArrayList<EndpointSetting> getList(String key) {
            ArrayList<EndpointSetting> list = new ArrayList<EndpointSetting>();
            list.add(this.lastSuccessEndpoint.get(key));
            for (HashMap<String, EndpointSetting> endpoint : this.endpointList) {
                if (endpoint.equals(this.lastSuccessEndpoint)) continue;
                list.add(endpoint.get(key));
            }
            return list;
        }

        @Deprecated
        private void setLastSuccess(HashMap<String, EndpointSetting> endpoint) {
            if (!this.endpointList.contains(endpoint)) {
                m_log.warn((Object)"setLastSuccess(), Error:!endpointList.contains(endpoint)");
            }
            this.lastSuccessEndpoint = endpoint;
            m_log.debug((Object)("set lastSuccessEndpoint. new one is " + this.lastSuccessEndpoint));
        }

        private void changeEndpoint() {
            m_log.debug((Object)"changeEndpoint");
            boolean flag = false;
            for (HashMap<String, EndpointSetting> e : this.endpointList) {
                if (flag) {
                    this.lastSuccessEndpoint = e;
                    flag = false;
                    return;
                }
                if (!this.lastSuccessEndpoint.equals(e)) continue;
                flag = true;
            }
            this.lastSuccessEndpoint = this.endpointList.get(0);
        }

        private void logout() {
            for (HashMap<String, EndpointSetting> map : this.endpointList) {
                for (String key : map.keySet()) {
                    EndpointSetting setting = map.get(key);
                    setting.logout();
                }
            }
        }

        private int size() {
            return this.endpointList.size();
        }
    }

    public static class EndpointSetting {
        private String key;
        private String urlPrefix;
        private Object endpoint;
        private String wsdlSuffix = "?wsdl";

        private EndpointSetting(String key, String urlPrefix) {
            this.key = key;
            this.urlPrefix = urlPrefix;
        }

        private void logout() {
            this.endpoint = null;
        }

        public Object getEndpoint() {
            AccessEndpointService tmpEndpointService;
            String urlStr;
            LoginManager.login();
            if (this.endpoint != null) {
                EndpointManager.setBindingProvider(this.endpoint, username, password, String.valueOf(this.urlPrefix) + this.key + this.wsdlSuffix);
                return this.endpoint;
            }
            String tmpKey = null;
            tmpKey = ACCESS;
            if (tmpKey.equals(this.key)) {
                urlStr = String.valueOf(this.urlPrefix) + tmpKey + this.wsdlSuffix;
                tmpEndpointService = null;
                try {
                    tmpEndpointService = new AccessEndpointService(new URL(urlStr), new QName("http://access.ws.clustercontrol.com", tmpKey));
                }
                catch (MalformedURLException e) {
                    m_log.warn((Object)("getEndpoint():AccessEndpointService, " + e.getMessage()), (Throwable)e);
                }
                this.endpoint = tmpEndpointService.getAccessEndpointPort();
                EndpointManager.setBindingProvider(this.endpoint, username, password, urlStr);
            }
            if ((tmpKey = CALENDAR).equals(this.key)) {
                urlStr = String.valueOf(this.urlPrefix) + tmpKey + this.wsdlSuffix;
                tmpEndpointService = null;
                try {
                    tmpEndpointService = new CalendarEndpointService(new URL(urlStr), new QName("http://calendar.ws.clustercontrol.com", tmpKey));
                }
                catch (MalformedURLException e) {
                    m_log.warn((Object)("getEndpoint():CalendarEndpointService, " + e.getMessage()), (Throwable)e);
                }
                this.endpoint = tmpEndpointService.getCalendarEndpointPort();
                EndpointManager.setBindingProvider(this.endpoint, username, password, urlStr);
            }
            if ((tmpKey = COLLECTIVE_RUN).equals(this.key)) {
                urlStr = String.valueOf(this.urlPrefix) + tmpKey + this.wsdlSuffix;
                tmpEndpointService = null;
                try {
                    tmpEndpointService = new CollectiveRunEndpointService(new URL(urlStr), new QName("http://collectiverun.ws.clustercontrol.com", tmpKey));
                }
                catch (MalformedURLException e) {
                    m_log.warn((Object)("getEndpoint():CollectiveRunEndpointService, " + e.getMessage()), (Throwable)e);
                }
                this.endpoint = tmpEndpointService.getCollectiveRunEndpointPort();
                EndpointManager.setBindingProvider(this.endpoint, username, password, urlStr);
            }
            if ((tmpKey = COLLECTOR).equals(this.key)) {
                urlStr = String.valueOf(this.urlPrefix) + tmpKey + this.wsdlSuffix;
                tmpEndpointService = null;
                try {
                    tmpEndpointService = new CollectorEndpointService(new URL(urlStr), new QName("http://collector.ws.clustercontrol.com", tmpKey));
                }
                catch (MalformedURLException e) {
                    m_log.warn((Object)("getEndpoint():CollectorEndpointService, " + e.getMessage()), (Throwable)e);
                }
                this.endpoint = tmpEndpointService.getCollectorEndpointPort();
                EndpointManager.setBindingProvider(this.endpoint, username, password, urlStr);
            }
            if ((tmpKey = JOB).equals(this.key)) {
                urlStr = String.valueOf(this.urlPrefix) + tmpKey + this.wsdlSuffix;
                tmpEndpointService = null;
                try {
                    tmpEndpointService = new JobEndpointService(new URL(urlStr), new QName("http://jobmanagement.ws.clustercontrol.com", tmpKey));
                }
                catch (MalformedURLException e) {
                    m_log.warn((Object)("getEndpoint():JobEndpointService, " + e.getMessage()), (Throwable)e);
                }
                this.endpoint = tmpEndpointService.getJobEndpointPort();
                EndpointManager.setBindingProvider(this.endpoint, username, password, urlStr);
            }
            if ((tmpKey = JOBMAP).equals(this.key)) {
                urlStr = String.valueOf(this.urlPrefix) + tmpKey + this.wsdlSuffix;
                tmpEndpointService = null;
                try {
                    tmpEndpointService = new JobMapEndpointService(new URL(urlStr), new QName("http://jobmanagement.ws.clustercontrol.com", tmpKey));
                }
                catch (MalformedURLException e) {
                    m_log.warn((Object)("getEndpoint():JobMapEndpointService, " + e.getMessage()), (Throwable)e);
                }
                this.endpoint = tmpEndpointService.getJobMapEndpointPort();
                EndpointManager.setBindingProvider(this.endpoint, username, password, urlStr);
            }
            if ((tmpKey = MAIL_TEMPLATE).equals(this.key)) {
                urlStr = String.valueOf(this.urlPrefix) + tmpKey + this.wsdlSuffix;
                tmpEndpointService = null;
                try {
                    tmpEndpointService = new MailTemplateEndpointService(new URL(urlStr), new QName("http://mailtemplate.ws.clustercontrol.com", tmpKey));
                }
                catch (MalformedURLException e) {
                    m_log.warn((Object)("getEndpoint():MailTemplateEndpointService, " + e.getMessage()), (Throwable)e);
                }
                this.endpoint = tmpEndpointService.getMailTemplateEndpointPort();
                EndpointManager.setBindingProvider(this.endpoint, username, password, urlStr);
            }
            if ((tmpKey = MAINTENANCE).equals(this.key)) {
                urlStr = String.valueOf(this.urlPrefix) + tmpKey + this.wsdlSuffix;
                tmpEndpointService = null;
                try {
                    tmpEndpointService = new MaintenanceEndpointService(new URL(urlStr), new QName("http://maintenance.ws.clustercontrol.com", tmpKey));
                }
                catch (MalformedURLException e) {
                    m_log.warn((Object)("getEndpoint():MaintenanceEndpointService, " + e.getMessage()), (Throwable)e);
                }
                this.endpoint = tmpEndpointService.getMaintenanceEndpointPort();
                EndpointManager.setBindingProvider(this.endpoint, username, password, urlStr);
            }
            if ((tmpKey = MONITOR).equals(this.key)) {
                urlStr = String.valueOf(this.urlPrefix) + tmpKey + this.wsdlSuffix;
                tmpEndpointService = null;
                try {
                    tmpEndpointService = new MonitorEndpointService(new URL(urlStr), new QName("http://monitor.ws.clustercontrol.com", tmpKey));
                }
                catch (MalformedURLException e) {
                    m_log.warn((Object)("getEndpoint():MonitorEndpointService, " + e.getMessage()), (Throwable)e);
                }
                this.endpoint = tmpEndpointService.getMonitorEndpointPort();
                EndpointManager.setBindingProvider(this.endpoint, username, password, urlStr);
            }
            if ((tmpKey = MONITOR_SETTING).equals(this.key)) {
                urlStr = String.valueOf(this.urlPrefix) + tmpKey + this.wsdlSuffix;
                tmpEndpointService = null;
                try {
                    tmpEndpointService = new MonitorSettingEndpointService(new URL(urlStr), new QName("http://monitor.ws.clustercontrol.com", tmpKey));
                }
                catch (MalformedURLException e) {
                    m_log.warn((Object)("getEndpoint():MonitorSettingEndpointService, " + e.getMessage()), (Throwable)e);
                }
                this.endpoint = tmpEndpointService.getMonitorSettingEndpointPort();
                EndpointManager.setBindingProvider(this.endpoint, username, password, urlStr);
            }
            if ((tmpKey = MONITOR_SNMPTRAP).equals(this.key)) {
                urlStr = String.valueOf(this.urlPrefix) + tmpKey + this.wsdlSuffix;
                tmpEndpointService = null;
                try {
                    tmpEndpointService = new MonitorSnmpTrapEndpointService(new URL(urlStr), new QName("http://monitor.ws.clustercontrol.com", tmpKey));
                }
                catch (MalformedURLException e) {
                    m_log.warn((Object)("getEndpoint():MonitorSnmpTrapEndpointService, " + e.getMessage()), (Throwable)e);
                }
                this.endpoint = tmpEndpointService.getMonitorSnmpTrapEndpointPort();
                EndpointManager.setBindingProvider(this.endpoint, username, password, urlStr);
            }
            if ((tmpKey = NODEMAP).equals(this.key)) {
                urlStr = String.valueOf(this.urlPrefix) + tmpKey + this.wsdlSuffix;
                tmpEndpointService = null;
                try {
                    tmpEndpointService = new NodeMapEndpointService(new URL(urlStr), new QName("http://nodemap.ws.clustercontrol.com", tmpKey));
                }
                catch (MalformedURLException e) {
                    m_log.warn((Object)("getEndpoint():NodeMapEndpointService, " + e.getMessage()), (Throwable)e);
                }
                this.endpoint = tmpEndpointService.getNodeMapEndpointPort();
                EndpointManager.setBindingProvider(this.endpoint, username, password, urlStr);
            }
            if ((tmpKey = NOTIFY).equals(this.key)) {
                urlStr = String.valueOf(this.urlPrefix) + tmpKey + this.wsdlSuffix;
                tmpEndpointService = null;
                try {
                    tmpEndpointService = new NotifyEndpointService(new URL(urlStr), new QName("http://notify.ws.clustercontrol.com", tmpKey));
                }
                catch (MalformedURLException e) {
                    m_log.warn((Object)("getEndpoint():NotifyEndpointService, " + e.getMessage()), (Throwable)e);
                }
                this.endpoint = tmpEndpointService.getNotifyEndpointPort();
                EndpointManager.setBindingProvider(this.endpoint, username, password, urlStr);
            }
            if ((tmpKey = REPOSITORY).equals(this.key)) {
                urlStr = String.valueOf(this.urlPrefix) + tmpKey + this.wsdlSuffix;
                tmpEndpointService = null;
                try {
                    tmpEndpointService = new RepositoryEndpointService(new URL(urlStr), new QName("http://repository.ws.clustercontrol.com", tmpKey));
                }
                catch (MalformedURLException e) {
                    m_log.warn((Object)("getEndpoint():RepositoryEndpointService, " + e.getMessage()), (Throwable)e);
                }
                this.endpoint = tmpEndpointService.getRepositoryEndpointPort();
                EndpointManager.setBindingProvider(this.endpoint, username, password, urlStr);
            }
            if ((tmpKey = PERFORMANCE_COLLECT_MASTER).equals(this.key)) {
                urlStr = String.valueOf(this.urlPrefix) + tmpKey + this.wsdlSuffix;
                tmpEndpointService = null;
                try {
                    tmpEndpointService = new PerformanceCollectMasterEndpointService(new URL(urlStr), new QName("http://collectmaster.ws.clustercontrol.com", tmpKey));
                }
                catch (MalformedURLException e) {
                    m_log.warn((Object)("getEndpoint():PerformanceCollectMasterEndpointService, " + e.getMessage()), (Throwable)e);
                }
                this.endpoint = tmpEndpointService.getPerformanceCollectMasterEndpointPort();
                EndpointManager.setBindingProvider(this.endpoint, username, password, urlStr);
            }
            return this.endpoint;
        }
    }
}

