/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.dialog;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.snmptrap.action.GetSnmpTrapModifyProperty;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.viewer.PropertySheet;
import com.clustercontrol.ws.monitor.MonitorTrapValueInfo;
import java.util.ArrayList;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SnmpTrapModifyDialog
extends CommonDialog {
    private PropertySheet viewer = null;
    private Shell shell = null;
    private MonitorTrapValueInfo oidInfo = null;

    public SnmpTrapModifyDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    @Override
    protected void customizeDialog(Composite parent) {
        this.shell = this.getShell();
        parent.getShell().setText(Messages.getString((String)"dialog.snmptrap.modify.definition"));
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout((Layout)layout);
        Label tableTitle = new Label(parent, 0);
        tableTitle.setText(String.valueOf(Messages.getString((String)"attribute")) + " : ");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        tableTitle.setLayoutData((Object)gridData);
        TableTree table = new TableTree(parent, 68354);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.viewer = new PropertySheet(table);
        this.viewer.setInput(new GetSnmpTrapModifyProperty().getProperty());
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData((Object)gridData);
        Display display = this.shell.getDisplay();
        this.shell.setLocation((display.getBounds().width - this.shell.getSize().x) / 2, (display.getBounds().height - this.shell.getSize().y) / 2);
        this.reflectOidInfo();
        this.viewer.expandAll();
    }

    private void reflectOidInfo() {
        Property property = null;
        if (this.oidInfo instanceof MonitorTrapValueInfo) {
            property = new GetSnmpTrapModifyProperty().getProperty();
            ArrayList<Property> propertyList = PropertyUtil.getProperty(property, "mib");
            Property mib = propertyList.get(0);
            mib.setValue(this.oidInfo.getMib());
            propertyList = PropertyUtil.getProperty(property, "trapName");
            Property trapName = propertyList.get(0);
            trapName.setValue(this.oidInfo.getUei());
            propertyList = PropertyUtil.getProperty(property, "trapOid");
            Property trapOid = propertyList.get(0);
            trapOid.setValue(this.oidInfo.getTrapOid());
            propertyList = PropertyUtil.getProperty(property, "genericId");
            Property genericId = propertyList.get(0);
            genericId.setValue(Integer.toString(this.oidInfo.getGenericId()));
            propertyList = PropertyUtil.getProperty(property, "specificId");
            Property specificId = propertyList.get(0);
            specificId.setValue(Integer.toString(this.oidInfo.getSpecificId()));
            propertyList = PropertyUtil.getProperty(property, "valid");
            Property valid = propertyList.get(0);
            valid.setValue(new Boolean(this.oidInfo.isValidFlg()));
            propertyList = PropertyUtil.getProperty(property, "priority");
            Property priority = propertyList.get(0);
            priority.setValue(PriorityConstant.typeToString((int)this.oidInfo.getPriority()));
            propertyList = PropertyUtil.getProperty(property, "logmsg");
            Property logmsg = propertyList.get(0);
            logmsg.setValue(this.oidInfo.getLogmsg());
            propertyList = PropertyUtil.getProperty(property, "descr");
            Property descr = propertyList.get(0);
            descr.setValue(this.oidInfo.getDescr());
            this.viewer.setInput(property);
            this.viewer.refresh();
        }
    }

    private ValidateResult createOidInfo() {
        if (this.oidInfo instanceof MonitorTrapValueInfo) {
            Property property = (Property)this.viewer.getInput();
            ArrayList values = PropertyUtil.getPropertyValue(property, "valid");
            Boolean valid = (Boolean)values.get(0);
            this.oidInfo.setValidFlg(valid.booleanValue());
            values = PropertyUtil.getPropertyValue(property, "priority");
            String priority = (String)values.get(0);
            this.oidInfo.setPriority(PriorityConstant.stringToType((String)priority));
            values = PropertyUtil.getPropertyValue(property, "logmsg");
            String logmsg = (String)values.get(0);
            this.oidInfo.setLogmsg(logmsg);
            values = PropertyUtil.getPropertyValue(property, "descr");
            String descr = (String)values.get(0);
            this.oidInfo.setDescr(descr);
        }
        return null;
    }

    protected Point getInitialSize() {
        return new Point(400, 400);
    }

    public void setInputData(MonitorTrapValueInfo oidInfo) {
        this.oidInfo = oidInfo;
    }

    public MonitorTrapValueInfo getInputData() {
        return this.oidInfo;
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    @Override
    protected ValidateResult validate() {
        ValidateResult result = null;
        result = this.createOidInfo();
        if (result != null) {
            return result;
        }
        return null;
    }
}

