/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.view.action;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.fault.HinemosException;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.repository.view.NodeListView;
import com.clustercontrol.util.CommandCreator;
import com.clustercontrol.util.CommandExecutor;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ProgramExecutionAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(ProgramExecutionAction.class);
    public static final String ID = "com.clustercontrol.repository.view.action.ProgramExecutionAction";
    private IViewPart viewPart;

    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    public void run(IAction action) {
        NodeListView view = (NodeListView)((Object)this.viewPart.getAdapter(NodeListView.class));
        StructuredSelection selection = (StructuredSelection)view.getComposite().getTableViewer().getSelection();
        List list = (List)selection.getFirstElement();
        String facilityId = null;
        if (list != null) {
            facilityId = (String)list.get(0);
        }
        if (facilityId != null) {
            String execProg = ClusterControlPlugin.getDefault().getPreferenceStore().getString("programExecution");
            if (execProg.equals("")) {
                MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)Messages.getString((String)"message.repository.49"));
                return;
            }
            if (execProg.indexOf("#") != -1) {
                try {
                    execProg = RepositoryEndpointWrapper.replaceNodeVariable(facilityId, execProg);
                }
                catch (InvalidRole_Exception invalidRole_Exception) {
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                }
                catch (Exception e) {
                    m_log.warn((Object)("run(), " + e.getMessage()), (Throwable)e);
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
                }
            }
            String[] args = null;
            try {
                String user = System.getProperty("user.name");
                args = CommandCreator.createCommand((String)user, (String)execProg, (CommandCreator.PlatformType)CommandCreator.PlatformType.WINDOWS, (Integer)0);
            }
            catch (HinemosException e) {
                m_log.warn((Object)("run(), " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
            String message = "";
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                message = String.valueOf(message) + arg + " ";
                ++n2;
            }
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.repository.46", (Object[])new String[]{message}))) {
                m_log.debug((Object)("program execution start : " + message));
                try {
                    new CommandExecutor(args).execute();
                }
                catch (Exception e) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.repository.48")) + ", " + e.getMessage()));
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

