/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.composite;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.action.GetNodeList;
import com.clustercontrol.repository.action.GetNodeListTableDefine;
import com.clustercontrol.repository.composite.action.NodeDoubleClickListener;
import com.clustercontrol.repository.view.NodeAttributeView;
import com.clustercontrol.repository.view.NodeScopeView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.repository.NodeInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;

public class NodeListComposite
extends Composite {
    private CommonTableViewer tableViewer = null;
    private Label statuslabel = null;
    private Label totalLabel = null;
    private Property condition = null;

    public NodeListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.statuslabel = new Label((Composite)this, 16384);
        this.statuslabel.setText("");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.statuslabel.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetNodeListTableDefine.get(), 0, 1);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NodeAttributeView attributeView;
                IWorkbench workbench = ClusterControlPlugin.getDefault().getWorkbench();
                IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                NodeScopeView scopeView = (NodeScopeView)page.findView("com.clustercontrol.repository.view.NodeScopeView");
                if (scopeView != null) {
                    scopeView.update();
                }
                if ((attributeView = (NodeAttributeView)page.findView("com.clustercontrol.repository.view.NodeAttributeView")) != null) {
                    attributeView.update();
                }
            }
        });
        this.tableViewer.addDoubleClickListener(new NodeDoubleClickListener(this));
        this.totalLabel = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.totalLabel.setLayoutData((Object)gridData);
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    public void update() {
        List<NodeInfo> list = null;
        if (this.condition == null) {
            this.statuslabel.setText("");
            list = new GetNodeList().getAll();
        } else {
            this.statuslabel.setText(Messages.getString((String)"filtered.list"));
            list = new GetNodeList().get(this.condition);
        }
        if (list == null) {
            list = new ArrayList<NodeInfo>();
        }
        ArrayList listInput = new ArrayList();
        for (NodeInfo node : list) {
            ArrayList<String> a = new ArrayList<String>();
            a.add(node.getFacilityId());
            a.add(node.getFacilityName());
            a.add(node.getPlatformFamily());
            if (node.getIpAddressVersion() == 6) {
                a.add(node.getIpAddressV6());
            } else {
                a.add(node.getIpAddressV4());
            }
            a.add(node.getDescription());
            a.add(node.getOwnerRoleId());
            listInput.add(a);
        }
        this.tableViewer.setInput(listInput);
        Object[] args = new String[]{String.valueOf(list.size())};
        String message = null;
        message = this.condition == null ? Messages.getString((String)"records", (Object[])args) : Messages.getString((String)"filtered.records", (Object[])args);
        this.totalLabel.setText(message);
    }

    public void update(Property condition) {
        this.condition = condition;
        this.update();
    }
}

