/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.action;

import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.util.NodePropertyUtil;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.repository.FacilityNotFound_Exception;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import com.clustercontrol.ws.repository.NodeInfo;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;

public class GetNodeProperty {
    private static Log m_log = LogFactory.getLog(GetNodeProperty.class);
    private NodeInfo nodeInfo = null;
    private String facilityId = null;
    private int mode;

    public GetNodeProperty(String facilityId, int mode) {
        this.facilityId = facilityId;
        this.mode = mode;
        try {
            if (this.facilityId == null || this.facilityId.length() == 0) {
                this.nodeInfo = new NodeInfo();
                NodePropertyUtil.setDefaultNode(this.nodeInfo);
            } else {
                this.nodeInfo = RepositoryEndpointWrapper.getNode(this.facilityId);
            }
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (FacilityNotFound_Exception e) {
            e.printStackTrace();
            m_log.warn((Object)("getProperty(), " + e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            m_log.warn((Object)("getProperty(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
    }

    public Property getProperty() {
        return NodePropertyUtil.node2property(this.nodeInfo, this.mode, Locale.getDefault());
    }

    public NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }
}

