/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.util;

import com.clustercontrol.ws.collector.CollectedDataInfo;
import com.clustercontrol.ws.collector.CollectedDataList;
import com.clustercontrol.ws.collector.CollectedDataSet;
import com.clustercontrol.ws.collector.CollectorItemInfo;
import com.clustercontrol.ws.collector.FacilityIdItemCodeInfo;
import java.util.ArrayList;
import java.util.List;

public class CollectedDataSetUtil {
    public static List<CollectedDataInfo> getCollectedDataList(CollectedDataSet dataSet, String facilityId, CollectorItemInfo key) {
        FacilityIdItemCodeInfo keyInfo = new FacilityIdItemCodeInfo();
        keyInfo.setFacilityId(facilityId);
        keyInfo.setItemInfo(key);
        CollectedDataList dataList = null;
        for (CollectedDataSet.DataMap.Entry entry : dataSet.getDataMap().getEntry()) {
            if (!CollectedDataSetUtil.compareKenInfo(keyInfo, entry.getKey())) continue;
            dataList = entry.getValue();
            break;
        }
        if (dataList != null) {
            return dataList.getList();
        }
        return new ArrayList<CollectedDataInfo>();
    }

    private static boolean compareKenInfo(FacilityIdItemCodeInfo key1, FacilityIdItemCodeInfo key2) {
        if (key1.getFacilityId() == null && key2.getFacilityId() != null) {
            return false;
        }
        if (key1.getFacilityId() != null && !key1.getFacilityId().equals(key2.getFacilityId())) {
            return false;
        }
        if (key1.getItemInfo() == null && key2.getItemInfo() != null) {
            return false;
        }
        if (key1.getItemInfo().getCollectorId() == null && key2.getItemInfo().getCollectorId() != null) {
            return false;
        }
        if (key1.getItemInfo().getCollectorId() != null && !key1.getItemInfo().getCollectorId().equals(key2.getItemInfo().getCollectorId())) {
            return false;
        }
        if (key1.getItemInfo().getDisplayName() == null && key2.getItemInfo().getDisplayName() != null) {
            return false;
        }
        if (key1.getItemInfo().getDisplayName() != null && !key1.getItemInfo().getDisplayName().equals(key2.getItemInfo().getDisplayName())) {
            return false;
        }
        if (key1.getItemInfo().getItemCode() == null && key2.getItemInfo().getItemCode() != null) {
            return false;
        }
        return key1.getItemInfo().getItemCode() == null || key1.getItemInfo().getItemCode().equals(key2.getItemInfo().getItemCode());
    }

    public static void setCollectedDataList(CollectedDataSet dataSet, String facilityId, CollectorItemInfo itemInfo, List<CollectedDataInfo> dataList) {
        FacilityIdItemCodeInfo keyInfo = new FacilityIdItemCodeInfo();
        keyInfo.setFacilityId(facilityId);
        keyInfo.setItemInfo(itemInfo);
        CollectedDataSet.DataMap.Entry entry = new CollectedDataSet.DataMap.Entry();
        entry.setKey(keyInfo);
        CollectedDataList list = new CollectedDataList();
        if (dataList != null) {
            list.getList().addAll(dataList);
        }
        entry.setValue(list);
        dataSet.getDataMap().getEntry().add(entry);
    }
}

