/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.dialog;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.composite.FacilityTreeComposite;
import com.clustercontrol.composite.action.StringVerifyListener;
import com.clustercontrol.monitor.util.MonitorSettingEndpointWrapper;
import com.clustercontrol.performance.action.RecordDataWriter;
import com.clustercontrol.repository.FacilityPath;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.MonitorInfo;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportDialog
extends Dialog {
    private static Log m_log = LogFactory.getLog(ExportDialog.class);
    private Composite compositeAll;
    private Composite compositeScope;
    private Composite compositeCheck;
    private Composite compositeOutpuFile;
    private FacilityTreeComposite treeComposite;
    private Label pathLabel = null;
    private Text folderNameText = null;
    private Button checkBoxHeader = null;
    private String monitorId = null;
    private String monitorTypeId = null;
    private String facilityId = null;
    private FacilityTreeItem treeItem = null;
    private RecordDataWriter writer;
    private String targetFacilityId = null;
    private boolean headerFlag = false;
    private boolean archiveFlag = false;
    private String folderName = null;

    public ExportDialog(Shell parent, String monitorId, String monitorTypeId) {
        super(parent);
        this.monitorId = monitorId;
        this.monitorTypeId = monitorTypeId;
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(com.clustercontrol.performance.util.Messages.getString("EXPORT_DIALOG_TITLE"));
    }

    protected Control createDialogArea(Composite parent) {
        this.compositeAll = (Composite)super.createDialogArea(parent);
        this.compositeAll.setLayout((Layout)new FillLayout());
        this.compositeScope = new Composite(this.compositeAll, 0);
        this.pathLabel = new Label(this.compositeScope, 0);
        this.compositeScope.setLayout((Layout)new GridLayout());
        this.pathLabel.setText(String.valueOf(com.clustercontrol.performance.util.Messages.getString("SCOPE")) + " : ");
        this.pathLabel.pack();
        this.createTree();
        this.createCompositeCheck();
        this.createCompositeOutpuFile();
        this.createSeparator();
        return this.compositeAll;
    }

    private void createTree() {
        try {
            MonitorInfo monitorInfo = MonitorSettingEndpointWrapper.getMonitor(this.monitorId, this.monitorTypeId);
            this.facilityId = monitorInfo.getFacilityId();
            this.treeItem = RepositoryEndpointWrapper.getExecTargetFacilityTreeByFacilityId(this.facilityId, null);
        }
        catch (InvalidRole_Exception e) {
            m_log.warn((Object)("createTree() : getMonitor, " + e.getMessage()), (Throwable)e);
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("createTree() getMonitor, " + e.getMessage()), (Throwable)e);
        }
        this.treeComposite = new FacilityTreeComposite(this.compositeScope, 0, null, false, true, true, false);
        GridData gridDataTree = new GridData(1808);
        this.treeComposite.setLayoutData(gridDataTree);
        this.treeComposite.setScopeTree(this.treeItem);
        this.treeComposite.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                FacilityTreeItem selectItem = (FacilityTreeItem)selection.getFirstElement();
                if (selectItem instanceof FacilityTreeItem) {
                    FacilityPath path = new FacilityPath(ClusterControlPlugin.getDefault().getSeparator());
                    ExportDialog.this.pathLabel.setText(String.valueOf(com.clustercontrol.performance.util.Messages.getString("SCOPE")) + " : " + path.getPath(selectItem));
                    ExportDialog.this.pathLabel.pack();
                }
            }
        });
    }

    private void createCompositeCheck() {
        this.compositeCheck = new Composite(this.compositeScope, 0);
        GridLayout buttonLayout = new GridLayout(1, true);
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        this.compositeCheck.setLayout((Layout)buttonLayout);
        GridData layoutData = null;
        this.checkBoxHeader = new Button(this.compositeCheck, 32);
        this.checkBoxHeader.setText(com.clustercontrol.performance.util.Messages.getString("OUTPUT_HEADER"));
        layoutData = new GridData(768);
        this.checkBoxHeader.setLayoutData((Object)layoutData);
    }

    private void createCompositeOutpuFile() {
        this.compositeOutpuFile = new Composite(this.compositeScope, 0);
        GridData gridDataComposite3 = new GridData(768);
        this.compositeOutpuFile.setLayoutData((Object)gridDataComposite3);
        this.compositeOutpuFile.setLayout((Layout)new FormLayout());
        Label label = new Label(this.compositeOutpuFile, 0);
        label.setText(String.valueOf(com.clustercontrol.performance.util.Messages.getString("FOLDER_NAME")) + " : ");
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 0);
        labelData.left = new FormAttachment(0, 0);
        label.setLayoutData((Object)labelData);
        Button button = new Button(this.compositeOutpuFile, 0);
        button.setText(com.clustercontrol.performance.util.Messages.getString("REFER"));
        FormData buttonData = new FormData();
        buttonData.top = new FormAttachment(0, 0);
        buttonData.right = new FormAttachment(100, 0);
        button.setLayoutData((Object)buttonData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog saveDialog = new DirectoryDialog(ExportDialog.this.getShell());
                String folderName = saveDialog.open();
                if (folderName != null) {
                    ExportDialog.this.folderNameText.setText(folderName);
                }
            }
        });
        this.folderNameText = new Text(this.compositeOutpuFile, 2048);
        FormData textData = new FormData();
        textData.top = new FormAttachment(0, 0);
        textData.left = new FormAttachment((Control)label, 0);
        textData.right = new FormAttachment((Control)button, 0);
        this.folderNameText.setLayoutData((Object)textData);
        this.folderNameText.addVerifyListener((VerifyListener)new StringVerifyListener(4096));
    }

    private void createSeparator() {
        Label h_separator = new Label(this.compositeScope, 258);
        GridData gridDataLabel = new GridData(768);
        h_separator.setLayoutData((Object)gridDataLabel);
    }

    protected void okPressed() {
        this.folderName = this.folderNameText.getText();
        this.targetFacilityId = this.treeComposite.getSelectItem().getData().getFacilityId();
        this.headerFlag = this.checkBoxHeader.getSelection();
        this.archiveFlag = true;
        if (this.targetFacilityId == null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)com.clustercontrol.performance.util.Messages.getString("MESSAGE_0020"), (String)com.clustercontrol.performance.util.Messages.getString("MSG_SPECIFY_SCOPE"));
            return;
        }
        if (this.folderName == null || this.folderName.equals("")) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)com.clustercontrol.performance.util.Messages.getString("INPUT_ERROR"), (String)com.clustercontrol.performance.util.Messages.getString("MSG_SPECIFY_FOLDER_NAME"));
            return;
        }
        this.writer = new RecordDataWriter(this.monitorId, this.targetFacilityId, this.headerFlag, this.archiveFlag, this.folderName);
        try {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Thread exportThread = new Thread(ExportDialog.this.writer);
                    exportThread.start();
                    monitor.beginTask(com.clustercontrol.performance.util.Messages.getString("EXPORT"), 100);
                    int progress = 0;
                    int buff = 0;
                    while (progress < 100) {
                        progress = ExportDialog.this.writer.getProgress();
                        if (monitor.isCanceled()) {
                            throw new InterruptedException("");
                        }
                        if (ExportDialog.this.writer.isCanceled()) {
                            throw new InterruptedException(ExportDialog.this.writer.getCancelMessage());
                        }
                        Thread.sleep(50L);
                        monitor.worked(progress - buff);
                        buff = progress;
                    }
                    monitor.done();
                }
            };
            new ProgressMonitorDialog(this.getShell()).run(true, true, op);
            MessageDialog.openInformation((Shell)this.getShell(), (String)com.clustercontrol.performance.util.Messages.getString("MESSAGE_0020"), (String)com.clustercontrol.performance.util.Messages.getString("MSG_EXPORT_SUCCESS"));
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException e) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)com.clustercontrol.performance.util.Messages.getString("MESSAGE_0020"), (String)(String.valueOf(com.clustercontrol.performance.util.Messages.getString("MSG_EXPORT_CANCEL")) + " : " + e.getMessage()));
            this.writer.setCanceled(true);
        }
        super.okPressed();
    }
}

