/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.composite;

import com.clustercontrol.monitor.util.PerformanceDataSettingsUtil;
import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performance.util.CollectedDataSetUtil;
import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performance.view.PerformanceGraphView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.collector.CollectedDataInfo;
import com.clustercontrol.ws.collector.CollectedDataSet;
import com.clustercontrol.ws.collector.CollectorItemInfo;
import com.clustercontrol.ws.collector.CollectorItemParentInfo;
import com.clustercontrol.ws.collector.PerformanceDataSettings;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import java.awt.Color;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

public class PerformanceGraphComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(PerformanceGraphComposite.class);
    private final int INDEX_GRAPH_LINE = 0;
    private final int INDEX_GRAPH_STACK = 1;
    private final String STRING_GRAPH_LINE = Messages.getString((String)"collection.graph.line");
    private final String STRING_GRAPH_STACK = Messages.getString((String)"collection.graph.area");
    private final int INDEX_DISPLAY_NODE = 0;
    private final int INDEX_DISPLAY_ITEMCODE = 1;
    private final int INDEX_DISPLAY_DEVICE = 2;
    private final String STRING_DISPLAY_NODE = Messages.getString((String)"collection.display.node");
    private final String STRING_DISPLAY_ITEMCODE = Messages.getString((String)"collection.display.itemcode");
    private final String STRING_DISPLAY_DEVICE = Messages.getString((String)"collection.display.device");
    private final int ACTION_OLDEST = 0;
    private final int ACTION_PREV = 1;
    private final int ACTION_NEXT = 2;
    private final int ACTION_NEWEST = 3;
    private final String STRING_ACTION_OLDEST = Messages.getString((String)"collection.button.oldest");
    private final String STRING_ACTION_PREV = Messages.getString((String)"collection.button.prev");
    private final String STRING_ACTION_NEXT = Messages.getString((String)"collection.button.next");
    private final String STRING_ACTION_NEWEST = Messages.getString((String)"collection.button.newest");
    private final long MILLISECOND_HOUR = 3600000L;
    private final long MILLISECOND_DAY = 86400000L;
    private final long MILLISECOND_WEEK = 604800000L;
    private final long MILLISECOND_MONTH = 2678400000L;
    private final String STRING_TIME_HOUR = Messages.getString((String)"collection.button.hour");
    private final String STRING_TIME_DAY = Messages.getString((String)"collection.button.day");
    private final String STRING_TIME_WEEK = Messages.getString((String)"collection.button.week");
    private final String STRING_TIME_MONTH = Messages.getString((String)"collection.button.month");
    private PerformanceDataSettings performanceDataSettings = null;
    private Combo displayTypeCombo = null;
    private Combo displayItem = null;
    private Combo graphTypeCombo = null;
    private Button firstButton = null;
    private Button backButton = null;
    private Button forwardButton = null;
    private Button lastButton = null;
    private Button updateButton = null;
    private Button hourButton = null;
    private Button dayButton = null;
    private Button weekButton = null;
    private Button monthButton = null;
    private Button autoUpdate = null;
    private int targetDiaplayType = 0;
    private int targetGraphType = 0;
    private CollectorItemParentInfo targetItemCodeInfo = null;
    private FacilityTreeItem targetFacilityTreeItem = null;
    private int targetRange = 0;
    private Date targetConditionStartDate = null;
    private Date targetConditionEndDate = null;
    private ArrayList<CollectorItemInfo> targetConditionItemList = new ArrayList();
    private ArrayList<String> targetConditionFacilityIdList = new ArrayList();
    private boolean targetAutoUpdate = false;
    private ArrayList<CollectorItemParentInfo> itemCodeListByDisplayDevice = new ArrayList();
    private ChartComposite chartComposite = null;
    private JFreeChart jfreeChart = null;
    private TimeSeriesCollection timeSeriesCollection = null;
    private TimeSeries[] timeSeries = null;
    private int GRAPH_MAX = 0;
    private Composite parent = null;
    private int style = 0;
    private Color[] color = new Color[]{Color.RED, Color.BLUE, Color.GREEN, Color.ORANGE, Color.CYAN, Color.MAGENTA, Color.YELLOW, Color.PINK, Color.GRAY, Color.BLACK, Color.LIGHT_GRAY, Color.DARK_GRAY, Color.WHITE};

    public PerformanceGraphComposite(PerformanceDataSettings settings, Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.style = style;
        this.GRAPH_MAX = PerformanceGraphView.GRAPH_MAX;
        this.setPerformanceDataSettings(settings);
        this.initialize(this.parent, this.style);
    }

    private void initialize(Composite parent, int style) {
        this.timeSeriesCollection = new TimeSeriesCollection();
        this.timeSeries = new TimeSeries[this.GRAPH_MAX];
        int i = 0;
        while (i < this.timeSeries.length) {
            this.timeSeries[i] = new TimeSeries((Comparable)((Object)""));
            ++i;
        }
        GridData gridData = null;
        GridLayout viewLayout = new GridLayout(13, true);
        viewLayout.marginHeight = 0;
        viewLayout.marginWidth = 0;
        this.setLayout((Layout)viewLayout);
        Label displayTypeLabel = new Label((Composite)this, 0x1000000);
        displayTypeLabel.setText(String.valueOf(Messages.getString((String)"collection.label.display.type")) + " : ");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        displayTypeLabel.setLayoutData((Object)gridData);
        this.displayTypeCombo = new Combo((Composite)this, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        this.displayTypeCombo.setLayoutData((Object)gridData);
        this.displayTypeCombo.add(this.STRING_DISPLAY_NODE);
        this.displayTypeCombo.add(this.STRING_DISPLAY_ITEMCODE);
        this.displayTypeCombo.add(this.STRING_DISPLAY_DEVICE);
        this.displayTypeCombo.select(0);
        this.displayTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Combo combo = (Combo)e.widget;
                String selectedDisplayType = combo.getText();
                m_log.debug((Object)("displayTypeCombo : select " + selectedDisplayType));
                if (PerformanceGraphComposite.this.STRING_DISPLAY_DEVICE.equals(selectedDisplayType)) {
                    PerformanceGraphComposite.this.displayItem.setEnabled(true);
                    PerformanceGraphComposite.this.displayItem.removeAll();
                    for (CollectorItemParentInfo itemCodeInfo : PerformanceGraphComposite.this.itemCodeListByDisplayDevice) {
                        PerformanceGraphComposite.this.displayItem.add(PerformanceGraphComposite.this.getFullItemName(itemCodeInfo));
                    }
                    PerformanceGraphComposite.this.displayItem.select(0);
                } else if (PerformanceGraphComposite.this.STRING_DISPLAY_ITEMCODE.equals(selectedDisplayType)) {
                    PerformanceGraphComposite.this.displayItem.removeAll();
                    for (CollectorItemParentInfo itemCodeInfo : PerformanceGraphComposite.this.performanceDataSettings.getItemCodeList()) {
                        PerformanceGraphComposite.this.displayItem.add(PerformanceGraphComposite.this.getFullItemName(itemCodeInfo));
                    }
                    PerformanceGraphComposite.this.displayItem.select(0);
                    PerformanceGraphComposite.this.displayItem.setEnabled(false);
                } else {
                    PerformanceGraphComposite.this.displayItem.setEnabled(true);
                    PerformanceGraphComposite.this.displayItem.removeAll();
                    for (CollectorItemParentInfo itemCodeInfo : PerformanceGraphComposite.this.performanceDataSettings.getItemCodeList()) {
                        PerformanceGraphComposite.this.displayItem.add(PerformanceGraphComposite.this.getFullItemName(itemCodeInfo));
                    }
                    PerformanceGraphComposite.this.displayItem.select(0);
                }
            }
        });
        Label graphTypeLabel = new Label((Composite)this, 0x1000000);
        graphTypeLabel.setText(String.valueOf(Messages.getString((String)"collection.label.graph.type")) + " : ");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        graphTypeLabel.setLayoutData((Object)gridData);
        this.graphTypeCombo = new Combo((Composite)this, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        this.graphTypeCombo.setLayoutData((Object)gridData);
        this.graphTypeCombo.add(this.STRING_GRAPH_LINE);
        this.graphTypeCombo.add(this.STRING_GRAPH_STACK);
        this.graphTypeCombo.select(0);
        Label space1 = new Label((Composite)this, 0x1000000);
        space1.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        space1.setLayoutData((Object)gridData);
        Label displayItemLabel = new Label((Composite)this, 0x1000000);
        displayItemLabel.setText(String.valueOf(Messages.getString((String)"collection.label.item")) + " : ");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        displayItemLabel.setLayoutData((Object)gridData);
        this.displayItem = new Combo((Composite)this, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        this.displayItem.setLayoutData((Object)gridData);
        this.displayItem.removeAll();
        for (CollectorItemParentInfo itemCodeInfo : this.performanceDataSettings.getItemCodeList()) {
            this.displayItem.add(this.getFullItemName(itemCodeInfo));
        }
        this.displayItem.select(0);
        Label updateLabel = new Label((Composite)this, 0x1000000);
        updateLabel.setText(String.valueOf(Messages.getString((String)"collection.label.update")) + " : ");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        updateLabel.setLayoutData((Object)gridData);
        this.autoUpdate = new Button((Composite)this, 32);
        this.autoUpdate.setText(Messages.getString((String)"collection.label.auto.update"));
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        this.autoUpdate.setLayoutData((Object)gridData);
        this.autoUpdate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerformanceGraphComposite.this.targetAutoUpdate = PerformanceGraphComposite.this.autoUpdate.getSelection();
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                String currentViewTitle = page.getActivePart().getTitle();
                m_log.debug((Object)("autoUpdate SelectionEvent : currentViewTitle = " + currentViewTitle));
                IViewReference[] iViewReferenceArray = page.getViewReferences();
                int n = iViewReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PerformanceGraphView view;
                    IViewReference ref = iViewReferenceArray[n2];
                    if (ref.getView(false) instanceof PerformanceGraphView && (view = (PerformanceGraphView)ref.getView(false)).getTitle().equals(currentViewTitle)) {
                        if (PerformanceGraphComposite.this.targetAutoUpdate) {
                            m_log.debug((Object)("autoUpdate SelectionEvent : Interval = " + PerformanceGraphComposite.this.performanceDataSettings.getInterval()));
                            int minute = 1;
                            if (PerformanceGraphComposite.this.performanceDataSettings.getInterval() > 60) {
                                minute = PerformanceGraphComposite.this.performanceDataSettings.getInterval() / 60;
                            }
                            view.setInterval(minute);
                            view.startAutoReload();
                            Object[] args = new String[]{Integer.toString(minute)};
                            MessageDialog.openInformation((Shell)PerformanceGraphComposite.this.getShell(), (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.collection.1", (Object[])args));
                            break;
                        }
                        view.stopAutoReload();
                        MessageDialog.openInformation((Shell)PerformanceGraphComposite.this.getShell(), (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.collection.2"));
                        break;
                    }
                    ++n2;
                }
            }
        });
        this.updateButton = new Button((Composite)this, 0x1000000);
        this.updateButton.setText(Messages.getString((String)"collection.button.apply"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 128;
        gridData.horizontalSpan = 1;
        this.updateButton.setLayoutData((Object)gridData);
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int graphType = 0;
                int displayType = 0;
                CollectorItemParentInfo itemCodeInfo = null;
                int graphTypeIndex = PerformanceGraphComposite.this.graphTypeCombo.getSelectionIndex();
                m_log.debug((Object)("updateButton SelectionEvent : graphTypeIndex = " + graphTypeIndex));
                switch (graphTypeIndex) {
                    case 0: {
                        graphType = 0;
                        break;
                    }
                    case 1: {
                        graphType = 1;
                        break;
                    }
                    default: {
                        graphType = 0;
                    }
                }
                int displayTypeIndex = PerformanceGraphComposite.this.displayTypeCombo.getSelectionIndex();
                int itemCodeInfoIndex = PerformanceGraphComposite.this.displayItem.getSelectionIndex();
                if (itemCodeInfoIndex < 0) {
                    MessageDialog.openWarning((Shell)PerformanceGraphComposite.this.getShell(), (String)Messages.getString((String)"message.hinemos.1"), (String)Messages.getString((String)"message.collection.4"));
                    return;
                }
                m_log.debug((Object)("updateButton SelectionEvent : displayTypeIndex = " + displayTypeIndex));
                switch (displayTypeIndex) {
                    case 0: {
                        displayType = 0;
                        itemCodeInfo = (CollectorItemParentInfo)PerformanceGraphComposite.this.performanceDataSettings.getItemCodeList().get(itemCodeInfoIndex);
                        break;
                    }
                    case 1: {
                        displayType = 1;
                        itemCodeInfo = (CollectorItemParentInfo)PerformanceGraphComposite.this.performanceDataSettings.getItemCodeList().get(itemCodeInfoIndex);
                        break;
                    }
                    case 2: {
                        displayType = 2;
                        itemCodeInfo = (CollectorItemParentInfo)PerformanceGraphComposite.this.itemCodeListByDisplayDevice.get(itemCodeInfoIndex);
                        break;
                    }
                    default: {
                        displayType = 0;
                    }
                }
                PerformanceGraphComposite.this.updateGraph(graphType, displayType, itemCodeInfo);
            }
        });
        this.chartComposite = new ChartComposite((Composite)this, 0, this.jfreeChart, true);
        gridData = new GridData();
        gridData.horizontalSpan = 13;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.chartComposite.setLayoutData((Object)gridData);
        this.firstButton = new Button((Composite)this, 0x1000000);
        this.firstButton.setText(this.STRING_ACTION_OLDEST);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.firstButton.setLayoutData((Object)gridData);
        this.firstButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerformanceGraphComposite.this.updateByRangeAction(0);
            }
        });
        this.backButton = new Button((Composite)this, 0x1000000);
        this.backButton.setText(this.STRING_ACTION_PREV);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.backButton.setLayoutData((Object)gridData);
        this.backButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerformanceGraphComposite.this.updateByRangeAction(1);
            }
        });
        Label space4 = new Label((Composite)this, 0x1000000);
        space4.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        space4.setLayoutData((Object)gridData);
        Label spanLabel = new Label((Composite)this, 0x1000000);
        spanLabel.setText(String.valueOf(Messages.getString((String)"collection.label.span")) + " : ");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        spanLabel.setLayoutData((Object)gridData);
        this.hourButton = new Button((Composite)this, 2);
        this.hourButton.setText(this.STRING_TIME_HOUR);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.hourButton.setLayoutData((Object)gridData);
        this.hourButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerformanceGraphComposite.this.dayButton.setSelection(false);
                PerformanceGraphComposite.this.weekButton.setSelection(false);
                PerformanceGraphComposite.this.monthButton.setSelection(false);
                PerformanceGraphComposite.this.updateGraphRange(0);
            }
        });
        this.hourButton.setSelection(true);
        this.dayButton = new Button((Composite)this, 2);
        this.dayButton.setText(this.STRING_TIME_DAY);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.dayButton.setLayoutData((Object)gridData);
        this.dayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerformanceGraphComposite.this.hourButton.setSelection(false);
                PerformanceGraphComposite.this.weekButton.setSelection(false);
                PerformanceGraphComposite.this.monthButton.setSelection(false);
                PerformanceGraphComposite.this.updateGraphRange(1);
            }
        });
        this.weekButton = new Button((Composite)this, 2);
        this.weekButton.setText(this.STRING_TIME_WEEK);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 128;
        gridData.horizontalSpan = 1;
        this.weekButton.setLayoutData((Object)gridData);
        this.weekButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerformanceGraphComposite.this.hourButton.setSelection(false);
                PerformanceGraphComposite.this.dayButton.setSelection(false);
                PerformanceGraphComposite.this.monthButton.setSelection(false);
                PerformanceGraphComposite.this.updateGraphRange(2);
            }
        });
        this.monthButton = new Button((Composite)this, 2);
        this.monthButton.setText(this.STRING_TIME_MONTH);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.monthButton.setLayoutData((Object)gridData);
        this.monthButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerformanceGraphComposite.this.hourButton.setSelection(false);
                PerformanceGraphComposite.this.dayButton.setSelection(false);
                PerformanceGraphComposite.this.weekButton.setSelection(false);
                PerformanceGraphComposite.this.updateGraphRange(3);
            }
        });
        Label space5 = new Label((Composite)this, 0x1000000);
        space5.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        space5.setLayoutData((Object)gridData);
        this.forwardButton = new Button((Composite)this, 0x1000000);
        this.forwardButton.setText(this.STRING_ACTION_NEXT);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.forwardButton.setLayoutData((Object)gridData);
        this.forwardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerformanceGraphComposite.this.updateByRangeAction(2);
            }
        });
        this.lastButton = new Button((Composite)this, 0x1000000);
        this.lastButton.setText(this.STRING_ACTION_NEWEST);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.lastButton.setLayoutData((Object)gridData);
        this.lastButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerformanceGraphComposite.this.updateByRangeAction(3);
            }
        });
    }

    private String getFullItemName(CollectorItemParentInfo info) {
        if (info.getDisplayName() != null && !"".equals(info.getDisplayName())) {
            return String.valueOf(PerformanceDataSettingsUtil.getItemName(this.performanceDataSettings, info.getItemCode())) + "[" + info.getDisplayName() + "]";
        }
        return PerformanceDataSettingsUtil.getItemName(this.performanceDataSettings, info.getItemCode());
    }

    private void setPerformanceDataSettings(PerformanceDataSettings info) {
        this.performanceDataSettings = info;
        this.targetItemCodeInfo = this.performanceDataSettings.getItemCodeList() != null && this.performanceDataSettings.getItemCodeList().size() > 0 ? (CollectorItemParentInfo)this.performanceDataSettings.getItemCodeList().get(0) : null;
        TreeSet<String> itemCodeSet = new TreeSet<String>();
        for (CollectorItemParentInfo itemCodeInfo : this.performanceDataSettings.getItemCodeList()) {
            if (itemCodeInfo.getDisplayName() == null || "".equals(itemCodeInfo.getDisplayName())) continue;
            itemCodeSet.add(itemCodeInfo.getItemCode());
        }
        for (String code : itemCodeSet) {
            CollectorItemParentInfo itemCodeInfo = new CollectorItemParentInfo();
            itemCodeInfo.setItemCode(code);
            itemCodeInfo.setDisplayName("");
            itemCodeInfo.setParentItemCode("");
            itemCodeInfo.setCollectorId(this.performanceDataSettings.getMonitorId());
            this.itemCodeListByDisplayDevice.add(itemCodeInfo);
        }
    }

    public void updateGraph(FacilityTreeItem item) {
        m_log.debug((Object)("updateGraph() facilityId = " + item.getData().getFacilityId() + ", facilityType = " + item.getData().getFacilityType()));
        if (this.targetItemCodeInfo == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.collection.6"));
            return;
        }
        if (this.validateGrapSettings(item.getData().getFacilityType(), this.targetDiaplayType, this.targetItemCodeInfo.getItemCode(), this.targetItemCodeInfo.getDisplayName())) {
            this.targetFacilityTreeItem = item;
            this.updateGraph();
        }
    }

    private void updateGraph(int graphType, int displayType, CollectorItemParentInfo itemCodeInfo) {
        m_log.debug((Object)("updateGrap() graphType = " + graphType + ", displayType = " + displayType + ", itemCode = " + itemCodeInfo.getItemCode() + ", displayName = " + itemCodeInfo.getDisplayName()));
        if (this.targetItemCodeInfo == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.collection.6"));
            return;
        }
        if (this.validateGrapSettings(this.targetFacilityTreeItem.getData().getFacilityType(), displayType, itemCodeInfo.getItemCode(), itemCodeInfo.getDisplayName())) {
            this.targetGraphType = graphType;
            this.targetDiaplayType = displayType;
            this.targetItemCodeInfo = itemCodeInfo;
            this.updateGraph();
        }
    }

    private void updateGraph() {
        m_log.debug((Object)"updateGraph()");
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        this.jfreeChart = ChartFactory.createTimeSeriesChart((String)"", (String)com.clustercontrol.performance.util.Messages.getString("TIME"), (String)this.performanceDataSettings.getMeasure(), (XYDataset)this.timeSeriesCollection, (boolean)true, (boolean)true, (boolean)false);
        this.chartComposite.setChart(this.jfreeChart);
        StandardXYItemRenderer renderer = null;
        switch (this.targetGraphType) {
            case 0: {
                renderer = new StandardXYItemRenderer();
                int i = 0;
                while (i < this.GRAPH_MAX) {
                    renderer.setSeriesPaint(i, (Paint)this.color[i % this.color.length]);
                    ++i;
                }
                this.jfreeChart.getXYPlot().setRenderer((XYItemRenderer)renderer);
                break;
            }
            case 1: {
                renderer = new XYAreaRenderer();
                int i = 0;
                while (i < this.GRAPH_MAX) {
                    renderer.setSeriesPaint(i, (Paint)this.color[i % this.color.length]);
                    ++i;
                }
                this.jfreeChart.getXYPlot().setRenderer((XYItemRenderer)renderer);
                break;
            }
            default: {
                m_log.warn((Object)("updateGraph() targetGraphType is not defined. targetGraphType = " + this.targetGraphType));
            }
        }
        if ("MON_PRF".equals(this.performanceDataSettings.getMonitorTypeId())) {
            ValueAxis valueaxis;
            boolean rangeFixed = CollectorItemCodeFactory.isRangeFixed(this.performanceDataSettings.getTargetItemCode(), this.targetGraphType);
            if (rangeFixed) {
                valueaxis = this.jfreeChart.getXYPlot().getRangeAxis();
                valueaxis.setRange(0.0, 100.0);
            } else {
                valueaxis = (NumberAxis)this.jfreeChart.getXYPlot().getRangeAxis();
                valueaxis.setAutoRangeIncludesZero(true);
            }
        }
        this.targetConditionFacilityIdList.clear();
        switch (this.targetFacilityTreeItem.getData().getFacilityType()) {
            case 1: {
                this.targetConditionFacilityIdList.clear();
                this.targetConditionFacilityIdList.add(this.targetFacilityTreeItem.getData().getFacilityId());
                break;
            }
            case 0: {
                this.targetConditionFacilityIdList.clear();
                this.setTargetNodeFacilityId(this.targetFacilityTreeItem, this.targetConditionFacilityIdList);
            }
        }
        this.targetConditionItemList.clear();
        CollectorItemInfo itemInfo = null;
        switch (this.targetDiaplayType) {
            case 0: {
                itemInfo = new CollectorItemInfo();
                itemInfo.setCollectorId(this.performanceDataSettings.getMonitorId());
                itemInfo.setItemCode(this.targetItemCodeInfo.getItemCode());
                itemInfo.setDisplayName(this.targetItemCodeInfo.getDisplayName());
                this.targetConditionItemList.add(itemInfo);
                m_log.debug((Object)("updateGraph() DISPLAY_NODE itemCode = " + itemInfo.getItemCode() + ", displayName = " + itemInfo.getDisplayName()));
                break;
            }
            case 1: {
                for (CollectorItemParentInfo info : this.performanceDataSettings.getItemCodeList()) {
                    if (!this.targetItemCodeInfo.getItemCode().equals(info.getParentItemCode())) continue;
                    itemInfo = new CollectorItemInfo();
                    itemInfo.setCollectorId(this.performanceDataSettings.getMonitorId());
                    itemInfo.setItemCode(info.getItemCode());
                    itemInfo.setDisplayName(info.getDisplayName());
                    this.targetConditionItemList.add(itemInfo);
                    m_log.debug((Object)("updateGraph() DISPLAY_ITEMCODE itemCode = " + itemInfo.getItemCode() + ", displayName = " + itemInfo.getDisplayName()));
                }
                break;
            }
            case 2: {
                for (CollectorItemParentInfo info : this.performanceDataSettings.getItemCodeList()) {
                    if (!this.targetItemCodeInfo.getItemCode().equals(info.getItemCode())) continue;
                    itemInfo = new CollectorItemInfo();
                    itemInfo.setCollectorId(this.performanceDataSettings.getMonitorId());
                    itemInfo.setItemCode(info.getItemCode());
                    itemInfo.setDisplayName(info.getDisplayName());
                    this.targetConditionItemList.add(itemInfo);
                    m_log.debug((Object)("updateGraph() DISPLAY_ITEMCODE itemCode = " + itemInfo.getItemCode() + ", displayName = " + itemInfo.getDisplayName()));
                }
                break;
            }
        }
        this.updateGraphRange();
    }

    private void setTargetNodeFacilityId(FacilityTreeItem treeItem, ArrayList<String> facilityIdList) {
        m_log.debug((Object)("setTargetNodeFacilityId() treeItem = " + treeItem.getData().getFacilityId()));
        if (facilityIdList != null && facilityIdList.size() >= this.GRAPH_MAX) {
            m_log.info((Object)("setTargetNodeFacilityId() target facilityId is over GRAPH_MAX = " + this.GRAPH_MAX));
            Object[] args = new String[]{Integer.toString(this.GRAPH_MAX)};
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.performance.2", (Object[])args));
            return;
        }
        List children = treeItem.getChildren();
        int i = 0;
        while (i < children.size()) {
            FacilityTreeItem item = (FacilityTreeItem)children.get(i);
            switch (item.getData().getFacilityType()) {
                case 1: {
                    if (facilityIdList != null && facilityIdList.size() >= this.GRAPH_MAX) {
                        m_log.info((Object)("setTargetNodeFacilityId() target facilityId is over GRAPH_MAX = " + this.GRAPH_MAX));
                        Object[] args = new String[]{Integer.toString(this.GRAPH_MAX)};
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.performance.2", (Object[])args));
                        return;
                    }
                    facilityIdList.add(item.getData().getFacilityId());
                    break;
                }
                case 0: {
                    this.setTargetNodeFacilityId(item, facilityIdList);
                    break;
                }
            }
            ++i;
        }
    }

    private void updateGraphRange(int range) {
        m_log.debug((Object)("updateGraphRange() range = " + range));
        if (this.targetConditionStartDate == null || this.targetConditionEndDate == null) {
            m_log.debug((Object)("updateGraphRange() targetConditionStartDate = " + this.targetConditionStartDate + ", targetConditionEndDate = " + this.targetConditionEndDate));
            return;
        }
        this.setTargetTimePeriod(range, this.targetConditionStartDate);
        this.updateGraphRange();
    }

    private void setRanePlotFormat() {
        switch (this.targetRange) {
            case 0: {
                ((DateAxis)this.jfreeChart.getXYPlot().getDomainAxis()).setDateFormatOverride((DateFormat)new SimpleDateFormat("HH:mm"));
                break;
            }
            case 1: {
                ((DateAxis)this.jfreeChart.getXYPlot().getDomainAxis()).setDateFormatOverride((DateFormat)new SimpleDateFormat("HH:mm"));
                break;
            }
            case 2: {
                ((DateAxis)this.jfreeChart.getXYPlot().getDomainAxis()).setDateFormatOverride((DateFormat)new SimpleDateFormat("MM/dd HH:mm"));
                break;
            }
            case 3: {
                ((DateAxis)this.jfreeChart.getXYPlot().getDomainAxis()).setDateFormatOverride((DateFormat)new SimpleDateFormat("MM/dd"));
                break;
            }
        }
    }

    private void setTargetTimePeriod(int range, Date targetDate) {
        m_log.debug((Object)("setTargetTimePeriod() targetDate = " + targetDate));
        this.targetRange = range;
        switch (this.targetRange) {
            case 0: {
                this.targetConditionStartDate = DateUtils.truncate((Date)targetDate, (int)10);
                this.targetConditionEndDate = new Date(this.targetConditionStartDate.getTime() + 3600000L);
                break;
            }
            case 1: {
                this.targetConditionStartDate = DateUtils.truncate((Date)targetDate, (int)5);
                this.targetConditionEndDate = new Date(this.targetConditionStartDate.getTime() + 86400000L);
                break;
            }
            case 2: {
                Date tmpDate = DateUtils.truncate((Date)targetDate, (int)5);
                Calendar cal = Calendar.getInstance();
                cal.setTime(tmpDate);
                int days = cal.get(7) - 1;
                this.targetConditionStartDate = new Date(tmpDate.getTime() - (long)days * 86400000L);
                this.targetConditionEndDate = new Date(this.targetConditionStartDate.getTime() + 604800000L);
                break;
            }
            case 3: {
                this.targetConditionStartDate = DateUtils.truncate((Date)targetDate, (int)2);
                this.targetConditionEndDate = new Date(this.targetConditionStartDate.getTime() + 2678400000L);
                break;
            }
        }
        m_log.debug((Object)("setTargetTimePeriod() targetConditionStartDate = " + this.targetConditionStartDate + ", targetConditionEndDate = " + this.targetConditionEndDate));
    }

    public void update() {
        super.update();
        this.updateByRangeAction(3);
    }

    private void updateByRangeAction(int action) {
        m_log.debug((Object)("updateByRangeAction() action = " + action));
        if (this.targetConditionStartDate == null || this.targetConditionEndDate == null) {
            m_log.debug((Object)("updateGraphRange() targetConditionStartDate = " + this.targetConditionStartDate + ", targetConditionEndDate = " + this.targetConditionEndDate));
            return;
        }
        long distance = 0L;
        switch (action) {
            case 0: {
                this.setTargetTimePeriod(this.targetRange, new Date(this.performanceDataSettings.getOldestDate()));
                break;
            }
            case 1: {
                distance = this.targetConditionEndDate.getTime() - this.targetConditionStartDate.getTime();
                this.targetConditionEndDate = this.targetConditionStartDate;
                this.targetConditionStartDate = new Date(this.targetConditionStartDate.getTime() - distance);
                break;
            }
            case 2: {
                distance = this.targetConditionEndDate.getTime() - this.targetConditionStartDate.getTime();
                this.targetConditionStartDate = this.targetConditionEndDate;
                this.targetConditionEndDate = new Date(this.targetConditionEndDate.getTime() + distance);
                break;
            }
            case 3: {
                this.setTargetTimePeriod(this.targetRange, new Date(this.performanceDataSettings.getLatestDate()));
                break;
            }
        }
        this.updateGraphRange();
    }

    private void updateGraphRange() {
        if (this.targetConditionStartDate == null || this.targetConditionEndDate == null) {
            this.setTargetTimePeriod(this.targetRange, new Date(this.performanceDataSettings.getLatestDate()));
        }
        ValueAxis domainAxis = this.jfreeChart.getXYPlot().getDomainAxis();
        domainAxis.setRange((double)this.targetConditionStartDate.getTime(), (double)this.targetConditionEndDate.getTime());
        this.updateGraphData();
    }

    private void updateGraphData() {
        m_log.debug((Object)"updateGraphData()");
        this.setRanePlotFormat();
        CollectedDataSet dataSet = new RecordController().getRecordCollectedData(this.targetConditionFacilityIdList, this.targetConditionItemList, this.targetConditionStartDate, this.targetConditionEndDate);
        if (dataSet == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"message.hinemos.1"), (String)Messages.getString((String)"message.collection.7"));
            return;
        }
        this.timeSeriesCollection.removeAllSeries();
        this.timeSeries = new TimeSeries[this.GRAPH_MAX];
        int i = 0;
        while (i < this.timeSeries.length) {
            this.timeSeries[i] = new TimeSeries((Comparable)((Object)""));
            ++i;
        }
        int dataIndex = 0;
        List<CollectedDataInfo> collectedDataListTotal = null;
        block5: for (String facilityId : this.targetConditionFacilityIdList) {
            for (CollectorItemInfo itemInfo : this.targetConditionItemList) {
                if (dataIndex == this.GRAPH_MAX) {
                    Object[] args = new String[]{Integer.toString(this.GRAPH_MAX)};
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.performance.2", (Object[])args));
                    break block5;
                }
                List<CollectedDataInfo> collectedDataList = CollectedDataSetUtil.getCollectedDataList(dataSet, facilityId, itemInfo);
                String name = this.getGraphLegends(facilityId, itemInfo);
                switch (this.targetGraphType) {
                    case 0: {
                        this.setGraphData(dataIndex, name, collectedDataList);
                        break;
                    }
                    case 1: {
                        collectedDataListTotal = this.getSumData(collectedDataListTotal, collectedDataList);
                        this.setGraphData(dataIndex, name, collectedDataListTotal);
                        break;
                    }
                }
                ++dataIndex;
            }
        }
        String title = this.getGraphTitle();
        this.jfreeChart.setTitle(title);
    }

    private String getGraphLegends(String facilityId, CollectorItemInfo itemInfo) {
        String name = null;
        switch (this.targetDiaplayType) {
            case 0: {
                name = facilityId;
                break;
            }
            case 1: {
                if (itemInfo.getDisplayName() != null && !"".equals(itemInfo.getDisplayName())) {
                    name = String.valueOf(PerformanceDataSettingsUtil.getItemName(this.performanceDataSettings, itemInfo.getItemCode())) + "[" + itemInfo.getDisplayName() + "]";
                    break;
                }
                name = PerformanceDataSettingsUtil.getItemName(this.performanceDataSettings, itemInfo.getItemCode());
                break;
            }
            case 2: {
                name = "[" + itemInfo.getDisplayName() + "]";
                break;
            }
        }
        return name;
    }

    private String getGraphTitle() {
        String title = null;
        switch (this.targetDiaplayType) {
            case 0: {
                title = this.targetItemCodeInfo.getDisplayName() != null && !"".equals(this.targetItemCodeInfo.getDisplayName()) ? String.valueOf(PerformanceDataSettingsUtil.getItemName(this.performanceDataSettings, this.targetItemCodeInfo.getItemCode())) + "[" + this.targetItemCodeInfo.getDisplayName() + "]" : PerformanceDataSettingsUtil.getItemName(this.performanceDataSettings, this.targetItemCodeInfo.getItemCode());
                title = String.valueOf(title) + " " + this.STRING_DISPLAY_NODE;
                break;
            }
            case 1: {
                title = this.targetItemCodeInfo.getDisplayName() != null && !"".equals(this.targetItemCodeInfo.getDisplayName()) ? String.valueOf(PerformanceDataSettingsUtil.getItemName(this.performanceDataSettings, this.targetItemCodeInfo.getItemCode())) + "[" + this.targetItemCodeInfo.getDisplayName() + "]" : PerformanceDataSettingsUtil.getItemName(this.performanceDataSettings, this.targetItemCodeInfo.getItemCode());
                title = String.valueOf(title) + " " + this.STRING_DISPLAY_ITEMCODE;
                break;
            }
            case 2: {
                title = PerformanceDataSettingsUtil.getItemName(this.performanceDataSettings, this.targetItemCodeInfo.getItemCode());
                title = String.valueOf(title) + " " + this.STRING_DISPLAY_DEVICE;
                break;
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        title = String.valueOf(title) + "(" + df.format(this.targetConditionStartDate) + " - " + df.format(this.targetConditionEndDate) + ")";
        return title;
    }

    private List<CollectedDataInfo> getSumData(List<CollectedDataInfo> dataSet1, List<CollectedDataInfo> dataSet2) {
        if (dataSet1 == null && dataSet2 != null) {
            return dataSet2;
        }
        if (dataSet2 == null && dataSet1 != null) {
            return dataSet1;
        }
        if (dataSet1 == null && dataSet2 == null) {
            return new ArrayList<CollectedDataInfo>();
        }
        ArrayList<CollectedDataInfo> dataList = new ArrayList<CollectedDataInfo>();
        block0: for (CollectedDataInfo data1 : dataSet1) {
            for (CollectedDataInfo data2 : dataSet2) {
                if (data1.getDate().longValue() != data2.getDate().longValue()) continue;
                CollectedDataInfo returnData = new CollectedDataInfo();
                returnData.setFacilityId(data1.getFacilityId());
                returnData.setItemCode(data1.getItemCode());
                returnData.setDisplayName(data1.getDisplayName());
                returnData.setDate(data1.getDate());
                returnData.setValue(Double.valueOf(data1.getValue() + data2.getValue()));
                returnData.setErrorType(Integer.valueOf(0));
                dataList.add(returnData);
                continue block0;
            }
        }
        return dataList;
    }

    private void setGraphData(int index, String name, List<CollectedDataInfo> collectedDataList) {
        m_log.debug((Object)("setGraphData() index = " + index + ", name = " + name));
        TimeSeries a = this.timeSeriesCollection.getSeries((Comparable)((Object)name));
        if (a == null) {
            this.timeSeries[index].setKey((Comparable)((Object)name));
            this.timeSeriesCollection.addSeries(this.timeSeries[index]);
        }
        for (CollectedDataInfo data : collectedDataList) {
            if (Double.isNaN(data.getValue())) continue;
            if (data.getValue() >= 0.0) {
                this.timeSeries[index].addOrUpdate((RegularTimePeriod)new Second(new Date(data.getDate())), (Number)data.getValue());
            }
            if (data.getDate() <= this.performanceDataSettings.getLatestDate()) continue;
            this.performanceDataSettings.setLatestDate(data.getDate());
            m_log.debug((Object)("LatestDate Update = " + this.performanceDataSettings.getLatestDate()));
        }
    }

    private boolean validateGrapSettings(int facilityType, int displayType, String itemCode, String displayName) {
        m_log.debug((Object)("validateGrapSettings() facilityType = " + facilityType + ", displayType = " + displayType + ", itemCode = " + itemCode + ", displayName = " + displayName));
        boolean valid = false;
        if (facilityType == 0) {
            switch (displayType) {
                case 0: {
                    valid = true;
                    break;
                }
                default: {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString((String)"message.hinemos.1"), (String)Messages.getString((String)"message.collection.3"));
                    break;
                }
            }
        } else {
            switch (displayType) {
                case 2: {
                    for (CollectorItemParentInfo itemCodeInfo : this.performanceDataSettings.getItemCodeList()) {
                        if (itemCode == null || !itemCode.equals(itemCodeInfo.getItemCode()) || itemCodeInfo.getDisplayName() == null || "".equals(itemCodeInfo.getDisplayName())) continue;
                        valid = true;
                        break;
                    }
                    if (valid) break;
                    MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString((String)"message.hinemos.1"), (String)Messages.getString((String)"message.collection.4"));
                    break;
                }
                case 1: {
                    for (CollectorItemParentInfo itemCodeInfo : this.performanceDataSettings.getItemCodeList()) {
                        if (itemCodeInfo.getParentItemCode() == null || !itemCodeInfo.getParentItemCode().equals(itemCode)) continue;
                        valid = true;
                        break;
                    }
                    if (valid) break;
                    MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString((String)"message.hinemos.1"), (String)Messages.getString((String)"message.collection.5"));
                    break;
                }
                default: {
                    valid = true;
                }
            }
        }
        m_log.debug((Object)("validateGrapSettings() is " + valid));
        return valid;
    }

    public JFreeChart getChart() {
        return this.jfreeChart;
    }

    public void setGraphMax(int max) {
        this.GRAPH_MAX = max;
    }

    public PerformanceDataSettings getPerformanceDataSettings() {
        return this.performanceDataSettings;
    }
}

