/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.action;

import com.clustercontrol.performance.util.CollectorEndpointWrapper;
import com.clustercontrol.ws.collector.CollectedDataSet;
import com.clustercontrol.ws.collector.CollectorItemInfo;
import com.clustercontrol.ws.collector.CollectorItemTreeItem;
import com.clustercontrol.ws.collector.HashMapInfo;
import com.clustercontrol.ws.collector.InvalidRole_Exception;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RecordController {
    private static Log log = LogFactory.getLog(RecordController.class);
    private int errorCount = 1;
    public static final String KEY_EJB_URL = "ejbUrl";
    public static final String VALUE_EJB_URL = "http://localhost:8080/HinemosWS/";

    public CollectedDataSet getRecordCollectedData(ArrayList<String> facilityIdList, ArrayList<CollectorItemInfo> itemInfoList, Date startDate, Date endDate) {
        log.debug((Object)("getRecordCollectedData() startDate = " + startDate + ", endDate = " + endDate));
        CollectedDataSet dataSet = null;
        try {
            dataSet = CollectorEndpointWrapper.getRecordCollectedDataFromIdList(facilityIdList, itemInfoList, startDate.getTime(), endDate.getTime());
        }
        catch (InvalidRole_Exception e) {
            log.error((Object)"getRecordCollectedData()", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"getRecordCollectedData()", (Throwable)e);
        }
        return dataSet;
    }

    public HashMap<String, CollectorItemTreeItem> getItemCodeTreeMap() {
        log.debug((Object)"getItemCodeTreeMap()");
        CollectorItemTreeItem treeItem = null;
        int i = 0;
        while (i <= this.errorCount) {
            try {
                HashMapInfo hashMapInfo = CollectorEndpointWrapper.getItemCodeMap();
                HashMapInfo.Map2 map2 = hashMapInfo.getMap2();
                HashMap<String, CollectorItemTreeItem> rtnMap = new HashMap<String, CollectorItemTreeItem>();
                for (HashMapInfo.Map2.Entry entry : map2.getEntry()) {
                    treeItem = entry.getValue();
                    RecordController.setTreeParent(treeItem);
                    rtnMap.put(entry.getKey(), treeItem);
                }
                return rtnMap;
            }
            catch (InvalidRole_Exception e) {
                log.error((Object)"getItemCodeTreeMap()", (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)"getItemCodeTreeMap()", (Throwable)e);
            }
            ++i;
        }
        return null;
    }

    private static void setTreeParent(CollectorItemTreeItem item) {
        List children = item.getChildren();
        for (CollectorItemTreeItem child : children) {
            child.setParent(item);
            RecordController.setTreeParent(child);
        }
    }
}

