/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.mail.composite;

import com.clustercontrol.notify.mail.dialog.MailTemplateCreateDialog;
import com.clustercontrol.notify.mail.util.MailTemplateEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.mailtemplate.InvalidRole_Exception;
import com.clustercontrol.ws.mailtemplate.MailTemplateInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class MailTemplateIdListComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(MailTemplateIdListComposite.class);
    private String m_text = null;
    private Label m_labelMailTemplateId = null;
    private Combo m_comboMailTemplateId = null;
    private Button m_buttonRefer = null;

    public MailTemplateIdListComposite(Composite parent, int style, boolean labelFlg) {
        super(parent, style);
        this.m_text = Messages.getString((String)"mail.template.id");
        this.initialize(parent, labelFlg);
    }

    public MailTemplateIdListComposite(Composite parent, int style, String text) {
        super(parent, style);
        this.m_text = text;
        this.initialize(parent, true);
    }

    private void initialize(Composite parent, boolean labelFlg) {
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = labelFlg ? 10 : 5;
        this.setLayout((Layout)layout);
        if (labelFlg) {
            this.m_labelMailTemplateId = new Label((Composite)this, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.m_labelMailTemplateId.setLayoutData((Object)gridData);
            this.m_labelMailTemplateId.setText(String.valueOf(this.m_text) + " : ");
        }
        this.m_comboMailTemplateId = new Combo((Composite)this, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboMailTemplateId.setLayoutData((Object)gridData);
        this.m_buttonRefer = new Button((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_buttonRefer.setLayoutData((Object)gridData);
        this.m_buttonRefer.setText(Messages.getString((String)"refer"));
        this.m_buttonRefer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String mailTemplateId = MailTemplateIdListComposite.this.m_comboMailTemplateId.getText();
                if (mailTemplateId != null && !"".equals(mailTemplateId.trim())) {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    MailTemplateCreateDialog dialog = new MailTemplateCreateDialog(shell, mailTemplateId, 2);
                    dialog.open();
                }
            }
        });
        this.update();
    }

    public void update() {
    }

    public void update(String ownerRoleId) {
        this.m_comboMailTemplateId.removeAll();
        this.m_comboMailTemplateId.add("");
        ArrayList<String> list = null;
        try {
            List<MailTemplateInfo> listTmp = MailTemplateEndpointWrapper.getMailTemplateListByOwnerRole(ownerRoleId);
            list = new ArrayList<String>();
            for (MailTemplateInfo info : listTmp) {
                list.add(info.getMailTemplateId());
            }
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("update() getMailTemplateList, " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        if (list != null) {
            int index = 0;
            while (index < list.size()) {
                this.m_comboMailTemplateId.add((String)list.get(index));
                ++index;
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.m_comboMailTemplateId.setEnabled(enabled);
        this.m_buttonRefer.setEnabled(enabled);
    }

    public String getText() {
        return this.m_comboMailTemplateId.getText();
    }

    public void setText(String string) {
        this.m_comboMailTemplateId.setText(string);
    }
}

