/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.dialog;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.notify.action.DeleteNotify;
import com.clustercontrol.notify.action.GetNotify;
import com.clustercontrol.notify.action.ModifyNotify;
import com.clustercontrol.notify.composite.NotifyListComposite;
import com.clustercontrol.notify.dialog.NotifyTypeDialog;
import com.clustercontrol.notify.view.action.NotifyModifyAction;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.notify.NotifyInfo;
import com.clustercontrol.ws.notify.NotifyRelationInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class NotifyListDialog
extends CommonDialog {
    private static Log m_log = LogFactory.getLog(NotifyListDialog.class);
    private final int sizeX = 800;
    private final int sizeY = 450;
    private NotifyListComposite notifyList = null;
    private Button buttonAdd = null;
    private Button buttonModify = null;
    private Button buttonDelete = null;
    private Button buttonValid = null;
    private Button buttonInvalid = null;
    boolean isSelect = false;
    String ownerRoleId = null;
    List<NotifyRelationInfo> notify;

    public NotifyListDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    public NotifyListDialog(Shell parent, boolean isSelect, int notifyIdType, String ownerRoleId) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.isSelect = isSelect;
        this.ownerRoleId = ownerRoleId;
    }

    protected Point getInitialSize() {
        return new Point(800, 450);
    }

    @Override
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.notify.list"));
        GridLayout layout = new GridLayout(8, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 8;
        parent.setLayout((Layout)layout);
        this.notifyList = new NotifyListComposite(parent, 2048, this.isSelect, this.ownerRoleId);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 7;
        gridData.heightHint = 128;
        this.notifyList.setLayoutData(gridData);
        this.notifyList.setSelectNotify(this.notify);
        this.notifyList.update();
        if (!this.notifyList.isShowFlg()) {
            this.close();
            return;
        }
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        composite.setLayoutData((Object)gridData);
        this.buttonAdd = this.createButton(composite, Messages.getString((String)"add"));
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyTypeDialog dialog = new NotifyTypeDialog(NotifyListDialog.this.getParentShell(), NotifyListDialog.this.notifyList);
                dialog.open();
            }
        });
        new Label(composite, 0);
        this.buttonModify = this.createButton(composite, Messages.getString((String)"modify"));
        this.buttonModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String notifyId = null;
                Integer notifyType = null;
                Table table = NotifyListDialog.this.notifyList.getTableViewer().getTable();
                TableItem[] item = table.getSelection();
                if (item != null && item.length > 0) {
                    try {
                        notifyId = (String)((ArrayList)item[0].getData()).get(2);
                        notifyType = (Integer)((ArrayList)item[0].getData()).get(4);
                    }
                    catch (Exception exception) {}
                }
                if (notifyId != null && notifyType != null) {
                    NotifyModifyAction action = new NotifyModifyAction();
                    if (action.openDialog(NotifyListDialog.this.getParentShell(), notifyId, notifyType) == 0) {
                        int selectIndex = table.getSelectionIndex();
                        NotifyListDialog.this.notifyList.update();
                        table.setSelection(selectIndex);
                    }
                } else {
                    MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)Messages.getString((String)"message.notify.8"));
                }
            }
        });
        new Label(composite, 0);
        this.buttonDelete = this.createButton(composite, Messages.getString((String)"delete"));
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String notifyId = null;
                Table table = NotifyListDialog.this.notifyList.getTableViewer().getTable();
                TableItem[] item = table.getSelection();
                if (item != null && item.length > 0) {
                    try {
                        notifyId = (String)((ArrayList)item[0].getData()).get(2);
                    }
                    catch (Exception exception) {}
                }
                if (notifyId != null) {
                    DeleteNotify deleteNotify = new DeleteNotify();
                    if (deleteNotify.useCheck(notifyId) == 0) {
                        boolean result;
                        Object[] args = new String[]{notifyId};
                        if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.notify.7", (Object[])args)) && (result = deleteNotify.delete(notifyId))) {
                            NotifyListDialog.this.notifyList.update();
                        }
                    }
                } else {
                    MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)Messages.getString((String)"message.notify.9"));
                }
            }
        });
        new Label(composite, 0);
        new Label(composite, 0);
        this.buttonValid = this.createButton(composite, Messages.getString((String)"valid"));
        this.buttonValid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyListDialog.this.setValid(1);
            }
        });
        this.buttonInvalid = this.createButton(composite, Messages.getString((String)"invalid"));
        this.buttonInvalid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyListDialog.this.setValid(0);
            }
        });
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        shell.pack();
        shell.setSize(new Point(800, 450));
    }

    @Override
    protected ValidateResult validate() {
        return super.validate();
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(label);
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.isSelect) {
            this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
        } else {
            this.createButton(parent, 1, IDialogConstants.OK_LABEL, false);
        }
    }

    public void setSelectNotify(List<NotifyRelationInfo> notify) {
        this.notify = notify;
    }

    public List<NotifyRelationInfo> getSelectNotify() {
        return this.notifyList.getSelectNotify();
    }

    protected void cancelPressed() {
        if (this.isSelect && !this.notifyList.makeNotifyData()) {
            MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)Messages.getString((String)"message.notify.25"));
            return;
        }
        super.cancelPressed();
    }

    public void setValid(int valid) {
        ArrayList<String> list = this.notifyList.getSelectionData();
        if (list != null && list.size() > 0) {
            StringBuilder notifyIds = new StringBuilder();
            int i = 0;
            while (i < list.size()) {
                if (i > 0) {
                    notifyIds.append(", ");
                }
                notifyIds.append(list.get(i));
                ++i;
            }
            Object[] confirmArgs = new String[]{notifyIds.toString()};
            String message = valid == 1 ? Messages.getString((String)"message.notify.34", (Object[])confirmArgs) : Messages.getString((String)"message.notify.37", (Object[])confirmArgs);
            if (!MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)message)) {
                return;
            }
            int i2 = 0;
            while (i2 < list.size()) {
                String notifyId = list.get(i2);
                if (notifyId != null && !notifyId.equals("")) {
                    NotifyInfo info = new GetNotify().getNotify(notifyId);
                    info.setValidFlg(Integer.valueOf(valid));
                    new ModifyNotify().modify(info);
                }
                ++i2;
            }
            int selectIndex = this.notifyList.getTableViewer().getTable().getSelectionIndex();
            this.notifyList.update();
            this.notifyList.getTableViewer().getTable().setSelection(selectIndex);
        } else {
            MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)Messages.getString((String)"message.notify.10"));
        }
    }
}

