/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.view.action;

import com.clustercontrol.monitor.composite.EventListComposite;
import com.clustercontrol.monitor.util.ConvertListUtil;
import com.clustercontrol.monitor.util.MonitorEndpointWrapper;
import com.clustercontrol.monitor.view.EventView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.EventDataInfo;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.MonitorNotFound_Exception;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class EventConfirmAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(EventConfirmAction.class);
    public static final String ID = "com.clustercontrol.monitor.view.action.EventConfirmAction";
    private IViewPart viewPart;

    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    public void run(IAction action) {
        ArrayList<EventDataInfo> eventInfoList;
        EventView view = (EventView)((Object)this.viewPart.getAdapter(EventView.class));
        EventListComposite composite = (EventListComposite)view.getListComposite();
        StructuredSelection selection = (StructuredSelection)composite.getTableViewer().getSelection();
        List list = selection.toList();
        if (list != null && (eventInfoList = ConvertListUtil.listToEventLogDataList(list)) != null && eventInfoList.size() > 0) {
            try {
                MonitorEndpointWrapper.modifyConfirm(eventInfoList, 1);
                view.update();
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (MonitorNotFound_Exception e) {
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"mesasge.monitor.60")) + ", " + e.getMessage()));
            }
            catch (HinemosUnknown_Exception e) {
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"mesasge.monitor.60")) + ", " + e.getMessage()));
            }
            catch (Exception e) {
                m_log.warn((Object)("run(), " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

