/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.composite;

import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.dialog.StringValueInfoCreateDialog;
import com.clustercontrol.monitor.run.util.StringValueInfoManager;
import com.clustercontrol.monitor.run.viewer.StringValueListTableViewer;
import com.clustercontrol.ws.monitor.MonitorInfo;
import com.clustercontrol.ws.monitor.MonitorStringValueInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class StringValueListComposite
extends Composite {
    private StringValueListTableViewer m_tableViewer = null;
    private ArrayList m_tableDefine = null;

    public StringValueListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public StringValueListComposite(Composite parent, int style, ArrayList tableDefine) {
        super(parent, style);
        this.m_tableDefine = tableDefine;
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.m_tableViewer = new StringValueListTableViewer(table);
        this.m_tableViewer.createTableColumn(this.m_tableDefine);
        this.m_tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Shell shell;
                StringValueInfoCreateDialog dialog;
                MonitorStringValueInfo info = StringValueListComposite.this.getFilterItem();
                if (info != null && (dialog = new StringValueInfoCreateDialog(shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), info.getIdentifier())).open() == 0) {
                    dialog.getInputData();
                    Table table = StringValueListComposite.this.getTableViewer().getTable();
                    int selectIndex = table.getSelectionIndex();
                    StringValueInfoManager.getInstance().modify(dialog.getInputData());
                    table.setSelection(selectIndex);
                    StringValueListComposite.this.update();
                }
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
    }

    public StringValueListTableViewer getTableViewer() {
        return this.m_tableViewer;
    }

    public MonitorStringValueInfo getFilterItem() {
        StructuredSelection selection = (StructuredSelection)this.m_tableViewer.getSelection();
        if (selection == null) {
            return null;
        }
        return (MonitorStringValueInfo)selection.getFirstElement();
    }

    public void setInputData(MonitorInfo info) {
        if (info != null) {
            StringValueInfoManager.getInstance().initialize(info);
            Object[] list = StringValueInfoManager.getInstance().get();
            this.m_tableViewer.setInput(list);
        }
    }

    public void update() {
        Object[] list = StringValueInfoManager.getInstance().get();
        this.m_tableViewer.setInput(list);
    }

    public ValidateResult createInputData(MonitorInfo monitorInfo) {
        ArrayList list = StringValueInfoManager.getInstance().getMonitorStringValueInfo();
        if (list != null && list.size() > 0) {
            String MonitorTypeId = monitorInfo.getMonitorTypeId();
            String MonitorId = monitorInfo.getMonitorId();
            int index = 0;
            while (index < list.size()) {
                MonitorStringValueInfo info = (MonitorStringValueInfo)list.get(index);
                info.setMonitorTypeId(MonitorTypeId);
                info.setMonitorId(MonitorId);
                ++index;
            }
            List monitorStringValueInfoList = monitorInfo.getStringValueInfo();
            monitorStringValueInfoList.clear();
            monitorStringValueInfoList.addAll(list);
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.m_tableViewer.getTable().setEnabled(enabled);
    }

    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }
}

