/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.maintenance.view;

import com.clustercontrol.accesscontrol.util.ObjectBean;
import com.clustercontrol.bean.Property;
import com.clustercontrol.maintenance.composite.MaintenanceListComposite;
import com.clustercontrol.view.CommonViewPart;
import com.clustercontrol.view.ObjectPrivilegeTargetListView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class MaintenanceListView
extends CommonViewPart
implements ObjectPrivilegeTargetListView {
    public static final String ID = "com.clustercontrol.maintenance.view.MaintenanceListView";
    private MaintenanceListComposite composite = null;
    private Property condition = null;

    @Override
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite = new MaintenanceListComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.composite.setLayoutData(gridData);
        this.createContextMenu();
        this.composite.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewPart viewPart = page.findView(MaintenanceListView.ID);
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (viewPart != null && selection != null) {
                    MaintenanceListView view = (MaintenanceListView)viewPart.getAdapter(MaintenanceListView.class);
                    view.setEnabledAction(selection.size(), event.getSelection());
                }
            }
        });
        this.update();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MaintenanceListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.composite.getTable());
        this.composite.getTable().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem maintenanceAdd = (ActionContributionItem)toolbar.find("com.clustercontrol.maintenance.view.action.MaintenanceAddAction");
        ActionContributionItem maintenanceModify = (ActionContributionItem)toolbar.find("com.clustercontrol.maintenance.view.action.MaintenanceModifyAction");
        ActionContributionItem maintenanceDelete = (ActionContributionItem)toolbar.find("com.clustercontrol.maintenance.view.action.MaintenanceDeleteAction");
        ActionContributionItem maintenanceCopy = (ActionContributionItem)toolbar.find("com.clustercontrol.maintenance.view.action.MaintenanceCopyAction");
        ActionContributionItem maintenanceEnable = (ActionContributionItem)toolbar.find("com.clustercontrol.maintenance.view.action.MaintenanceEnableAction");
        ActionContributionItem maintenanceDisable = (ActionContributionItem)toolbar.find("com.clustercontrol.maintenance.view.action.MaintenanceDisableAction");
        manager.add(maintenanceAdd.getAction());
        manager.add(maintenanceModify.getAction());
        manager.add(maintenanceDelete.getAction());
        manager.add((IContributionItem)new Separator());
        manager.add(maintenanceCopy.getAction());
        manager.add((IContributionItem)new Separator());
        manager.add(maintenanceEnable.getAction());
        manager.add(maintenanceDisable.getAction());
    }

    public Composite getListComposite() {
        return this.composite;
    }

    public void update(Property condition) {
        this.condition = condition;
        this.update();
    }

    @Override
    public void update() {
        this.composite.update();
    }

    public void setEnabledAction(int num, ISelection selection) {
        super.setEnabledAction("com.clustercontrol.maintenance.view.action.MaintenanceCopyAction", selection);
        super.setEnabledAction("com.clustercontrol.maintenance.view.action.MaintenanceDeleteAction", selection);
        super.setEnabledAction("com.clustercontrol.maintenance.view.action.MaintenanceModifyAction", selection);
        super.setEnabledAction("com.clustercontrol.maintenance.view.action.MaintenanceEnableAction", selection);
        super.setEnabledAction("com.clustercontrol.maintenance.view.action.MaintenanceDisableAction", selection);
        if (num > 0) {
            super.setEnabledAction("com.clustercontrol.maintenance.view.action.MaintenanceEnableAction", true);
            super.setEnabledAction("com.clustercontrol.maintenance.view.action.MaintenanceDisableAction", true);
            if (num == 1) {
                super.setEnabledAction("com.clustercontrol.maintenance.view.action.MaintenanceCopyAction", true);
                super.setEnabledAction("com.clustercontrol.maintenance.view.action.MaintenanceDeleteAction", true);
                super.setEnabledAction("com.clustercontrol.maintenance.view.action.MaintenanceModifyAction", true);
            } else {
                super.setEnabledAction("com.clustercontrol.maintenance.view.action.MaintenanceCopyAction", false);
                super.setEnabledAction("com.clustercontrol.maintenance.view.action.MaintenanceDeleteAction", false);
                super.setEnabledAction("com.clustercontrol.maintenance.view.action.MaintenanceModifyAction", false);
            }
        } else {
            super.setEnabledAction("com.clustercontrol.maintenance.view.action.MaintenanceCopyAction", false);
            super.setEnabledAction("com.clustercontrol.maintenance.view.action.MaintenanceDeleteAction", false);
            super.setEnabledAction("com.clustercontrol.maintenance.view.action.MaintenanceModifyAction", false);
            super.setEnabledAction("com.clustercontrol.maintenance.view.action.MaintenanceEnableAction", false);
            super.setEnabledAction("com.clustercontrol.maintenance.view.action.MaintenanceDisableAction", false);
        }
    }

    public String getSelectedId() {
        StructuredSelection selection = (StructuredSelection)this.composite.getTableViewer().getSelection();
        List list = (List)selection.getFirstElement();
        String id = null;
        if (list != null) {
            id = (String)list.get(0);
        }
        return id;
    }

    @Override
    public List<ObjectBean> getSelectedObjectBeans() {
        StructuredSelection selection = (StructuredSelection)this.composite.getTableViewer().getSelection();
        Object[] objs = selection.toArray();
        String objectType = "MAINTENANCE";
        String objectId = null;
        ArrayList<ObjectBean> objectBeans = new ArrayList<ObjectBean>();
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            objectId = (String)((List)obj).get(0);
            ObjectBean objectBean = new ObjectBean(objectType, objectId);
            objectBeans.add(objectBean);
            ++n2;
        }
        return objectBeans;
    }

    @Override
    public String getSelectedOwnerRoleId() {
        StructuredSelection selection = (StructuredSelection)this.composite.getTableViewer().getSelection();
        List list = (List)selection.getFirstElement();
        String id = null;
        if (list != null) {
            id = (String)list.get(7);
        }
        return id;
    }
}

