/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.maintenance.composite;

import com.clustercontrol.maintenance.util.MaintenanceEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.maintenance.InvalidRole_Exception;
import com.clustercontrol.ws.maintenance.MaintenanceTypeMst;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MaintenanceTypeListComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(MaintenanceTypeListComposite.class);
    public static final int WIDTH_TITLE = 4;
    public static final int WIDTH_TEXT = 8;
    private Label labelMaintenanceType = null;
    private Combo comboMaintenanceType = null;
    List<MaintenanceTypeMst> maintenanceTypeList = null;

    public MaintenanceTypeListComposite(Composite parent, int style, boolean labelFlg) {
        super(parent, style);
        this.initialize(parent, labelFlg);
    }

    private void initialize(Composite parent, boolean labelFlg) {
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = labelFlg ? 15 : 10;
        this.setLayout((Layout)layout);
        if (labelFlg) {
            this.labelMaintenanceType = new Label((Composite)this, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 4;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.labelMaintenanceType.setLayoutData((Object)gridData);
            this.labelMaintenanceType.setText(String.valueOf(Messages.getString((String)"maintenance.type")) + " : ");
        }
        this.comboMaintenanceType = new Combo((Composite)this, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.comboMaintenanceType.setLayoutData((Object)gridData);
        this.update();
    }

    public void update() {
        if (this.maintenanceTypeList == null) {
            this.getMaintenanceTypeList();
        }
        for (MaintenanceTypeMst type : this.maintenanceTypeList) {
            this.comboMaintenanceType.add(Messages.getString((String)type.getNameId()));
        }
    }

    public int getSelectionIndex() {
        return this.comboMaintenanceType.getSelectionIndex();
    }

    public String getSelectionTypeId() {
        int index;
        String typeId = null;
        if (this.maintenanceTypeList == null) {
            this.getMaintenanceTypeList();
        }
        if ((index = this.getSelectionIndex()) >= 0) {
            MaintenanceTypeMst maintenanceType = this.maintenanceTypeList.get(index);
            typeId = maintenanceType.getTypeId();
        } else {
            typeId = "";
        }
        return typeId;
    }

    public String getMaintenanceTypeName(String type_id) {
        String name = null;
        if (this.maintenanceTypeList == null) {
            this.getMaintenanceTypeList();
        }
        for (MaintenanceTypeMst type : this.maintenanceTypeList) {
            if (!type.getTypeId().equals(type_id)) continue;
            name = Messages.getString((String)type.getNameId());
            break;
        }
        return name;
    }

    private void getMaintenanceTypeList() {
        try {
            this.maintenanceTypeList = MaintenanceEndpointWrapper.getMaintenanceTypeList();
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("getMaintenanceTypeList(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
    }

    public void setEnabled(boolean enabled) {
        this.comboMaintenanceType.setEnabled(enabled);
    }

    public String getText() {
        return this.comboMaintenanceType.getText();
    }

    public void setText(String string) {
        this.comboMaintenanceType.setText(string);
    }

    public void setBackground(Color color) {
        this.comboMaintenanceType.setBackground(color);
    }

    public void addModifyListener(ModifyListener listener) {
        this.comboMaintenanceType.addModifyListener(listener);
    }
}

