/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.maintenance.composite;

import com.clustercontrol.maintenance.action.GetMaintenanceListTableDefine;
import com.clustercontrol.maintenance.composite.action.MaintenanceDoubleClickListener;
import com.clustercontrol.maintenance.util.MaintenanceEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.maintenance.InvalidRole_Exception;
import com.clustercontrol.ws.maintenance.MaintenanceInfo;
import com.clustercontrol.ws.maintenance.MaintenanceTypeMst;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class MaintenanceListComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(MaintenanceListComposite.class);
    private CommonTableViewer tableViewer = null;

    public MaintenanceListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Table table = new Table((Composite)this, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetMaintenanceListTableDefine.get(), 0, 1);
        this.tableViewer.addDoubleClickListener(new MaintenanceDoubleClickListener(this));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    public void update() {
        List<MaintenanceInfo> maintenanceList = null;
        try {
            maintenanceList = MaintenanceEndpointWrapper.getMaintenanceList();
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("update() getMaintenanceList, " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        if (maintenanceList == null) {
            maintenanceList = new ArrayList<MaintenanceInfo>();
        }
        List<MaintenanceTypeMst> maintenanceTypeList = null;
        try {
            maintenanceTypeList = MaintenanceEndpointWrapper.getMaintenanceTypeList();
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("update() getMaintenanceTypeList, " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        if (maintenanceTypeList == null) {
            maintenanceTypeList = new ArrayList<MaintenanceTypeMst>();
        }
        HashMap<String, String> typeMessageMap = new HashMap<String, String>();
        for (MaintenanceTypeMst type : maintenanceTypeList) {
            typeMessageMap.put(type.getTypeId(), Messages.getString((String)type.getNameId()));
        }
        ArrayList listInput = new ArrayList();
        for (MaintenanceInfo maintenanceInfo : maintenanceList) {
            ArrayList<Object> a = new ArrayList<Object>();
            a.add(maintenanceInfo.getMaintenanceId());
            a.add(maintenanceInfo.getDescription());
            a.add(typeMessageMap.get(maintenanceInfo.getTypeId()));
            a.add(maintenanceInfo.getDataRetentionPeriod());
            a.add(maintenanceInfo.getCalendarId());
            a.add(maintenanceInfo.getSchedule());
            a.add(maintenanceInfo.getValidFlg());
            a.add(maintenanceInfo.getOwnerRoleId());
            a.add(maintenanceInfo.getRegUser());
            a.add(new Date(maintenanceInfo.getRegDate()));
            a.add(maintenanceInfo.getUpdateUser());
            a.add(new Date(maintenanceInfo.getUpdateDate()));
            listInput.add(a);
        }
        this.tableViewer.setInput(listInput);
    }

    public ArrayList<String> getSelectionData() {
        ArrayList<String> data = new ArrayList<String>();
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        List list = selection.toList();
        if (list != null) {
            int index = 0;
            while (index < list.size()) {
                ArrayList info = (ArrayList)list.get(index);
                if (info != null && info.size() > 0) {
                    String maintenanceId = (String)info.get(0);
                    data.add(maintenanceId);
                }
                ++index;
            }
        }
        return data;
    }
}

