/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.view;

import com.clustercontrol.accesscontrol.util.ObjectBean;
import com.clustercontrol.jobmanagement.composite.JobListComposite;
import com.clustercontrol.jobmanagement.composite.JobTreeComposite;
import com.clustercontrol.jobmanagement.composite.action.JobListSelectionChangedListener;
import com.clustercontrol.jobmanagement.composite.action.JobTreeSelectionChangedListener;
import com.clustercontrol.jobmanagement.util.JobEditStateUtil;
import com.clustercontrol.jobmanagement.view.action.CopyJobAction;
import com.clustercontrol.jobmanagement.view.action.PasteJobAction;
import com.clustercontrol.view.CommonViewPart;
import com.clustercontrol.view.ObjectPrivilegeTargetListView;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;

public class JobListView
extends CommonViewPart
implements ObjectPrivilegeTargetListView {
    private static Log m_log = LogFactory.getLog(JobListView.class);
    public static final String ID = "com.clustercontrol.jobmanagement.view.JobListView";
    private SashForm m_sash = null;
    private JobTreeComposite m_jobTree = null;
    private JobListComposite m_jobList = null;
    private JobTreeItem m_copyJobTreeItem = null;

    @Override
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_sash = new SashForm(parent, 256);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.m_sash.setLayoutData((Object)gridData);
        Long start = System.currentTimeMillis();
        this.m_jobTree = new JobTreeComposite(this, (Composite)this.m_sash, 0, null);
        this.m_jobList = new JobListComposite((Composite)this.m_sash, 0);
        this.m_sash.setWeights(new int[]{30, 70});
        this.m_jobTree.getTreeViewer().addSelectionChangedListener(new JobTreeSelectionChangedListener(this.m_jobTree, this.m_jobList));
        this.m_jobList.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)new JobListSelectionChangedListener(this.m_jobList));
        this.createContextMenu();
        Long end = System.currentTimeMillis();
        m_log.info((Object)("init() : " + (end - start) + "ms"));
        this.m_jobTree.addToTreeViewerList();
        this.m_jobTree.getTreeViewer().expandToLevel(2);
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JobListView.this.fillContextMenu(manager);
            }
        });
        Menu treeMenu = menuManager.createContextMenu((Control)this.m_jobTree.getTree());
        this.m_jobTree.getTree().setMenu(treeMenu);
        Menu listMenu = menuManager.createContextMenu((Control)this.m_jobList.getTable());
        this.m_jobList.getTable().setMenu(listMenu);
    }

    private void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem createJobUnitAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.CreateJobUnitAction");
        ActionContributionItem createJobNetAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.CreateJobNetAction");
        ActionContributionItem createJobAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.CreateJobAction");
        ActionContributionItem createFileJobAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.CreateFileJobAction");
        ActionContributionItem createReferJobAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.CreateReferJobAction");
        ActionContributionItem deleteJobAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.DeleteJobAction");
        ActionContributionItem modifyJobAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.ModifyJobAction");
        ActionContributionItem runJobAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.RunJobAction");
        ActionContributionItem editModeAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.EditModeAction");
        ActionContributionItem objPrivilege = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.JobObjectPrivilegeAction");
        manager.add(editModeAction.getAction());
        manager.add((IContributionItem)new Separator());
        CopyJobAction copyJobAction = new CopyJobAction((IViewPart)this);
        manager.add((IAction)copyJobAction);
        PasteJobAction pasteJobAction = new PasteJobAction((IViewPart)this);
        manager.add((IAction)pasteJobAction);
        manager.add((IContributionItem)new Separator());
        manager.add(createJobUnitAction.getAction());
        manager.add(createJobNetAction.getAction());
        manager.add(createJobAction.getAction());
        manager.add(createFileJobAction.getAction());
        manager.add(createReferJobAction.getAction());
        manager.add(modifyJobAction.getAction());
        manager.add(deleteJobAction.getAction());
        manager.add(runJobAction.getAction());
        manager.add((IContributionItem)new Separator());
        manager.add(objPrivilege.getAction());
        JobTreeItem select = this.getSelectJobTreeItem();
        if (select instanceof JobTreeItem) {
            if (select.getData().getType() == -1) {
                copyJobAction.setEnabled(false);
            } else {
                copyJobAction.setEnabled(true);
            }
            if (this.m_copyJobTreeItem != null && this.m_copyJobTreeItem instanceof JobTreeItem) {
                if (select.getData().getType() == -1) {
                    pasteJobAction.setEnabled(true);
                } else if (JobEditStateUtil.isLockedJobunitId(select.getData().getJobunitId())) {
                    if (select.getData().getType() == 0) {
                        pasteJobAction.setEnabled(true);
                    } else if (select.getData().getType() == 1) {
                        pasteJobAction.setEnabled(true);
                    } else {
                        pasteJobAction.setEnabled(false);
                    }
                } else {
                    pasteJobAction.setEnabled(false);
                }
            } else {
                pasteJobAction.setEnabled(false);
            }
        } else {
            pasteJobAction.setEnabled(false);
            copyJobAction.setEnabled(false);
        }
    }

    @Override
    public void update() {
        Long start = System.currentTimeMillis();
        JobEditStateUtil.clearEditStateAll();
        this.m_jobTree.update();
        JobTreeItem item = this.getJobTreeComposite().getSelectItem();
        this.m_jobList.update(item);
        Long end = System.currentTimeMillis();
        m_log.info((Object)("update () : " + (end - start) + "ms"));
    }

    public void update(String jobId) {
        JobEditStateUtil.clearEditStateAll();
        this.m_jobTree.update(jobId);
        JobTreeItem item = this.getJobTreeComposite().getSelectItem();
        this.m_jobList.update(item);
    }

    public void setEnabledAction(int type, ISelection selection) {
        this.setEnabledAction(type, "", selection);
    }

    public void setEnabledAction(int type, String jobunitId, ISelection selection) {
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobUnitAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobNetAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateFileJobAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateReferJobAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DeleteJobAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.ModifyJobAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.JobObjectPrivilegeAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.RunJobAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.EditModeAction", selection);
        boolean enable = JobEditStateUtil.isLockedJobunitId(jobunitId);
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem editModeAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.EditModeAction");
        editModeAction.getAction().setChecked(enable);
        if (type == -1) {
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobUnitAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobNetAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateFileJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateReferJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DeleteJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.ModifyJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.JobObjectPrivilegeAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.RunJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.EditModeAction", false);
        } else if (type == 0) {
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobUnitAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobNetAction", enable);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobAction", enable);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateFileJobAction", enable);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateReferJobAction", enable);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DeleteJobAction", enable);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.ModifyJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.JobObjectPrivilegeAction", !enable);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.RunJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.EditModeAction", true);
        } else if (type == 1) {
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobUnitAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobNetAction", enable);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobAction", enable);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateFileJobAction", enable);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateReferJobAction", enable);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DeleteJobAction", enable);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.ModifyJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.JobObjectPrivilegeAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.RunJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.EditModeAction", true);
        } else if (type == 2) {
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobUnitAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobNetAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateFileJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateReferJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DeleteJobAction", enable);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.ModifyJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.JobObjectPrivilegeAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.RunJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.EditModeAction", true);
        } else if (type == 3) {
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobUnitAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobNetAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateFileJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateReferJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DeleteJobAction", enable);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.ModifyJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.JobObjectPrivilegeAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.RunJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.EditModeAction", true);
        } else if (type == 5) {
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobUnitAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobNetAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateFileJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateReferJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DeleteJobAction", enable);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.ModifyJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.JobObjectPrivilegeAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.RunJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.EditModeAction", true);
        } else {
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobUnitAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobNetAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateFileJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CreateReferJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DeleteJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.ModifyJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.JobObjectPrivilegeAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.RunJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.EditModeAction", false);
        }
    }

    public JobTreeComposite getJobTreeComposite() {
        return this.m_jobTree;
    }

    public JobListComposite getJobListComposite() {
        return this.m_jobList;
    }

    public void show() {
        this.m_sash.setMaximizedControl(null);
    }

    public void hide() {
        this.m_sash.setMaximizedControl((Control)this.m_jobList);
    }

    public JobTreeItem getSelectJobTreeItem() {
        JobTreeItem select = null;
        if (this.m_jobTree.getTree().isFocusControl()) {
            select = this.m_jobTree.getSelectItem();
        } else if (this.m_jobList.getTable().isFocusControl()) {
            select = this.m_jobList.getSelectJobTreeItem();
        }
        return select;
    }

    public JobTreeItem getCopyJobTreeItem() {
        return this.m_copyJobTreeItem;
    }

    public void setCopyJobTreeItem(JobTreeItem copy) {
        this.m_copyJobTreeItem = copy;
    }

    public void dispose() {
        this.m_jobTree.removeFromTreeViewerList();
        super.dispose();
    }

    @Override
    public List<ObjectBean> getSelectedObjectBeans() {
        JobTreeItem item = this.getSelectedJobunitItem();
        ArrayList<ObjectBean> objectBeans = new ArrayList<ObjectBean>();
        if (item != null) {
            String objectId = item.getData().getJobunitId();
            String objectType = "JOB";
            ObjectBean objectBean = new ObjectBean(objectType, objectId);
            objectBeans.add(objectBean);
        }
        return objectBeans;
    }

    @Override
    public String getSelectedOwnerRoleId() {
        JobTreeItem item = this.getSelectedJobunitItem();
        String ownerRoleId = null;
        if (item != null) {
            ownerRoleId = item.getData().getOwnerRoleId();
        }
        return ownerRoleId;
    }

    private JobTreeItem getSelectedJobunitItem() {
        JobTreeComposite tree = this.getJobTreeComposite();
        JobListComposite list = this.getJobListComposite();
        JobTreeItem item = null;
        if (tree.getTree().isFocusControl()) {
            item = tree.getSelectItem();
        } else if (list.getTableViewer().getTable().isFocusControl()) {
            item = list.getSelectItem();
        }
        if (item != null && item.getData().getType() == 0) {
            return item;
        }
        return null;
    }
}

