/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.view;

import com.clustercontrol.accesscontrol.util.ObjectBean;
import com.clustercontrol.jobmanagement.bean.JobTriggerTypeConstant;
import com.clustercontrol.jobmanagement.composite.JobKickListComposite;
import com.clustercontrol.view.CommonViewPart;
import com.clustercontrol.view.ObjectPrivilegeTargetListView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class JobKickListView
extends CommonViewPart
implements ObjectPrivilegeTargetListView {
    public static final String ID = "com.clustercontrol.jobmanagement.view.JobKickListView";
    private JobKickListComposite m_jobKickList = null;

    @Override
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_jobKickList = new JobKickListComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.m_jobKickList.setLayoutData(gridData);
        this.createContextMenu();
        this.update();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JobKickListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.m_jobKickList.getTable());
        this.m_jobKickList.getTable().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem createFileCheckAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.CreateFileCheckAction");
        ActionContributionItem createScheduleAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.CreateScheduleAction");
        ActionContributionItem modifyScheduleAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.ModifyJobKickAction");
        ActionContributionItem deleteScheduleAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.DeleteJobKickAction");
        ActionContributionItem copyJobKickAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.CopyJobKickAction");
        ActionContributionItem enableJobKickAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.EnableScheduleAction");
        ActionContributionItem disableJobKickAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.DisableScheduleAction");
        ActionContributionItem objPrivilege = (ActionContributionItem)toolbar.find("com.clustercontrol.view.action.ObjectPrivilegeAction");
        manager.add(createFileCheckAction.getAction());
        manager.add(createScheduleAction.getAction());
        manager.add(modifyScheduleAction.getAction());
        manager.add(deleteScheduleAction.getAction());
        manager.add(copyJobKickAction.getAction());
        manager.add(enableJobKickAction.getAction());
        manager.add(disableJobKickAction.getAction());
        manager.add((IContributionItem)new Separator());
        manager.add(objPrivilege.getAction());
    }

    @Override
    public void update() {
        this.m_jobKickList.update();
    }

    public JobKickListComposite getComposite() {
        return this.m_jobKickList;
    }

    public void setEnabledAction(int num, ISelection selection) {
        super.setEnabledAction("com.clustercontrol.view.action.ObjectPrivilegeAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.ModifyJobKickAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DeleteJobKickAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.EnableScheduleAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DisableScheduleAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CopyJobKickAction", selection);
        if (num > 0) {
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.EnableScheduleAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DisableScheduleAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CopyJobKickAction", true);
            super.setEnabledAction("com.clustercontrol.view.action.ObjectPrivilegeAction", true);
            if (num == 1) {
                super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.ModifyJobKickAction", true);
                super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DeleteJobKickAction", true);
                super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CopyJobKickAction", true);
            } else {
                super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.ModifyJobKickAction", false);
                super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DeleteJobKickAction", false);
                super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CopyJobKickAction", false);
            }
        } else {
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.EnableScheduleAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DisableScheduleAction", false);
            super.setEnabledAction("com.clustercontrol.view.action.ObjectPrivilegeAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.ModifyJobKickAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.DeleteJobKickAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.CopyJobKickAction", false);
        }
    }

    public String getSelectedId() {
        StructuredSelection selection = (StructuredSelection)this.m_jobKickList.getTableViewer().getSelection();
        List list = (List)selection.getFirstElement();
        String id = null;
        if (list != null) {
            id = (String)list.get(1);
        }
        return id;
    }

    @Override
    public List<ObjectBean> getSelectedObjectBeans() {
        StructuredSelection selection = (StructuredSelection)this.m_jobKickList.getTableViewer().getSelection();
        Object[] objs = selection.toArray();
        String objectType = null;
        String objectId = null;
        ArrayList<ObjectBean> objectBeans = new ArrayList<ObjectBean>();
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            objectId = (String)((List)obj).get(1);
            String type = (String)((List)obj).get(0);
            int TypeNum = JobTriggerTypeConstant.stringToType((String)type);
            if (TypeNum == 1) {
                objectType = "JOB_SCH";
            } else if (TypeNum == 4) {
                objectType = "JOB_FCH";
            }
            ObjectBean objectBean = new ObjectBean(objectType, objectId);
            objectBeans.add(objectBean);
            ++n2;
        }
        return objectBeans;
    }

    @Override
    public String getSelectedOwnerRoleId() {
        StructuredSelection selection = (StructuredSelection)this.m_jobKickList.getTableViewer().getSelection();
        List list = (List)selection.getFirstElement();
        String id = null;
        if (list != null) {
            id = (String)list.get(8);
        }
        return id;
    }
}

