/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.util;

import com.clustercontrol.ws.jobmanagement.JobCommandInfo;
import com.clustercontrol.ws.jobmanagement.JobDetailInfo;
import com.clustercontrol.ws.jobmanagement.JobEndStatusInfo;
import com.clustercontrol.ws.jobmanagement.JobFileInfo;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import com.clustercontrol.ws.jobmanagement.JobNotificationsInfo;
import com.clustercontrol.ws.jobmanagement.JobObjectInfo;
import com.clustercontrol.ws.jobmanagement.JobParameterInfo;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.clustercontrol.ws.jobmanagement.JobWaitRuleInfo;
import com.clustercontrol.ws.notify.NotifyRelationInfo;
import java.util.List;

public class JobTreeItemUtil {
    public static final String SEPARATOR = ">";

    public static String getPath(JobTreeItem jobTreeItem) {
        if (jobTreeItem.getData().getType() == -1) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(jobTreeItem.getData().getName());
        JobTreeItem parent = jobTreeItem.getParent();
        while (parent != null && parent.getData().getType() != -1) {
            buffer.insert(0, SEPARATOR);
            buffer.insert(0, parent.getData().getName());
            parent = parent.getParent();
        }
        return buffer.toString();
    }

    public static JobInfo getNewJobInfo(String jobunitId, int type) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setJobunitId(jobunitId);
        jobInfo.setId("");
        jobInfo.setName("");
        jobInfo.setType(Integer.valueOf(type));
        jobInfo.setWaitRule(JobTreeItemUtil.getNewJobWaitRuleInfo());
        return jobInfo;
    }

    public static JobWaitRuleInfo getNewJobWaitRuleInfo() {
        JobWaitRuleInfo jobWaitRuleInfo = new JobWaitRuleInfo();
        jobWaitRuleInfo.setCondition(Integer.valueOf(0));
        jobWaitRuleInfo.setEndCondition(Integer.valueOf(1));
        jobWaitRuleInfo.setEndStatus(Integer.valueOf(2));
        jobWaitRuleInfo.setEndValue(Integer.valueOf(-1));
        jobWaitRuleInfo.setCalendar(Integer.valueOf(0));
        jobWaitRuleInfo.setCalendarEndStatus(Integer.valueOf(2));
        jobWaitRuleInfo.setCalendarEndValue(Integer.valueOf(0));
        jobWaitRuleInfo.setSuspend(Integer.valueOf(0));
        jobWaitRuleInfo.setSkip(Integer.valueOf(0));
        jobWaitRuleInfo.setSkipEndStatus(Integer.valueOf(2));
        jobWaitRuleInfo.setSkipEndValue(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelay(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelayConditionType(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelayNotify(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelayNotifyPriority(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelayOperationType(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelayOperation(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelayOperationEndStatus(Integer.valueOf(2));
        jobWaitRuleInfo.setStartDelayOperationEndValue(Integer.valueOf(-1));
        jobWaitRuleInfo.setStartDelaySession(Integer.valueOf(0));
        jobWaitRuleInfo.setStartDelaySessionValue(Integer.valueOf(1));
        jobWaitRuleInfo.setStartDelayTime(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelay(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelayConditionType(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelayJob(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelayJobValue(Integer.valueOf(1));
        jobWaitRuleInfo.setEndDelayNotify(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelayNotifyPriority(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelayOperation(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelayOperationEndStatus(Integer.valueOf(2));
        jobWaitRuleInfo.setEndDelayOperationEndValue(Integer.valueOf(-1));
        jobWaitRuleInfo.setEndDelayOperationType(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelaySession(Integer.valueOf(0));
        jobWaitRuleInfo.setEndDelaySessionValue(Integer.valueOf(1));
        jobWaitRuleInfo.setEndDelayTime(Integer.valueOf(0));
        jobWaitRuleInfo.setMultiplicityEndValue(Integer.valueOf(-1));
        jobWaitRuleInfo.setMultiplicityNotify(Integer.valueOf(1));
        jobWaitRuleInfo.setMultiplicityNotifyPriority(Integer.valueOf(2));
        jobWaitRuleInfo.setMultiplicityOperation(Integer.valueOf(0));
        return jobWaitRuleInfo;
    }

    public static JobTreeItem clone(JobTreeItem origItem, JobTreeItem parentItem) {
        List listOrig;
        JobTreeItem cloneItem = new JobTreeItem();
        if (origItem.getData() != null) {
            JobInfo jobInfo = new JobInfo();
            JobInfo orgInfo = origItem.getData();
            if (orgInfo.getCreateTime() != null) {
                jobInfo.setCreateTime(orgInfo.getCreateTime());
            }
            jobInfo.setCreateUser(orgInfo.getCreateUser());
            jobInfo.setDescription(orgInfo.getDescription());
            jobInfo.setOwnerRoleId(orgInfo.getOwnerRoleId());
            jobInfo.setId(orgInfo.getId());
            jobInfo.setJobunitId(orgInfo.getJobunitId());
            jobInfo.setName(orgInfo.getName());
            jobInfo.setPropertyFull(orgInfo.isPropertyFull());
            jobInfo.setType(orgInfo.getType());
            if (orgInfo.getUpdateTime() != null) {
                jobInfo.setUpdateTime(orgInfo.getUpdateTime());
            }
            jobInfo.setUpdateUser(orgInfo.getUpdateUser());
            if (orgInfo.getCommand() != null) {
                JobCommandInfo jobCommandInfo = new JobCommandInfo();
                jobCommandInfo.setErrorEndFlg(orgInfo.getCommand().getErrorEndFlg());
                jobCommandInfo.setErrorEndValue(orgInfo.getCommand().getErrorEndValue());
                jobCommandInfo.setFacilityID(orgInfo.getCommand().getFacilityID());
                jobCommandInfo.setProcessingMethod(orgInfo.getCommand().getProcessingMethod());
                jobCommandInfo.setScope(orgInfo.getCommand().getScope());
                jobCommandInfo.setStartCommand(orgInfo.getCommand().getStartCommand());
                jobCommandInfo.setStopCommand(orgInfo.getCommand().getStopCommand());
                jobCommandInfo.setStopType(orgInfo.getCommand().getStopType());
                jobCommandInfo.setSpecifyUser(orgInfo.getCommand().getSpecifyUser());
                jobCommandInfo.setUser(orgInfo.getCommand().getUser());
                jobCommandInfo.setMessageRetry(orgInfo.getCommand().getMessageRetry());
                jobInfo.setCommand(jobCommandInfo);
            }
            if (orgInfo.getEndStatus() != null) {
                for (JobEndStatusInfo item : orgInfo.getEndStatus()) {
                    JobEndStatusInfo jobEndStatusInfo = new JobEndStatusInfo();
                    jobEndStatusInfo.setEndRangeValue(item.getEndRangeValue());
                    jobEndStatusInfo.setStartRangeValue(item.getStartRangeValue());
                    jobEndStatusInfo.setType(item.getType());
                    jobEndStatusInfo.setValue(item.getValue());
                    jobInfo.getEndStatus().add(jobEndStatusInfo);
                }
            }
            if (orgInfo.getFile() != null) {
                JobFileInfo jobFileInfo = new JobFileInfo();
                jobFileInfo.setCheckFlg(orgInfo.getFile().getCheckFlg());
                jobFileInfo.setCompressionFlg(orgInfo.getFile().getCompressionFlg());
                jobFileInfo.setDestDirectory(orgInfo.getFile().getDestDirectory());
                jobFileInfo.setDestFacilityID(orgInfo.getFile().getDestFacilityID());
                jobFileInfo.setDestScope(orgInfo.getFile().getDestScope());
                jobFileInfo.setDestWorkDir(orgInfo.getFile().getDestWorkDir());
                jobFileInfo.setProcessingMethod(orgInfo.getFile().getProcessingMethod());
                jobFileInfo.setSrcFacilityID(orgInfo.getFile().getSrcFacilityID());
                jobFileInfo.setSrcFile(orgInfo.getFile().getSrcFile());
                jobFileInfo.setSrcScope(orgInfo.getFile().getSrcScope());
                jobFileInfo.setSrcWorkDir(orgInfo.getFile().getSrcWorkDir());
                jobFileInfo.setUser(orgInfo.getFile().getUser());
                jobFileInfo.setSpecifyUser(orgInfo.getFile().getSpecifyUser());
                jobFileInfo.setMessageRetry(orgInfo.getFile().getMessageRetry());
                jobInfo.setFile(jobFileInfo);
            }
            if (orgInfo.getNotifications() != null) {
                for (JobEndStatusInfo item : orgInfo.getNotifications()) {
                    JobNotificationsInfo jobNotificationsInfo = new JobNotificationsInfo();
                    jobNotificationsInfo.setNotifyGroupId(item.getNotifyGroupId());
                    jobNotificationsInfo.setPriority(item.getPriority());
                    jobNotificationsInfo.setType(item.getType());
                    if (item.getNotifyId() != null) {
                        for (NotifyRelationInfo subitem : item.getNotifyId()) {
                            NotifyRelationInfo notifyRelationInfo = new NotifyRelationInfo();
                            if (subitem.getNotifyFlg() != null) {
                                notifyRelationInfo.setNotifyFlg(subitem.getNotifyFlg());
                            }
                            notifyRelationInfo.setNotifyGroupId(subitem.getNotifyGroupId());
                            notifyRelationInfo.setNotifyId(subitem.getNotifyId());
                            if (subitem.getNotifyType() != null) {
                                notifyRelationInfo.setNotifyType(subitem.getNotifyType());
                            }
                            jobNotificationsInfo.getNotifyId().add(notifyRelationInfo);
                        }
                    }
                    jobInfo.getNotifications().add(jobNotificationsInfo);
                }
            }
            if (orgInfo.getParam() != null) {
                for (JobEndStatusInfo item : orgInfo.getParam()) {
                    JobParameterInfo jobParameterInfo = new JobParameterInfo();
                    jobParameterInfo.setDescription(item.getDescription());
                    jobParameterInfo.setParamId(item.getParamId());
                    jobParameterInfo.setType(item.getType());
                    jobParameterInfo.setValue(item.getValue());
                    jobInfo.getParam().add(jobParameterInfo);
                }
            }
            if (orgInfo.getWaitRule() != null) {
                JobWaitRuleInfo jobWaitRuleInfo = new JobWaitRuleInfo();
                jobWaitRuleInfo.setCalendar(orgInfo.getWaitRule().getCalendar());
                jobWaitRuleInfo.setCalendarEndStatus(orgInfo.getWaitRule().getCalendarEndStatus());
                jobWaitRuleInfo.setCalendarEndValue(orgInfo.getWaitRule().getCalendarEndValue());
                jobWaitRuleInfo.setCalendarId(orgInfo.getWaitRule().getCalendarId());
                jobWaitRuleInfo.setCondition(orgInfo.getWaitRule().getCondition());
                jobWaitRuleInfo.setEndCondition(orgInfo.getWaitRule().getEndCondition());
                jobWaitRuleInfo.setEndStatus(orgInfo.getWaitRule().getEndStatus());
                jobWaitRuleInfo.setEndValue(orgInfo.getWaitRule().getEndValue());
                jobWaitRuleInfo.setEndDelay(orgInfo.getWaitRule().getEndDelay());
                jobWaitRuleInfo.setEndDelayConditionType(orgInfo.getWaitRule().getEndDelayConditionType());
                jobWaitRuleInfo.setEndDelayJob(orgInfo.getWaitRule().getEndDelayJob());
                jobWaitRuleInfo.setEndDelayJobValue(orgInfo.getWaitRule().getEndDelayJobValue());
                jobWaitRuleInfo.setEndDelayNotify(orgInfo.getWaitRule().getEndDelayNotify());
                jobWaitRuleInfo.setEndDelayNotifyPriority(orgInfo.getWaitRule().getEndDelayNotifyPriority());
                jobWaitRuleInfo.setEndDelayOperation(orgInfo.getWaitRule().getEndDelayOperation());
                jobWaitRuleInfo.setEndDelayOperationEndStatus(orgInfo.getWaitRule().getEndDelayOperationEndStatus());
                jobWaitRuleInfo.setEndDelayOperationEndValue(orgInfo.getWaitRule().getEndDelayOperationEndValue());
                jobWaitRuleInfo.setEndDelayOperationType(orgInfo.getWaitRule().getEndDelayOperationType());
                jobWaitRuleInfo.setEndDelaySession(orgInfo.getWaitRule().getEndDelaySession());
                jobWaitRuleInfo.setEndDelaySessionValue(orgInfo.getWaitRule().getEndDelaySessionValue());
                jobWaitRuleInfo.setEndDelayTime(orgInfo.getWaitRule().getEndDelayTime());
                if (orgInfo.getWaitRule().getEndDelayTimeValue() != null) {
                    jobWaitRuleInfo.setEndDelayTimeValue(orgInfo.getWaitRule().getEndDelayTimeValue());
                }
                jobWaitRuleInfo.setMultiplicityNotify(orgInfo.getWaitRule().getMultiplicityNotify());
                jobWaitRuleInfo.setMultiplicityNotifyPriority(orgInfo.getWaitRule().getMultiplicityNotifyPriority());
                jobWaitRuleInfo.setMultiplicityOperation(orgInfo.getWaitRule().getMultiplicityOperation());
                jobWaitRuleInfo.setMultiplicityEndValue(orgInfo.getWaitRule().getMultiplicityEndValue());
                jobWaitRuleInfo.setSkip(orgInfo.getWaitRule().getSkip());
                jobWaitRuleInfo.setSkipEndStatus(orgInfo.getWaitRule().getSkipEndStatus());
                jobWaitRuleInfo.setSkipEndValue(orgInfo.getWaitRule().getSkipEndValue());
                jobWaitRuleInfo.setStartDelay(orgInfo.getWaitRule().getStartDelay());
                jobWaitRuleInfo.setStartDelayConditionType(orgInfo.getWaitRule().getStartDelayConditionType());
                jobWaitRuleInfo.setStartDelayNotify(orgInfo.getWaitRule().getStartDelayNotify());
                jobWaitRuleInfo.setStartDelayNotifyPriority(orgInfo.getWaitRule().getStartDelayNotifyPriority());
                jobWaitRuleInfo.setStartDelayOperation(orgInfo.getWaitRule().getStartDelayOperation());
                jobWaitRuleInfo.setStartDelayOperationEndStatus(orgInfo.getWaitRule().getStartDelayOperationEndStatus());
                jobWaitRuleInfo.setStartDelayOperationEndValue(orgInfo.getWaitRule().getStartDelayOperationEndValue());
                jobWaitRuleInfo.setStartDelayOperationType(orgInfo.getWaitRule().getStartDelayOperationType());
                jobWaitRuleInfo.setStartDelaySession(orgInfo.getWaitRule().getStartDelaySession());
                jobWaitRuleInfo.setStartDelaySessionValue(orgInfo.getWaitRule().getStartDelaySessionValue());
                jobWaitRuleInfo.setStartDelayTime(orgInfo.getWaitRule().getStartDelayTime());
                if (orgInfo.getWaitRule().getStartDelayTimeValue() != null) {
                    jobWaitRuleInfo.setStartDelayTimeValue(orgInfo.getWaitRule().getStartDelayTimeValue());
                }
                jobWaitRuleInfo.setSuspend(orgInfo.getWaitRule().getSuspend());
                if (orgInfo.getWaitRule().getObject() != null) {
                    for (JobObjectInfo item : orgInfo.getWaitRule().getObject()) {
                        JobObjectInfo jobObjectInfo = new JobObjectInfo();
                        jobObjectInfo.setJobId(item.getJobId());
                        jobObjectInfo.setJobName(item.getJobName());
                        if (item.getTime() != null) {
                            jobObjectInfo.setTime(item.getTime());
                        }
                        jobObjectInfo.setType(item.getType());
                        jobObjectInfo.setValue(item.getValue());
                        jobWaitRuleInfo.getObject().add(jobObjectInfo);
                    }
                }
                jobInfo.setWaitRule(jobWaitRuleInfo);
            }
            if (orgInfo.getReferJobUnitId() != null) {
                jobInfo.setReferJobUnitId(orgInfo.getReferJobUnitId());
            }
            if (orgInfo.getReferJobId() != null) {
                jobInfo.setReferJobId(orgInfo.getReferJobId());
            }
            cloneItem.setData(jobInfo);
        }
        if (origItem.getDetail() != null) {
            JobDetailInfo jobDetailInfo = new JobDetailInfo();
            if (origItem.getDetail().getEndDate() != null) {
                jobDetailInfo.setEndDate(origItem.getDetail().getEndDate());
            }
            if (origItem.getDetail().getEndStatus() != null) {
                jobDetailInfo.setEndStatus(origItem.getDetail().getEndStatus());
            }
            if (origItem.getDetail().getEndValue() != null) {
                jobDetailInfo.setEndValue(origItem.getDetail().getEndValue());
            }
            jobDetailInfo.setFacilityId(origItem.getDetail().getFacilityId());
            jobDetailInfo.setScope(origItem.getDetail().getScope());
            if (origItem.getDetail().getStartDate() != null) {
                jobDetailInfo.setStartDate(origItem.getDetail().getStartDate());
            }
            if (origItem.getDetail().getStatus() != null) {
                jobDetailInfo.setStatus(origItem.getDetail().getStatus());
            }
            if (origItem.getDetail().getWaitRuleTime() != null) {
                jobDetailInfo.setWaitRuleTime(origItem.getDetail().getWaitRuleTime());
            }
            cloneItem.setDetail(jobDetailInfo);
        }
        if ((listOrig = origItem.getChildren()) != null) {
            for (JobTreeItem orgChild : listOrig) {
                if (orgChild == null) continue;
                cloneItem.getChildren().add(JobTreeItemUtil.clone(orgChild, cloneItem));
            }
        }
        cloneItem.setParent(parentItem);
        return cloneItem;
    }

    public static void addChildren(JobTreeItem parent, JobTreeItem child) {
        parent.getChildren().add(child);
        child.setParent(parent);
    }

    public static void removeChildren(JobTreeItem parent, JobTreeItem child) {
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (child.equals(children.get(i))) {
                children.remove(i);
                break;
            }
            ++i;
        }
    }
}

