/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.util;

import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;

public class JobEditStateUtil {
    private static Log m_log = LogFactory.getLog(JobEditStateUtil.class);
    private static ArrayList<JobTreeItem> editedJobunitList = new ArrayList();
    private static ArrayList<JobTreeItem> deletedJobunitList = new ArrayList();
    private static ConcurrentHashMap<JobInfo, JobTreeItem> lockedJobunitMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<JobInfo, Integer> editSessionMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Long> jobunitUpdateTimeMap = new ConcurrentHashMap();
    private static JobTreeItem m_jobTreeItem = null;

    public static void addEditedJobunit(JobTreeItem jobunit) {
        if (jobunit.getData().getType() == -1) {
            m_log.warn((Object)"addEditJobunit() : jobunit is TOP");
            return;
        }
        if (jobunit.getData().getType() == 0) {
            if (!editedJobunitList.contains(jobunit)) {
                m_log.debug((Object)("addEditJobunit() : add " + jobunit.getData().getJobunitId()));
                editedJobunitList.add(jobunit);
            }
        } else {
            JobEditStateUtil.addEditedJobunit(jobunit.getParent());
        }
    }

    public static ArrayList<JobTreeItem> getEditedJobunitList() {
        return editedJobunitList;
    }

    public static void removeEditedJobunit(JobTreeItem jobunit) {
        editedJobunitList.remove(jobunit);
    }

    public static void addDeletedJobunit(JobTreeItem jobunit) {
        deletedJobunitList.add(jobunit);
    }

    public static ArrayList<JobTreeItem> getDeletedJobunitList() {
        return deletedJobunitList;
    }

    public static boolean isEdit() {
        m_log.debug((Object)("isEdit() : lockedJobunitList.size()=" + lockedJobunitMap.size()));
        boolean edit = true;
        if (lockedJobunitMap.size() == 0) {
            edit = false;
        }
        return edit;
    }

    public static ArrayList<JobInfo> getLockedJobunitList() {
        ArrayList<JobInfo> list = new ArrayList<JobInfo>();
        for (JobInfo info : editSessionMap.keySet()) {
            m_log.debug((Object)("list add " + info.getJobunitId()));
            list.add(info);
        }
        return list;
    }

    public static JobTreeItem getLockedJobunitBackup(JobInfo info) {
        return lockedJobunitMap.get(info);
    }

    public static void removeLockedJobunit(JobInfo info) {
        lockedJobunitMap.remove(info);
        editSessionMap.remove(info);
    }

    public static void addLockedJobunit(JobInfo info, JobTreeItem item, Integer editSession) {
        editSessionMap.put(info, editSession);
        if (item != null) {
            lockedJobunitMap.put(info, item);
        }
    }

    public static boolean isLockedJobunitId(String jobunitId) {
        boolean ret = false;
        for (JobInfo info : editSessionMap.keySet()) {
            if (!jobunitId.equals(info.getJobunitId())) continue;
            ret = true;
        }
        return ret;
    }

    public static Integer getEditSession(JobInfo info) {
        return editSessionMap.get(info);
    }

    public static void clearEditStateAll() {
        m_log.debug((Object)"clearEditStateAll()");
        editedJobunitList.clear();
        deletedJobunitList.clear();
        lockedJobunitMap.clear();
        editSessionMap.clear();
        jobunitUpdateTimeMap.clear();
        m_jobTreeItem = null;
    }

    public static void exitEditMode(JobTreeItem item) {
        editedJobunitList.remove(item);
        deletedJobunitList.remove(item);
        JobEditStateUtil.removeLockedJobunit(item.getData());
    }

    public static Long getJobunitUpdateTime(String jobunitId) {
        return jobunitUpdateTimeMap.get(jobunitId);
    }

    public static void putJobunitUpdateTime(String jobunitId, Long updateTime) {
        jobunitUpdateTimeMap.put(jobunitId, updateTime);
    }

    public static void removeJobunitUpdateTime(String jobunitId) {
        jobunitUpdateTimeMap.remove(jobunitId);
    }

    public static JobTreeItem getJobTreeItem() {
        return m_jobTreeItem;
    }

    public static JobTreeItem updateJobTree(String ownerRoleId, boolean m_treeOnly) {
        try {
            m_jobTreeItem = JobEndpointWrapper.getJobTree(ownerRoleId, m_treeOnly);
            JobEditStateUtil.updateJobunitUpdateTime();
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("update() getJobTree, " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        return m_jobTreeItem;
    }

    private static void updateJobunitUpdateTime() {
        try {
            for (JobTreeItem jobunit : ((JobTreeItem)m_jobTreeItem.getChildren().get(0)).getChildren()) {
                String jobunitId = jobunit.getData().getJobunitId();
                Long updateTime = JobEndpointWrapper.getUpdateTime(jobunitId);
                if (updateTime == null) continue;
                JobEditStateUtil.putJobunitUpdateTime(jobunitId, updateTime);
            }
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("updateJobunitUpdateTime() : " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
    }

    public static void clearPropertyFull(String jobunitId) {
        for (JobTreeItem jobunitItem : ((JobTreeItem)m_jobTreeItem.getChildren().get(0)).getChildren()) {
            if (!jobunitItem.getData().getJobunitId().equals(jobunitId)) continue;
            jobunitItem.getData().setPropertyFull(false);
            for (JobTreeItem item : jobunitItem.getChildren()) {
                item.getData().setPropertyFull(false);
                JobEditStateUtil.clearPropertyFullRecursive(item);
            }
        }
    }

    private static void clearPropertyFullRecursive(JobTreeItem parentItem) {
        for (JobTreeItem item : parentItem.getChildren()) {
            item.getData().setPropertyFull(false);
            JobEditStateUtil.clearPropertyFullRecursive(item);
        }
    }
}

