/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite.action;

import com.clustercontrol.jobmanagement.composite.JobListComposite;
import com.clustercontrol.jobmanagement.dialog.JobDialog;
import com.clustercontrol.jobmanagement.util.JobEditStateUtil;
import com.clustercontrol.jobmanagement.util.JobUtil;
import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class JobDoubleClickListener
implements IDoubleClickListener {
    private static Log m_log = LogFactory.getLog(JobDoubleClickListener.class);
    private JobListComposite m_composite;

    public JobDoubleClickListener(JobListComposite composite) {
        this.m_composite = composite;
    }

    public void doubleClick(DoubleClickEvent event) {
        JobTreeItem selectJobTreeItem = null;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = page.findView("com.clustercontrol.jobmanagement.view.JobListView");
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (viewPart != null && selection != null) {
            ArrayList item = (ArrayList)selection.getFirstElement();
            JobListView view = (JobListView)viewPart.getAdapter(JobListView.class);
            if (item instanceof ArrayList) {
                String jobId = (String)item.get(0);
                if (this.m_composite.getJobTreeItem() instanceof JobTreeItem) {
                    List items = this.m_composite.getJobTreeItem().getChildren();
                    int i = 0;
                    while (i < items.size()) {
                        if (jobId.equals(((JobTreeItem)items.get(i)).getData().getId())) {
                            selectJobTreeItem = (JobTreeItem)items.get(i);
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (selectJobTreeItem instanceof JobTreeItem) {
                this.m_composite.setSelectJobTreeItem(selectJobTreeItem);
                boolean readOnly = !JobEditStateUtil.isLockedJobunitId(selectJobTreeItem.getData().getJobunitId());
                JobDialog dialog = new JobDialog(this.m_composite.getShell(), readOnly);
                dialog.setJobTreeItem(selectJobTreeItem);
                m_log.info((Object)("jobDialog " + selectJobTreeItem.getData().getId()));
                if (dialog.open() == 0) {
                    this.m_composite.update(selectJobTreeItem.getParent());
                    if (!readOnly) {
                        JobEditStateUtil.addEditedJobunit(selectJobTreeItem);
                        if (selectJobTreeItem.getData().getType() == 0) {
                            JobUtil.setJobunitIdAll(selectJobTreeItem, selectJobTreeItem.getData().getJobunitId());
                        }
                    }
                    view.getJobTreeComposite().getTreeViewer().sort(selectJobTreeItem.getParent());
                    view.getJobTreeComposite().getTreeViewer().refresh(selectJobTreeItem.getParent());
                }
            }
        }
    }
}

