/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.action.GetParameterTableDefine;
import com.clustercontrol.jobmanagement.bean.SystemParameterConstant;
import com.clustercontrol.jobmanagement.composite.action.ParameterSelectionChangedListener;
import com.clustercontrol.jobmanagement.dialog.ParameterDialog;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.jobmanagement.JobParameterInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class ParameterComposite
extends Composite {
    private CommonTableViewer m_viewer = null;
    private Button m_createCondition = null;
    private Button m_modifyCondition = null;
    private Button m_deleteCondition = null;
    private List<JobParameterInfo> m_paramList = null;
    private Shell m_shell = null;
    private ArrayList m_selectItem = null;
    private boolean initFlag;

    public ParameterComposite(Composite parent, int style, boolean initFlag) {
        super(parent, style);
        this.initialize();
        this.m_shell = this.getShell();
        this.initFlag = initFlag;
    }

    private void initialize() {
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.fill = true;
        this.setLayout((Layout)layout);
        Composite composite = null;
        RowLayout rowLayout = null;
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        composite.setLayout((Layout)rowLayout);
        Label tableTitle = new Label(composite, 0);
        tableTitle.setText(Messages.getString((String)"list"));
        Table table = new Table(composite, 68356);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new RowData(430, 80));
        composite = new Composite(composite, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 5;
        composite.setLayout((Layout)rowLayout);
        Label dummy1 = new Label(composite, 0);
        dummy1.setLayoutData((Object)new RowData(190, 15));
        this.m_createCondition = new Button(composite, 0);
        this.m_createCondition.setText(Messages.getString((String)"add"));
        this.m_createCondition.setLayoutData((Object)new RowData(80, 22));
        this.m_createCondition.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog dialog = new ParameterDialog(ParameterComposite.this.m_shell);
                if (dialog.open() == 0) {
                    ArrayList info = dialog.getInputData();
                    ArrayList<ArrayList> list = (ArrayList<ArrayList>)ParameterComposite.this.m_viewer.getInput();
                    if (list == null) {
                        list = new ArrayList<ArrayList>();
                    }
                    list.add(info);
                    ParameterComposite.this.m_viewer.setInput(list);
                }
            }
        });
        this.m_modifyCondition = new Button(composite, 0);
        this.m_modifyCondition.setText(Messages.getString((String)"modify"));
        this.m_modifyCondition.setLayoutData((Object)new RowData(80, 22));
        this.m_modifyCondition.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog dialog = new ParameterDialog(ParameterComposite.this.m_shell);
                if (ParameterComposite.this.m_selectItem instanceof ArrayList) {
                    dialog.setInputData(ParameterComposite.this.m_selectItem);
                    if (dialog.open() == 0) {
                        ArrayList info = dialog.getInputData();
                        ArrayList list = (ArrayList)ParameterComposite.this.m_viewer.getInput();
                        list.remove(ParameterComposite.this.m_selectItem);
                        list.add(info);
                        ParameterComposite.this.m_selectItem = null;
                        ParameterComposite.this.m_viewer.setInput(list);
                    }
                }
            }
        });
        this.m_deleteCondition = new Button(composite, 0);
        this.m_deleteCondition.setText(Messages.getString((String)"delete"));
        this.m_deleteCondition.setLayoutData((Object)new RowData(80, 22));
        this.m_deleteCondition.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ParameterComposite.this.m_selectItem instanceof ArrayList) {
                    ArrayList list = (ArrayList)ParameterComposite.this.m_viewer.getInput();
                    list.remove(ParameterComposite.this.m_selectItem);
                    ParameterComposite.this.m_selectItem = null;
                    ParameterComposite.this.m_viewer.setInput(list);
                }
            }
        });
        this.m_viewer = new CommonTableViewer(table);
        this.m_viewer.createTableColumn(GetParameterTableDefine.get(), 0, 1);
        ArrayList infoList = new ArrayList();
        ArrayList info = null;
        for (ArrayList param : SystemParameterConstant.ALL) {
            info = new ArrayList();
            info.add(param.get(0));
            info.add(0);
            info.add("(" + Messages.getString((String)"auto") + ")");
            info.add(param.get(1));
            infoList.add(info);
        }
        this.m_viewer.setInput(infoList);
        this.m_viewer.addSelectionChangedListener(new ParameterSelectionChangedListener(this));
    }

    public void reflectParamInfo() {
        if (!this.initFlag) {
            ArrayList tableData = new ArrayList();
            int i = 0;
            while (i < this.m_paramList.size()) {
                JobParameterInfo info = this.m_paramList.get(i);
                ArrayList<Object> tableLineData = new ArrayList<Object>();
                tableLineData.add(info.getParamId());
                tableLineData.add(new Integer(info.getType()));
                if (info.getType() == 0) {
                    tableLineData.add("(" + Messages.getString((String)"auto") + ")");
                } else if (info.getType() == 1) {
                    tableLineData.add(info.getValue());
                }
                tableLineData.add(info.getDescription());
                tableData.add(tableLineData);
                ++i;
            }
            this.m_viewer.setInput(tableData);
        }
    }

    public void setParamInfo(List<JobParameterInfo> paramList) {
        this.m_paramList = paramList;
    }

    public List<JobParameterInfo> getParamInfo() {
        return this.m_paramList;
    }

    public ValidateResult createParamInfo() {
        this.m_paramList = new ArrayList<JobParameterInfo>();
        ArrayList tableData = (ArrayList)this.m_viewer.getInput();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (tableData instanceof ArrayList) {
            int i = 0;
            while (i < tableData.size()) {
                ArrayList tableLineData = (ArrayList)tableData.get(i);
                JobParameterInfo info = new JobParameterInfo();
                Integer type = (Integer)tableLineData.get(1);
                info.setType(type);
                if (info.getType() == 0) {
                    info.setParamId((String)tableLineData.get(0));
                    info.setDescription((String)tableLineData.get(3));
                } else if (info.getType() == 1) {
                    info.setParamId((String)tableLineData.get(0));
                    info.setValue((String)tableLineData.get(2));
                    info.setDescription((String)tableLineData.get(3));
                }
                Integer checkValue = (Integer)map.get(info.getParamId());
                if (checkValue == null) {
                    this.m_paramList.add(info);
                    map.put(info.getParamId(), new Integer(0));
                }
                ++i;
            }
        }
        return null;
    }

    public ArrayList getSelectItem() {
        return this.m_selectItem;
    }

    public void setSelectItem(ArrayList selectItem) {
        this.m_selectItem = selectItem;
    }

    public void setEnabled(boolean enabled) {
        this.m_createCondition.setEnabled(enabled);
        this.m_modifyCondition.setEnabled(enabled);
        this.m_deleteCondition.setEnabled(enabled);
    }
}

