/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.bean.EndStatusColorConstant;
import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.notify.composite.NotifyIdListComposite;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.JobNotificationsInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NotificationsComposite
extends Composite {
    private Combo m_normalPriority = null;
    private Combo m_warningPriority = null;
    private Combo m_abnormalPriority = null;
    private Combo m_startPriority = null;
    private NotifyIdListComposite m_notifyId = null;
    private List<JobNotificationsInfo> m_notifications = null;

    public NotificationsComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 1;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.fill = true;
        this.setLayout((Layout)layout);
        Composite composite = null;
        RowLayout rowLayout = null;
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout((Layout)rowLayout);
        Label dummy = new Label(composite, 0);
        dummy.setLayoutData((Object)new RowData(60, 15));
        Label importanceDegreeTitle = new Label(composite, 0x1000000);
        importanceDegreeTitle.setText(Messages.getString((String)"priority"));
        importanceDegreeTitle.setLayoutData((Object)new RowData(80, 15));
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout((Layout)rowLayout);
        Label beginningTitle = new Label(composite, 0x1000000);
        beginningTitle.setText(String.valueOf(EndStatusConstant.STRING_BEGINNING) + " : ");
        beginningTitle.setLayoutData((Object)new RowData(60, 15));
        this.m_startPriority = new Combo(composite, 0x1000008);
        this.m_startPriority.setLayoutData((Object)new RowData(100, 20));
        this.m_startPriority.add(PriorityConstant.STRING_INFO);
        this.m_startPriority.add(PriorityConstant.STRING_WARNING);
        this.m_startPriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_startPriority.add(PriorityConstant.STRING_UNKNOWN);
        this.m_startPriority.add("");
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout((Layout)rowLayout);
        Label normalTitle = new Label(composite, 0x1000000);
        normalTitle.setText(String.valueOf(EndStatusConstant.STRING_NORMAL) + " : ");
        normalTitle.setLayoutData((Object)new RowData(60, 15));
        normalTitle.setBackground(EndStatusColorConstant.COLOR_NORMAL);
        this.m_normalPriority = new Combo(composite, 0x1000008);
        this.m_normalPriority.setLayoutData((Object)new RowData(100, 20));
        this.m_normalPriority.add(PriorityConstant.STRING_INFO);
        this.m_normalPriority.add(PriorityConstant.STRING_WARNING);
        this.m_normalPriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_normalPriority.add(PriorityConstant.STRING_UNKNOWN);
        this.m_normalPriority.add("");
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout((Layout)rowLayout);
        Label warningTitle = new Label(composite, 0x1000000);
        warningTitle.setText(String.valueOf(EndStatusConstant.STRING_WARNING) + " : ");
        warningTitle.setLayoutData((Object)new RowData(60, 15));
        warningTitle.setBackground(EndStatusColorConstant.COLOR_WARNING);
        this.m_warningPriority = new Combo(composite, 0x1000008);
        this.m_warningPriority.setLayoutData((Object)new RowData(100, 20));
        this.m_warningPriority.add(PriorityConstant.STRING_INFO);
        this.m_warningPriority.add(PriorityConstant.STRING_WARNING);
        this.m_warningPriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_warningPriority.add(PriorityConstant.STRING_UNKNOWN);
        this.m_warningPriority.add("");
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout((Layout)rowLayout);
        Label abnormalTitle = new Label(composite, 0x1000000);
        abnormalTitle.setText(String.valueOf(EndStatusConstant.STRING_ABNORMAL) + " : ");
        abnormalTitle.setLayoutData((Object)new RowData(60, 15));
        abnormalTitle.setBackground(EndStatusColorConstant.COLOR_ABNORMAL);
        this.m_abnormalPriority = new Combo(composite, 0x1000008);
        this.m_abnormalPriority.setLayoutData((Object)new RowData(100, 20));
        this.m_abnormalPriority.add(PriorityConstant.STRING_INFO);
        this.m_abnormalPriority.add(PriorityConstant.STRING_WARNING);
        this.m_abnormalPriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_abnormalPriority.add(PriorityConstant.STRING_UNKNOWN);
        this.m_abnormalPriority.add("");
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout((Layout)rowLayout);
        Label notifyIdTitle = new Label(composite, 0x1000000);
        notifyIdTitle.setText(String.valueOf(Messages.getString((String)"notify.id")) + " : ");
        notifyIdTitle.setLayoutData((Object)new RowData(80, 15));
        this.m_notifyId = new NotifyIdListComposite(composite, 0x1000000, false);
    }

    public void reflectNotificationsInfo() {
        this.m_normalPriority.select(0);
        this.m_warningPriority.select(1);
        this.m_abnormalPriority.select(2);
        this.m_startPriority.select(0);
        if (this.m_notifications != null) {
            JobNotificationsInfo infoNormal = null;
            JobNotificationsInfo infoWarning = null;
            JobNotificationsInfo infoAbnormal = null;
            JobNotificationsInfo infoStart = null;
            int i = 0;
            while (i < this.m_notifications.size()) {
                if (this.m_notifications.get(i).getType() == 3) {
                    infoStart = this.m_notifications.get(i);
                } else if (this.m_notifications.get(i).getType() == 0) {
                    infoNormal = this.m_notifications.get(i);
                } else if (this.m_notifications.get(i).getType() == 1) {
                    infoWarning = this.m_notifications.get(i);
                } else if (this.m_notifications.get(i).getType() == 2) {
                    infoAbnormal = this.m_notifications.get(i);
                }
                ++i;
            }
            if (infoNormal instanceof JobNotificationsInfo) {
                this.setSelectPriority(this.m_normalPriority, infoNormal.getPriority());
                if (infoNormal.getNotifyId() != null && infoNormal.getNotifyId().size() > 0) {
                    this.m_notifyId.setNotify(infoNormal.getNotifyId());
                }
            }
            if (infoWarning instanceof JobNotificationsInfo) {
                this.setSelectPriority(this.m_warningPriority, infoWarning.getPriority());
            }
            if (infoAbnormal instanceof JobNotificationsInfo) {
                this.setSelectPriority(this.m_abnormalPriority, infoAbnormal.getPriority());
            }
            if (infoStart instanceof JobNotificationsInfo) {
                this.setSelectPriority(this.m_startPriority, infoStart.getPriority());
            }
        }
    }

    public void setNotificationsInfo(List<JobNotificationsInfo> notifications) {
        this.m_notifications = notifications;
    }

    public List<JobNotificationsInfo> getNotificationsInfo() {
        return this.m_notifications;
    }

    public ValidateResult createNotificationsInfo() {
        JobNotificationsInfo infoNormal = null;
        JobNotificationsInfo infoWarning = null;
        JobNotificationsInfo infoAbnormal = null;
        JobNotificationsInfo infoStart = null;
        this.m_notifications = new ArrayList<JobNotificationsInfo>();
        infoStart = new JobNotificationsInfo();
        infoStart.setType(Integer.valueOf(3));
        infoStart.setPriority(Integer.valueOf(0));
        this.m_notifications.add(infoStart);
        infoNormal = new JobNotificationsInfo();
        infoNormal.setType(Integer.valueOf(0));
        infoStart.setPriority(Integer.valueOf(0));
        this.m_notifications.add(infoNormal);
        infoWarning = new JobNotificationsInfo();
        infoWarning.setType(Integer.valueOf(1));
        infoStart.setPriority(Integer.valueOf(0));
        this.m_notifications.add(infoWarning);
        infoAbnormal = new JobNotificationsInfo();
        infoAbnormal.setType(Integer.valueOf(2));
        infoStart.setPriority(Integer.valueOf(0));
        this.m_notifications.add(infoAbnormal);
        infoNormal.setPriority(Integer.valueOf(this.getSelectPriority(this.m_normalPriority)));
        if (this.m_notifyId.getNotify() != null) {
            List notifyRelationInfoList = infoNormal.getNotifyId();
            notifyRelationInfoList.clear();
            notifyRelationInfoList.addAll(this.m_notifyId.getNotify());
        }
        infoWarning.setPriority(Integer.valueOf(this.getSelectPriority(this.m_warningPriority)));
        infoAbnormal.setPriority(Integer.valueOf(this.getSelectPriority(this.m_abnormalPriority)));
        infoStart.setPriority(Integer.valueOf(this.getSelectPriority(this.m_startPriority)));
        return null;
    }

    public void setSelectPriority(Combo combo, int priority) {
        String select = "";
        if (priority == 0) {
            select = PriorityConstant.STRING_CRITICAL;
        } else if (priority == 2) {
            select = PriorityConstant.STRING_WARNING;
        } else if (priority == 3) {
            select = PriorityConstant.STRING_INFO;
        } else if (priority == 1) {
            select = PriorityConstant.STRING_UNKNOWN;
        } else if (priority == 4) {
            select = "";
        }
        combo.select(0);
        int i = 0;
        while (i < combo.getItemCount()) {
            if (select.equals(combo.getItem(i))) {
                combo.select(i);
                break;
            }
            ++i;
        }
    }

    public int getSelectPriority(Combo combo) {
        String select = combo.getText();
        if (select.equals(PriorityConstant.STRING_CRITICAL)) {
            return 0;
        }
        if (select.equals(PriorityConstant.STRING_WARNING)) {
            return 2;
        }
        if (select.equals(PriorityConstant.STRING_INFO)) {
            return 3;
        }
        if (select.equals(PriorityConstant.STRING_UNKNOWN)) {
            return 1;
        }
        if (select.equals("")) {
            return 4;
        }
        return -1;
    }

    public NotifyIdListComposite getNotifyId() {
        return this.m_notifyId;
    }

    public void setNotifyId(NotifyIdListComposite notifyId) {
        this.m_notifyId = notifyId;
    }

    public void setEnabled(boolean enabled) {
        this.m_normalPriority.setEnabled(enabled);
        this.m_warningPriority.setEnabled(enabled);
        this.m_abnormalPriority.setEnabled(enabled);
        this.m_startPriority.setEnabled(enabled);
        this.m_notifyId.setButtonEnabled(enabled);
    }
}

