/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.accesscontrol.util.LocalSession;
import com.clustercontrol.bean.Property;
import com.clustercontrol.jobmanagement.action.GetPlanTableDefine;
import com.clustercontrol.jobmanagement.composite.action.SessionJobDoubleClickListener;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.jobmanagement.util.JobPropertyUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.JobPlan;
import com.clustercontrol.ws.jobmanagement.JobPlanFilter;
import com.sun.xml.internal.ws.client.ClientTransportException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class JobPlanComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(JobPlanComposite.class);
    private CommonTableViewer m_viewer = null;
    private Label m_labelType = null;
    private Label m_labelCount = null;

    public JobPlanComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_labelType = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelType.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.m_labelCount = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelCount.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableViewer(table);
        this.m_viewer.createTableColumn(GetPlanTableDefine.get(), 0, 1);
        this.m_viewer.addDoubleClickListener(new SessionJobDoubleClickListener(this));
    }

    public void update() {
        this.update(null);
    }

    /*
     * WARNING - void declaration
     */
    public void update(Property condition) {
        int plans;
        List<Object> planList;
        block13: {
            planList = new ArrayList();
            plans = ClusterControlPlugin.getDefault().getPreferenceStore().getInt("planMaxSchedule");
            try {
                if (condition == null) {
                    planList = JobEndpointWrapper.getPlanList(null, plans);
                } else {
                    planList = JobEndpointWrapper.getPlanList(JobPropertyUtil.property2jobPlanFilter(condition), plans);
                    JobPlanFilter filter = new JobPlanFilter();
                    filter = JobPropertyUtil.property2jobPlanFilter(condition);
                    filter.toString();
                }
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                if (LocalSession.isDialogFlag()) {
                    LocalSession.setDialogFlag(false);
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    LocalSession.setDialogFlag(true);
                }
            }
            catch (Exception e) {
                if (!LocalSession.isDialogFlag()) break block13;
                LocalSession.setDialogFlag(false);
                if (e instanceof ClientTransportException) {
                    m_log.warn((Object)("update() getPlanList, " + e.getMessage()));
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.transfer")) + ", " + e.getMessage()));
                } else {
                    m_log.warn((Object)("update() getPlanList, " + e.getMessage()), (Throwable)e);
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
                }
                LocalSession.setDialogFlag(true);
            }
        }
        ArrayList listInput = new ArrayList();
        SimpleDateFormat sdfYmd = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        for (JobPlan jobPlan : planList) {
            ArrayList<String> a = new ArrayList<String>();
            String date = sdfYmd.format(jobPlan.getDate());
            a.add(date);
            a.add(jobPlan.getJobKickId());
            a.add(jobPlan.getJobKickName());
            a.add(jobPlan.getJobunitId());
            a.add(jobPlan.getJobId());
            a.add(jobPlan.getJobName());
            listInput.add(a);
        }
        this.m_viewer.setInput(listInput);
        if (condition != null) {
            this.m_labelType.setText(Messages.getString((String)"filtered.list"));
            Object[] objectArray = new Object[]{new Integer(planList.size())};
            this.m_labelCount.setText(Messages.getString((String)"filtered.records", (Object[])objectArray));
        } else {
            void var6_13;
            this.m_labelType.setText("");
            Object var6_10 = null;
            if (plans > planList.size()) {
                Object[] objectArray = new Object[]{planList.size()};
            } else {
                Object[] objectArray = new Object[]{plans};
            }
            this.m_labelCount.setText(Messages.getString((String)"records", (Object[])var6_13));
        }
    }
}

