/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.calendar.composite.CalendarIdListComposite;
import com.clustercontrol.composite.action.NumberVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.JobWaitRuleInfo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ControlComposite
extends Composite {
    private Button m_waitCondition = null;
    private Button m_skipCondition = null;
    private Group m_skipEndConditionGroup = null;
    private Combo m_skipEndStatus = null;
    private Text m_skipEndValue = null;
    private Button m_calendarCondition = null;
    private Group m_calendarConditionGroup = null;
    private CalendarIdListComposite m_calendarId = null;
    private Combo m_calendarEndStatus = null;
    private Text m_calendarEndValue = null;
    private JobWaitRuleInfo m_waitRule = null;

    public ControlComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.fill = true;
        this.setLayout((Layout)layout);
        Composite composite = null;
        RowLayout rowLayout = null;
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        composite.setLayout((Layout)rowLayout);
        this.m_calendarCondition = new Button(composite, 32);
        this.m_calendarCondition.setText(Messages.getString((String)"calendar"));
        this.m_calendarCondition.setLayoutData((Object)new RowData(220, 22));
        this.m_calendarCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    ControlComposite.this.m_calendarConditionGroup.setEnabled(true);
                    ControlComposite.this.m_calendarId.setEnabled(true);
                    ControlComposite.this.m_calendarEndStatus.setEnabled(true);
                    ControlComposite.this.m_calendarEndValue.setEnabled(true);
                } else {
                    ControlComposite.this.m_calendarConditionGroup.setEnabled(false);
                    ControlComposite.this.m_calendarId.setEnabled(false);
                    ControlComposite.this.m_calendarEndStatus.setEnabled(false);
                    ControlComposite.this.m_calendarEndValue.setEnabled(false);
                }
                ControlComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_calendarConditionGroup = new Group((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 5;
        rowLayout.marginHeight = 5;
        rowLayout.spacing = 1;
        this.m_calendarConditionGroup.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)this.m_calendarConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout((Layout)rowLayout);
        Label calendarIdTitle = new Label(composite, 16384);
        calendarIdTitle.setText(String.valueOf(Messages.getString((String)"calendar.id")) + " : ");
        calendarIdTitle.setLayoutData((Object)new RowData(80, 15));
        this.m_calendarId = new CalendarIdListComposite(composite, 0, false);
        this.m_calendarId.setEnabled(false);
        composite = new Composite((Composite)this.m_calendarConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label calendarEndStatusTitle = new Label(composite, 16384);
        calendarEndStatusTitle.setText(String.valueOf(Messages.getString((String)"end.status")) + " : ");
        calendarEndStatusTitle.setLayoutData((Object)new RowData(80, 15));
        this.m_calendarEndStatus = new Combo(composite, 0x1000008);
        this.m_calendarEndStatus.setLayoutData((Object)new RowData(100, 20));
        this.m_calendarEndStatus.add(EndStatusConstant.STRING_NORMAL);
        this.m_calendarEndStatus.add(EndStatusConstant.STRING_WARNING);
        this.m_calendarEndStatus.add(EndStatusConstant.STRING_ABNORMAL);
        composite = new Composite((Composite)this.m_calendarConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label calendarEndValueTitle = new Label(composite, 16384);
        calendarEndValueTitle.setText(String.valueOf(Messages.getString((String)"end.value")) + " : ");
        calendarEndValueTitle.setLayoutData((Object)new RowData(80, 15));
        this.m_calendarEndValue = new Text(composite, 2048);
        this.m_calendarEndValue.setLayoutData((Object)new RowData(100, 15));
        this.m_calendarEndValue.addVerifyListener((VerifyListener)new NumberVerifyListener(Short.MIN_VALUE, Short.MAX_VALUE));
        this.m_calendarEndValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ControlComposite.this.update();
            }
        });
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        composite.setLayout((Layout)rowLayout);
        Label dummy4 = new Label(composite, 0);
        dummy4.setLayoutData((Object)new RowData(190, 15));
        this.m_waitCondition = new Button(composite, 32);
        this.m_waitCondition.setText(Messages.getString((String)"reserve"));
        this.m_waitCondition.setLayoutData((Object)new RowData(200, 22));
        this.m_waitCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    ControlComposite.this.m_skipCondition.setSelection(false);
                    ControlComposite.this.m_skipEndConditionGroup.setEnabled(false);
                    ControlComposite.this.m_skipEndStatus.setEnabled(false);
                    ControlComposite.this.m_skipEndValue.setEnabled(false);
                }
                ControlComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        composite.setLayout((Layout)rowLayout);
        this.m_skipCondition = new Button(composite, 32);
        this.m_skipCondition.setText(Messages.getString((String)"skip"));
        this.m_skipCondition.setLayoutData((Object)new RowData(200, 22));
        this.m_skipCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    ControlComposite.this.m_skipEndConditionGroup.setEnabled(true);
                    ControlComposite.this.m_skipEndStatus.setEnabled(true);
                    ControlComposite.this.m_skipEndValue.setEnabled(true);
                    ControlComposite.this.m_waitCondition.setSelection(false);
                } else {
                    ControlComposite.this.m_skipEndConditionGroup.setEnabled(false);
                    ControlComposite.this.m_skipEndStatus.setEnabled(false);
                    ControlComposite.this.m_skipEndValue.setEnabled(false);
                }
                ControlComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_skipEndConditionGroup = new Group((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 5;
        rowLayout.marginHeight = 5;
        rowLayout.spacing = 1;
        this.m_skipEndConditionGroup.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)this.m_skipEndConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label skipEndStatusTitle = new Label(composite, 16384);
        skipEndStatusTitle.setText(String.valueOf(Messages.getString((String)"end.status")) + " : ");
        skipEndStatusTitle.setLayoutData((Object)new RowData(80, 15));
        this.m_skipEndStatus = new Combo(composite, 0x1000008);
        this.m_skipEndStatus.setLayoutData((Object)new RowData(100, 20));
        this.m_skipEndStatus.add(EndStatusConstant.STRING_NORMAL);
        this.m_skipEndStatus.add(EndStatusConstant.STRING_WARNING);
        this.m_skipEndStatus.add(EndStatusConstant.STRING_ABNORMAL);
        composite = new Composite((Composite)this.m_skipEndConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label skipEndValueTitle = new Label(composite, 16384);
        skipEndValueTitle.setText(String.valueOf(Messages.getString((String)"end.value")) + " : ");
        skipEndValueTitle.setLayoutData((Object)new RowData(80, 15));
        this.m_skipEndValue = new Text(composite, 2048);
        this.m_skipEndValue.setLayoutData((Object)new RowData(100, 15));
        this.m_skipEndValue.addVerifyListener((VerifyListener)new NumberVerifyListener(Short.MIN_VALUE, Short.MAX_VALUE));
        this.m_skipEndValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ControlComposite.this.update();
            }
        });
    }

    public void update() {
        if (this.m_calendarCondition.getSelection() && "".equals(this.m_calendarEndValue.getText())) {
            this.m_calendarEndValue.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_calendarEndValue.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_skipCondition.getSelection() && "".equals(this.m_skipEndValue.getText())) {
            this.m_skipEndValue.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_skipEndValue.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    public void reflectWaitRuleInfo() {
        if (this.m_waitRule != null) {
            this.m_calendarCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getCalendar()));
            if (this.m_waitRule.getCalendarId() != null && this.m_waitRule.getCalendarId().length() > 0) {
                if (!this.m_calendarId.getEnabled()) {
                    this.m_calendarId.addText(this.m_waitRule.getCalendarId());
                }
                this.m_calendarId.setText(this.m_waitRule.getCalendarId());
            }
            this.setSelectEndStatus(this.m_calendarEndStatus, this.m_waitRule.getCalendarEndStatus());
            this.m_calendarEndValue.setText(String.valueOf(this.m_waitRule.getCalendarEndValue()));
            this.m_waitCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getSuspend()));
            this.m_skipCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getSkip()));
            this.m_skipEndValue.setText(String.valueOf(this.m_waitRule.getSkipEndValue()));
        }
        if (this.m_calendarCondition.getSelection()) {
            this.m_calendarConditionGroup.setEnabled(true);
            this.m_calendarId.setEnabled(true);
            this.m_calendarEndStatus.setEnabled(true);
            this.m_calendarEndValue.setEnabled(true);
        } else {
            this.m_calendarConditionGroup.setEnabled(false);
            this.m_calendarId.setEnabled(false);
            this.m_calendarEndStatus.setEnabled(false);
            this.m_calendarEndValue.setEnabled(false);
        }
        if (this.m_waitCondition.getSelection()) {
            this.m_skipCondition.setSelection(false);
        }
        if (this.m_skipCondition.getSelection()) {
            this.m_skipEndConditionGroup.setEnabled(true);
            this.m_skipEndStatus.setEnabled(true);
            this.m_skipEndValue.setEnabled(true);
            this.m_waitCondition.setSelection(false);
        } else {
            this.m_skipEndConditionGroup.setEnabled(false);
            this.m_skipEndStatus.setEnabled(false);
            this.m_skipEndValue.setEnabled(false);
        }
        this.setSelectEndStatus(this.m_skipEndStatus, this.m_waitRule.getSkipEndStatus());
    }

    public void setWaitRuleInfo(JobWaitRuleInfo start) {
        this.m_waitRule = start;
    }

    public JobWaitRuleInfo getWaitRuleInfo() {
        return this.m_waitRule;
    }

    public ValidateResult createWaitRuleInfo() {
        block9: {
            ValidateResult result;
            block8: {
                result = null;
                this.m_waitRule.setCalendar(Integer.valueOf(YesNoConstant.booleanToType((boolean)this.m_calendarCondition.getSelection())));
                if (this.m_calendarId.getText().length() == 0) {
                    this.m_waitRule.setCalendarId(null);
                }
                if (this.m_calendarId.getText().length() > 0) {
                    this.m_waitRule.setCalendarId(this.m_calendarId.getText());
                } else if (this.m_waitRule.getCalendar() == 1) {
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString((String)"message.hinemos.1"));
                    result.setMessage(Messages.getString((String)"message.calendar.22"));
                    return result;
                }
                try {
                    this.m_waitRule.setCalendarEndStatus(Integer.valueOf(this.getSelectEndStatus(this.m_calendarEndStatus)));
                    this.m_waitRule.setCalendarEndValue(Integer.valueOf(Integer.parseInt(this.m_calendarEndValue.getText())));
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.m_waitRule.getCalendar() != 1) break block8;
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString((String)"message.hinemos.1"));
                    result.setMessage(Messages.getString((String)"message.job.21"));
                    return result;
                }
            }
            this.m_waitRule.setSuspend(Integer.valueOf(YesNoConstant.booleanToType((boolean)this.m_waitCondition.getSelection())));
            this.m_waitRule.setSkip(Integer.valueOf(YesNoConstant.booleanToType((boolean)this.m_skipCondition.getSelection())));
            try {
                this.m_waitRule.setSkipEndStatus(Integer.valueOf(this.getSelectEndStatus(this.m_skipEndStatus)));
                this.m_waitRule.setSkipEndValue(Integer.valueOf(Integer.parseInt(this.m_skipEndValue.getText())));
            }
            catch (NumberFormatException numberFormatException) {
                if (this.m_waitRule.getSkip() != 1) break block9;
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.21"));
                return result;
            }
        }
        return null;
    }

    private int getSelectEndStatus(Combo combo) {
        String select = combo.getText();
        return EndStatusConstant.stringToType((String)select);
    }

    private void setSelectEndStatus(Combo combo, int status) {
        String select = "";
        select = EndStatusConstant.typeToString((int)status);
        combo.select(0);
        int i = 0;
        while (i < combo.getItemCount()) {
            if (select.equals(combo.getItem(i))) {
                combo.select(i);
                break;
            }
            ++i;
        }
    }

    public CalendarIdListComposite getCalendarId() {
        return this.m_calendarId;
    }

    public void setCalendarId(CalendarIdListComposite calendarId) {
        this.m_calendarId = calendarId;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_waitCondition.setEnabled(enabled);
        this.m_skipCondition.setEnabled(enabled);
        this.m_skipEndStatus.setEnabled(enabled);
        this.m_skipEndValue.setEnabled(enabled);
        this.m_calendarCondition.setEnabled(enabled);
        this.m_calendarId.setEnabled(enabled);
        this.m_calendarEndStatus.setEnabled(enabled);
        this.m_calendarEndValue.setEnabled(enabled);
    }
}

