/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.composite.action;

import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class StringVerifyListener
implements VerifyListener {
    private Integer length;

    public StringVerifyListener(int length) {
        this.length = new Integer(length);
    }

    public void verifyText(VerifyEvent e) {
        String textString = null;
        if (e.getSource() instanceof Text) {
            Text text = (Text)e.getSource();
            textString = text.getText();
        } else if (e.getSource() instanceof Combo) {
            Combo combo = (Combo)e.getSource();
            textString = combo.getText();
        }
        StringBuilder input = new StringBuilder(textString);
        if (e.keyCode == 0) {
            input.replace(e.start, e.end, e.text);
        } else if (e.character == '\b' || e.character == '\u007f') {
            input.delete(e.start, e.end);
        } else {
            input.replace(e.start, e.end, e.text);
        }
        this.checkLength(e, input.toString());
    }

    private void checkLength(VerifyEvent e, String inputText) {
        if (inputText.length() > this.length) {
            e.doit = false;
            Object[] args = new String[]{this.length.toString()};
            MessageDialog.openWarning(null, (String)Messages.getString((String)"message.hinemos.1"), (String)Messages.getString((String)"message.hinemos.7", (Object[])args));
        }
    }
}

