/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.composite;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.action.OwnerRoleFacilityTree;
import com.clustercontrol.util.FacilityTreeItemUtil;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.viewer.FacilityTreeContentProvider;
import com.clustercontrol.viewer.FacilityTreeLabelProvider;
import com.clustercontrol.viewer.FacilityTreeViewerSorter;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class FacilityTreeComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(FacilityTreeComposite.class);
    private CommonTableViewer tableViewer = null;
    protected TreeViewer treeViewer = null;
    private String rootFacilityId = null;
    private FacilityTreeItem treeItem = null;
    protected FacilityTreeItem selectItem = null;
    protected int subScopeNumber;
    private boolean scopeOnly = false;
    boolean selectNodeOnly = false;
    private boolean unregistered = true;
    private boolean internal = true;
    protected boolean topicRefresh = true;
    protected FacilityTree facilityTree = null;
    private String ownerRoleId = null;
    private Composite parent = null;

    public FacilityTreeComposite(Composite parent, int style, String ownerRoleId) {
        super(parent, style);
        this.scopeOnly = false;
        this.unregistered = true;
        this.internal = true;
        this.parent = parent;
        this.ownerRoleId = ownerRoleId;
        this.createContents();
    }

    public FacilityTreeComposite(Composite parent, int style, String ownerRoleId, boolean selectNodeOnly) {
        super(parent, style);
        this.selectNodeOnly = selectNodeOnly;
        this.scopeOnly = false;
        this.unregistered = false;
        this.internal = false;
        this.parent = parent;
        this.ownerRoleId = ownerRoleId;
        this.createContents();
    }

    public FacilityTreeComposite(Composite parent, int style, String ownerRoleId, boolean scopeOnly, boolean unregistered, boolean internal) {
        super(parent, style);
        this.scopeOnly = scopeOnly;
        this.unregistered = unregistered;
        this.internal = internal;
        this.parent = parent;
        this.ownerRoleId = ownerRoleId;
        this.createContents();
    }

    public FacilityTreeComposite(Composite parent, int style, String ownerRoleId, boolean scopeOnly, boolean unregistered, boolean internal, String rootFacilityId) {
        super(parent, style);
        this.scopeOnly = scopeOnly;
        this.unregistered = unregistered;
        this.internal = internal;
        this.rootFacilityId = rootFacilityId;
        this.parent = parent;
        this.ownerRoleId = ownerRoleId;
        this.createContents();
    }

    public FacilityTreeComposite(Composite parent, int style, String ownerRoleId, boolean scopeOnly, boolean unregistered, boolean internal, boolean topicRefresh) {
        super(parent, style);
        this.scopeOnly = scopeOnly;
        this.unregistered = unregistered;
        this.internal = internal;
        this.topicRefresh = topicRefresh;
        this.parent = parent;
        this.ownerRoleId = ownerRoleId;
        this.createContents();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public Tree getTree() {
        return this.treeViewer.getTree();
    }

    public FacilityTreeItem getSelectItem() {
        return this.selectItem;
    }

    public void setSelectItem(FacilityTreeItem item) {
        this.selectItem = item;
    }

    public int getSubScopeNumber() {
        return this.subScopeNumber;
    }

    protected void createContents() {
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Tree tree = new Tree((Composite)this, 2052);
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        tree.setLayoutData((Object)layoutData);
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)new FacilityTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new FacilityTreeLabelProvider());
        this.treeViewer.setSorter((ViewerSorter)new FacilityTreeViewerSorter());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                FacilityTreeComposite.this.selectItem = (FacilityTreeItem)selection.getFirstElement();
                if (FacilityTreeComposite.this.selectItem instanceof FacilityTreeItem) {
                    FacilityTreeComposite.this.subScopeNumber = FacilityTreeComposite.this.selectItem.getChildren().size();
                }
            }
        });
        final FacilityTreeComposite composite = this;
        this.facilityTree = this.ownerRoleId != null ? new OwnerRoleFacilityTree(this.ownerRoleId, this.selectNodeOnly) : new FacilityTree();
        if (this.topicRefresh) {
            this.facilityTree.addComposite(composite);
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FacilityTreeComposite.this.facilityTree.delComposite(composite);
            }
        });
        this.update();
    }

    public void update() {
        this.treeItem = this.selectNodeOnly ? this.facilityTree.getTreeItem() : this.facilityTree.getTreeItem();
        if (this.treeItem != null) {
            FacilityTreeItem scope = (FacilityTreeItem)this.treeItem.getChildren().get(0);
            if (!this.internal) {
                FacilityTreeItemUtil.removeChild(scope, "INTERNAL");
            }
            if (!this.unregistered) {
                FacilityTreeItemUtil.removeChild(scope, "UNREGISTERED");
            }
            if (this.rootFacilityId != null) {
                FacilityTreeItemUtil.keepChild(scope, this.rootFacilityId);
            }
            if (this.scopeOnly) {
                FacilityTreeItemUtil.removeNode(scope);
            }
            this.checkAsyncExec(new Runnable(){

                @Override
                public void run() {
                    FacilityTreeComposite.this.treeViewer.setInput((Object)FacilityTreeComposite.this.treeItem);
                    List selectItem = FacilityTreeComposite.this.treeItem.getChildren();
                    FacilityTreeComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection(selectItem.get(0)), true);
                    FacilityTreeComposite.this.treeViewer.expandToLevel(2);
                }
            });
        }
    }

    private boolean checkAsyncExec(Runnable r) {
        if (!this.isDisposed()) {
            this.parent.getDisplay().asyncExec(r);
            return true;
        }
        return false;
    }

    public void setExpand(boolean isExpand) {
        if (isExpand) {
            this.treeViewer.setAutoExpandLevel(-1);
        }
    }

    public void setScopeTree(FacilityTreeItem treeItem) {
        try {
            this.treeItem = treeItem;
            this.treeViewer.setInput((Object)treeItem);
            this.treeViewer.setAutoExpandLevel(-1);
        }
        catch (Exception e) {
            m_log.warn((Object)("setScopeTree(), " + e.getMessage()), (Throwable)e);
        }
    }

    public void setScopeTreeWithSelection(FacilityTreeItem treeItem, String facilityID) {
        this.setScopeTree(treeItem);
        List tmpItem = treeItem.getChildren();
        int i = 0;
        while (i < tmpItem.size()) {
            this.setScopeTreeWithSelectionSub((FacilityTreeItem)tmpItem.get(i), facilityID);
            if (facilityID.equals(((FacilityTreeItem)tmpItem.get(i)).getData().getFacilityId())) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection(tmpItem.get(i)), true);
            }
            ++i;
        }
    }

    public void setScopeTreeWithSelectionSub(FacilityTreeItem treeItem, String facilityID) {
        List tmpItem = treeItem.getChildren();
        int i = 0;
        while (i < tmpItem.size()) {
            this.setScopeTreeWithSelectionSub((FacilityTreeItem)tmpItem.get(i), facilityID);
            if (facilityID.equals(((FacilityTreeItem)tmpItem.get(i)).getData().getFacilityId())) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection(tmpItem.get(i)), true);
            }
            ++i;
        }
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void setTableViewer(CommonTableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }
}

