/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.collectiverun.util.CollectiveRunEndpointWrapper;
import com.clustercontrol.collectiverun.util.ParameterPropertyUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.PropertySheet;
import com.clustercontrol.ws.collectiverun.HashMapInfo;
import com.clustercontrol.ws.collectiverun.InvalidRole_Exception;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ParameterViewComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(ParameterViewComposite.class);
    private PropertySheet propertySheet = null;
    private Combo type = null;
    private HashMapInfo typeMap = null;
    private List<String> typeList = null;
    private boolean openAccessInformation = false;

    public ParameterViewComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite composite = new Composite((Composite)this, 0);
        RowLayout compositeLayout = new RowLayout(256);
        composite.setLayout((Layout)compositeLayout);
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        Label management = new Label(composite, 16384);
        management.setText(String.valueOf(Messages.getString((String)"type")) + " : ");
        RowData rowData = new RowData();
        management.setLayoutData((Object)rowData);
        this.type = new Combo(composite, 8);
        rowData = new RowData(160, 20);
        this.type.setLayoutData((Object)rowData);
        try {
            this.typeMap = CollectiveRunEndpointWrapper.getTypeHashMap();
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            if (!this.openAccessInformation) {
                this.openAccessInformation = true;
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
        }
        catch (Exception e) {
            m_log.warn((Object)("initialize() getTypeHashMap, " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        try {
            this.typeList = CollectiveRunEndpointWrapper.getTypeStringList();
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            if (!this.openAccessInformation) {
                this.openAccessInformation = true;
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
        }
        catch (Exception e) {
            m_log.warn((Object)("initialize() getTypeStringList, " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        int i = 0;
        while (this.typeList != null && i < this.typeList.size()) {
            this.type.add(this.typeList.get(i));
            ++i;
        }
        this.type.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ParameterViewComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.type.select(0);
        TableTree table = new TableTree((Composite)this, 66306);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.propertySheet = new PropertySheet(table);
        this.update();
    }

    public void update() {
        Property data;
        block3: {
            String typeId = this.getTypeId();
            data = null;
            try {
                data = ParameterPropertyUtil.getParameterProperty(typeId, Locale.getDefault());
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                if (this.openAccessInformation) break block3;
                this.openAccessInformation = true;
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
        }
        if (data == null) {
            data = new Property(null, null, "");
        }
        this.propertySheet.setInput(data);
        this.propertySheet.expandAll();
    }

    public void update(String sessionId) {
        if (sessionId != null && sessionId.length() > 0) {
            String typeId = null;
            try {
                typeId = CollectiveRunEndpointWrapper.getParameterTypeId(sessionId);
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                if (!this.openAccessInformation) {
                    this.openAccessInformation = true;
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                }
            }
            catch (Exception e) {
                m_log.warn((Object)("update(), " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
            if (typeId != null) {
                Property data;
                block9: {
                    data = null;
                    try {
                        data = ParameterPropertyUtil.getPropertyBySessionId(sessionId, Locale.getDefault());
                    }
                    catch (InvalidRole_Exception invalidRole_Exception) {
                        if (this.openAccessInformation) break block9;
                        this.openAccessInformation = true;
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    }
                }
                if (data == null) {
                    data = new Property(null, null, "");
                }
                this.propertySheet.setInput(data);
                this.propertySheet.expandAll();
                this.type.setText(this.getTypeString(typeId));
            }
        }
    }

    public Property getInputData() {
        return (Property)this.propertySheet.getInput();
    }

    public void setInputData(Property data) {
        this.propertySheet.setInput(data);
        this.propertySheet.expandAll();
    }

    public String getTypeId() {
        if (this.typeMap != null) {
            String rtnString = "";
            for (HashMapInfo.Map1.Entry entry : this.typeMap.getMap1().getEntry()) {
                if (!this.type.getText().equals(entry.getKey())) continue;
                rtnString = entry.getValue();
                break;
            }
            return rtnString;
        }
        return null;
    }

    public String getTypeString(String typeId) {
        if (this.typeMap != null) {
            String rtnString = "";
            for (HashMapInfo.Map1.Entry entry : this.typeMap.getMap1().getEntry()) {
                if (!typeId.equals(entry.getKey())) continue;
                rtnString = entry.getValue();
                break;
            }
            return rtnString;
        }
        return null;
    }

    public TableTree getTableTree() {
        return this.propertySheet.getTableTree();
    }
}

