/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.view;

import com.clustercontrol.accesscontrol.util.ObjectBean;
import com.clustercontrol.calendar.composite.CalendarListComposite;
import com.clustercontrol.view.CommonViewPart;
import com.clustercontrol.view.ObjectPrivilegeTargetListView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class CalendarListView
extends CommonViewPart
implements ObjectPrivilegeTargetListView {
    public static final String ID = "com.clustercontrol.calendar.view.CalendarListView";
    private CalendarListComposite m_calendarList = null;
    private Composite m_parent = null;

    @Override
    public void createPartControl(Composite parent) {
        this.m_parent = parent;
        this.m_calendarList = new CalendarListComposite(this.m_parent, 0);
        this.createContextMenu();
        this.update();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CalendarListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.m_calendarList.getTable());
        this.m_calendarList.getTable().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem add = (ActionContributionItem)toolbar.find("com.clustercontrol.calendar.view.action.CalendarAddAction");
        ActionContributionItem modify = (ActionContributionItem)toolbar.find("com.clustercontrol.calendar.view.action.CalendarModifyAction");
        ActionContributionItem delete = (ActionContributionItem)toolbar.find("com.clustercontrol.calendar.view.action.CalendarDeleteAction");
        ActionContributionItem copy = (ActionContributionItem)toolbar.find("com.clustercontrol.calendar.view.action.CalendarCopyAction");
        ActionContributionItem objPrivilege = (ActionContributionItem)toolbar.find("com.clustercontrol.view.action.ObjectPrivilegeAction");
        manager.add(add.getAction());
        manager.add(modify.getAction());
        manager.add(delete.getAction());
        manager.add((IContributionItem)new Separator());
        manager.add(copy.getAction());
        manager.add((IContributionItem)new Separator());
        manager.add(objPrivilege.getAction());
    }

    @Override
    public void update() {
        this.m_calendarList.update();
    }

    public String getSelectedId() {
        StructuredSelection selection = (StructuredSelection)this.m_calendarList.getTableViewer().getSelection();
        List list = (List)selection.getFirstElement();
        String id = null;
        if (list != null) {
            id = (String)list.get(0);
        }
        return id;
    }

    @Override
    public List<ObjectBean> getSelectedObjectBeans() {
        StructuredSelection selection = (StructuredSelection)this.m_calendarList.getTableViewer().getSelection();
        Object[] objs = selection.toArray();
        String objectType = "PLT_CAL";
        String objectId = null;
        ArrayList<ObjectBean> objectBeans = new ArrayList<ObjectBean>();
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            objectId = (String)((List)obj).get(0);
            ObjectBean objectBean = new ObjectBean(objectType, objectId);
            objectBeans.add(objectBean);
            ++n2;
        }
        return objectBeans;
    }

    @Override
    public String getSelectedOwnerRoleId() {
        StructuredSelection selection = (StructuredSelection)this.m_calendarList.getTableViewer().getSelection();
        List list = (List)selection.getFirstElement();
        String id = null;
        if (list != null) {
            id = (String)list.get(5);
        }
        return id;
    }

    public void setEnabledAction(int num, ISelection selection) {
        super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarModifyAction", selection);
        super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarDeleteAction", selection);
        super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarCopyAction", selection);
        super.setEnabledAction("com.clustercontrol.view.action.ObjectPrivilegeAction", selection);
        if (num > 0) {
            super.setEnabledAction("com.clustercontrol.view.action.ObjectPrivilegeAction", true);
            if (num == 1) {
                super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarModifyAction", true);
                super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarDeleteAction", true);
                super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarCopyAction", true);
            } else {
                super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarModifyAction", false);
                super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarDeleteAction", false);
                super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarCopyAction", false);
            }
        } else {
            super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarModifyAction", false);
            super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarDeleteAction", false);
            super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarCopyAction", false);
            super.setEnabledAction("com.clustercontrol.view.action.ObjectPrivilegeAction", false);
        }
    }
}

