/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.composite;

import com.clustercontrol.calendar.util.CalendarEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.calendar.CalendarInfo;
import com.clustercontrol.ws.calendar.InvalidRole_Exception;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CalendarIdListComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(CalendarIdListComposite.class);
    private Label labelCalendarId = null;
    private Combo comboCalendarId = null;

    public CalendarIdListComposite(Composite parent, int style, boolean labelFlg) {
        super(parent, style);
        this.initialize(parent, labelFlg);
    }

    private void initialize(Composite parent, boolean labelFlg) {
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = labelFlg ? 15 : 10;
        this.setLayout((Layout)layout);
        if (labelFlg) {
            this.labelCalendarId = new Label((Composite)this, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 4;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.labelCalendarId.setLayoutData((Object)gridData);
            this.labelCalendarId.setText(String.valueOf(Messages.getString((String)"calendar.id")) + " : ");
        }
        this.comboCalendarId = new Combo((Composite)this, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.comboCalendarId.setLayoutData((Object)gridData);
        this.update();
    }

    public void update() {
    }

    public void setOwnerRoleId(String ownerRoleId) {
        this.comboCalendarId.removeAll();
        this.comboCalendarId.add("");
        ArrayList<String> list = null;
        try {
            List<CalendarInfo> listTmp = null;
            list = new ArrayList<String>();
            if (ownerRoleId != null && !"".equals(ownerRoleId)) {
                listTmp = CalendarEndpointWrapper.getCalendarList(ownerRoleId);
                for (CalendarInfo info : listTmp) {
                    list.add(info.getId());
                }
            }
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            this.setEnabled(false);
        }
        catch (Exception e) {
            m_log.warn((Object)("update(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        if (list != null) {
            for (String calendarId : list) {
                this.comboCalendarId.add(calendarId);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.comboCalendarId.setEnabled(enabled);
    }

    public boolean getEnabled() {
        return this.comboCalendarId.getEnabled();
    }

    public String getText() {
        return this.comboCalendarId.getText();
    }

    public void setText(String string) {
        this.comboCalendarId.setText(string);
    }

    public void addText(String string) {
        this.comboCalendarId.add(string);
    }
}

