/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.composite;

import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.calendar.action.GetCalendarDetailTableDefine;
import com.clustercontrol.calendar.bean.DayOfWeekInMonthConstant;
import com.clustercontrol.calendar.bean.MonthConstant;
import com.clustercontrol.calendar.bean.OperateConstant;
import com.clustercontrol.calendar.dialog.CalendarDetailDialog;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.calendar.CalendarDetailInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class CalendarDetailListComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(CalendarDetailListComposite.class);
    private CommonTableViewer m_tableViewer = null;
    private ArrayList<CalendarDetailInfo> detailList = null;
    private String m_ownerRoleId = null;

    public ArrayList<CalendarDetailInfo> getDetailList() {
        return this.detailList;
    }

    public String getOwnerRoleId() {
        return this.m_ownerRoleId;
    }

    public void setOwnerRoleId(String ownerRoleId) {
        this.m_ownerRoleId = ownerRoleId;
    }

    public CalendarDetailListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void up() {
        StructuredSelection selection = (StructuredSelection)this.m_tableViewer.getSelection();
        ArrayList list = (ArrayList)selection.getFirstElement();
        Integer order = (Integer)list.get(0);
        ArrayList<CalendarDetailInfo> detailList = this.detailList;
        if ((order = Integer.valueOf(order - 1)) > 0) {
            CalendarDetailInfo a = (CalendarDetailInfo)detailList.get(order);
            CalendarDetailInfo b = (CalendarDetailInfo)detailList.get(order - 1);
            detailList.set(order, b);
            detailList.set(order - 1, a);
        }
        this.update();
        this.selectItem(order - 1);
    }

    public void down() {
        StructuredSelection selection = (StructuredSelection)this.m_tableViewer.getSelection();
        ArrayList list = (ArrayList)selection.getFirstElement();
        Integer order = (Integer)list.get(0);
        ArrayList<CalendarDetailInfo> detailList = this.detailList;
        if (order < detailList.size()) {
            order = order - 1;
            CalendarDetailInfo a = (CalendarDetailInfo)detailList.get(order);
            CalendarDetailInfo b = (CalendarDetailInfo)detailList.get(order + 1);
            detailList.set(order, b);
            detailList.set(order + 1, a);
        }
        this.update();
        this.selectItem(order + 1);
    }

    private void selectItem(Integer order) {
        Table table = this.m_tableViewer.getTable();
        TableItem[] items = table.getItems();
        if (items == null || order == null) {
            return;
        }
        table.select(order.intValue());
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.m_tableViewer = new CommonTableViewer(table);
        this.m_tableViewer.createTableColumn(GetCalendarDetailTableDefine.get(), 0, 1);
        this.m_tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Shell shell;
                CalendarDetailDialog dialog;
                Integer order = CalendarDetailListComposite.this.getSelection();
                ArrayList<CalendarDetailInfo> detailList = CalendarDetailListComposite.this.getDetailList();
                if (order != null && (dialog = new CalendarDetailDialog(shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (CalendarDetailInfo)detailList.get(order - 1), CalendarDetailListComposite.this.m_ownerRoleId)).open() == 0) {
                    detailList.remove(order - 1);
                    detailList.add(order - 1, dialog.getInputData());
                    CalendarDetailListComposite.this.setSelection();
                }
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
    }

    public Integer getSelection() {
        ArrayList list;
        StructuredSelection selection = (StructuredSelection)this.m_tableViewer.getSelection();
        if (selection.getFirstElement() instanceof ArrayList && (list = (ArrayList)selection.getFirstElement()).get(0) instanceof Integer) {
            return (Integer)list.get(0);
        }
        return null;
    }

    public void setSelection() {
        Table table = this.m_tableViewer.getTable();
        int selectIndex = table.getSelectionIndex();
        this.update();
        table.setSelection(selectIndex);
    }

    public CalendarDetailInfo getFilterItem() {
        StructuredSelection selection = (StructuredSelection)this.m_tableViewer.getSelection();
        if (selection == null) {
            return null;
        }
        return (CalendarDetailInfo)selection.getFirstElement();
    }

    public void setDetailList(ArrayList<CalendarDetailInfo> detailList) {
        if (detailList != null) {
            this.detailList = detailList;
            this.update();
        }
    }

    public void update() {
        ArrayList listAll = new ArrayList();
        int i = 1;
        for (CalendarDetailInfo detail : this.getDetailList()) {
            Integer hh;
            String strHH;
            ArrayList<Object> list = new ArrayList<Object>();
            String ruleMonthDay = "";
            if (detail.getYear() != null) {
                ruleMonthDay = detail.getYear() == 0 ? Messages.getString((String)"calendar.detail.every.year") : detail.getYear() + Messages.getString((String)"year");
            }
            if (detail.getMonth() != null && detail.getMonth() >= 0) {
                ruleMonthDay = String.valueOf(ruleMonthDay) + MonthConstant.typeToString(detail.getMonth());
            }
            switch (detail.getDayType()) {
                case 0: {
                    ruleMonthDay = String.valueOf(ruleMonthDay) + Messages.getString((String)"calendar.detail.everyday");
                    break;
                }
                case 1: {
                    if (detail.getDayOfWeekInMonth() != null && detail.getDayOfWeekInMonth() >= 0) {
                        ruleMonthDay = String.valueOf(ruleMonthDay) + " " + DayOfWeekInMonthConstant.typeToString(detail.getDayOfWeekInMonth());
                    }
                    if (detail.getDayOfWeek() == null || detail.getDayOfWeek() <= 0) break;
                    ruleMonthDay = String.valueOf(ruleMonthDay) + DayOfWeekConstant.typeToString(detail.getDayOfWeek());
                    break;
                }
                case 2: {
                    if (detail.getDate() == null || detail.getDate() <= 0) break;
                    ruleMonthDay = String.valueOf(ruleMonthDay) + " " + detail.getDate() + Messages.getString((String)"monthday");
                    break;
                }
                case 3: {
                    if (detail.getCalPatternId() == null || detail.getCalPatternId().length() <= 0) break;
                    ruleMonthDay = String.valueOf(ruleMonthDay) + " " + detail.getCalPatternId();
                }
            }
            if (detail.getAfterday() != null && detail.getAfterday() != 0) {
                if (detail.getAfterday() > 0) {
                    ruleMonthDay = String.valueOf(ruleMonthDay) + " " + detail.getAfterday() + Messages.getString((String)"calendar.detail.after.2");
                } else if (detail.getAfterday() < 0) {
                    ruleMonthDay = String.valueOf(ruleMonthDay) + " " + Math.abs(detail.getAfterday()) + Messages.getString((String)"calendar.detail.after.3");
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
            SimpleDateFormat sdfYmd = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            SimpleDateFormat sdfHH = new SimpleDateFormat("HH");
            SimpleDateFormat sdfMmSs = new SimpleDateFormat("mm:ss");
            String strHour24 = "1970/01/02 00:00:00";
            String strHour48 = "1970/01/03 00:00:00";
            Date date = null;
            Date date2 = null;
            try {
                date = sdfYmd.parse(strHour24);
                date2 = sdfYmd.parse(strHour48);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            String strFrom = "";
            String strTo = "";
            long hour24 = date.getTime();
            long hour48 = date2.getTime();
            if (detail.getTimeFrom() != null) {
                if (hour48 <= detail.getTimeFrom()) {
                    strHH = sdfHH.format(detail.getTimeFrom());
                    hh = Integer.parseInt(strHH);
                    hh = hh + 48;
                    strFrom = String.valueOf(String.valueOf(hh)) + ":" + sdfMmSs.format(detail.getTimeFrom());
                } else if (hour24 <= detail.getTimeFrom()) {
                    strHH = sdfHH.format(detail.getTimeFrom());
                    hh = Integer.parseInt(strHH);
                    hh = hh + 24;
                    strFrom = String.valueOf(String.valueOf(hh)) + ":" + sdfMmSs.format(detail.getTimeFrom());
                } else {
                    strFrom = sdf.format(detail.getTimeFrom());
                }
            }
            if (detail.getTimeTo() != null) {
                if (hour48 <= detail.getTimeTo()) {
                    strHH = sdfHH.format(detail.getTimeTo());
                    hh = Integer.parseInt(strHH);
                    hh = hh + 48;
                    strTo = String.valueOf(String.valueOf(hh)) + ":" + sdfMmSs.format(detail.getTimeTo());
                } else if (hour24 <= detail.getTimeTo()) {
                    strHH = sdfHH.format(detail.getTimeTo());
                    hh = Integer.parseInt(strHH);
                    hh = hh + 24;
                    strTo = String.valueOf(String.valueOf(hh)) + ":" + sdfMmSs.format(detail.getTimeTo());
                } else {
                    strTo = sdf.format(detail.getTimeTo());
                }
            }
            String ruleTime = "";
            ruleTime = String.valueOf(strFrom) + " - " + strTo;
            list.add(i);
            list.add(ruleMonthDay);
            list.add(ruleTime);
            if (detail.isOperateFlg() != null) {
                if (detail.isOperateFlg().booleanValue()) {
                    list.add(OperateConstant.typeToString(1));
                } else {
                    list.add(OperateConstant.typeToString(0));
                }
            }
            listAll.add(list);
            ++i;
        }
        this.m_tableViewer.setInput(listAll);
    }

    public void setEnabled(boolean enabled) {
        this.m_tableViewer.getTable().setEnabled(enabled);
    }
}

