/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.view.action;

import com.clustercontrol.accesscontrol.util.AccessEndpointWrapper;
import com.clustercontrol.accesscontrol.view.RoleSettingTreeView;
import com.clustercontrol.accesscontrol.view.UserListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.access.InvalidRole_Exception;
import com.clustercontrol.ws.access.UnEditableUser_Exception;
import com.clustercontrol.ws.access.UsedUser_Exception;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class UserDeleteAction
implements IViewActionDelegate {
    public static final String ID = "com.clustercontrol.accesscontrol.view.action.UserDeleteAction";
    private IViewPart viewPart;

    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    public void run(IAction action) {
        UserListView userListView = (UserListView)((Object)this.viewPart.getAdapter(UserListView.class));
        StructuredSelection selection = (StructuredSelection)userListView.getComposite().getTableViewer().getSelection();
        List list = (List)selection.getFirstElement();
        String uid = null;
        if (list != null) {
            uid = (String)list.get(0);
        }
        if (uid != null) {
            Object[] args = new String[]{uid};
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.accesscontrol.13", (Object[])args))) {
                try {
                    AccessEndpointWrapper.deleteUserInfo(uid);
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.accesscontrol.11"));
                }
                catch (Exception e) {
                    String errMessage = "";
                    if (e instanceof InvalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    } else if (e instanceof UsedUser_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.37"));
                    } else if (e instanceof UnEditableUser_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.39"));
                    } else {
                        errMessage = ", " + e.getMessage();
                    }
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.accesscontrol.12")) + errMessage));
                }
                userListView.update();
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewPart roleTreeViewPart = page.findView("com.clustercontrol.accesscontrol.view.RoleSettingTreeView");
                if (roleTreeViewPart != null) {
                    RoleSettingTreeView treeView = (RoleSettingTreeView)((Object)roleTreeViewPart.getAdapter(RoleSettingTreeView.class));
                    treeView.update();
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

