/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.dialog;

import com.clustercontrol.accesscontrol.action.CheckPermission;
import com.clustercontrol.accesscontrol.bean.PrivilegeConstant;
import com.clustercontrol.accesscontrol.util.AccessEndpointWrapper;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.access.FacilityDuplicate_Exception;
import com.clustercontrol.ws.access.InvalidRole_Exception;
import com.clustercontrol.ws.access.RoleDuplicate_Exception;
import com.clustercontrol.ws.access.RoleInfo;
import com.clustercontrol.ws.access.UnEditableRole_Exception;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RoleDialog
extends CommonDialog {
    private static Log m_log = LogFactory.getLog(RoleDialog.class);
    private String roleId = "";
    private int mode = 0;
    private boolean isModifyDialog = false;
    private Text textRoleId = null;
    private Text textRoleName = null;
    private Text textDescription = null;
    public static final int WIDTH = 15;
    public static final int WIDTH_LABEL = 4;
    public static final int WIDTH_TEXT = 10;
    private RoleInfo inputData = null;
    private boolean permission = false;

    public RoleDialog(Shell parent, String roleId, boolean isModifyDialog) {
        super(parent);
        this.roleId = roleId;
        this.isModifyDialog = isModifyDialog;
        this.permission = new CheckPermission().check("AccessControl", PrivilegeConstant.SystemPrivilegeMode.WRITE);
    }

    protected Point getInitialSize() {
        return new Point(600, 600);
    }

    @Override
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.accesscontrol.role.create.modify"));
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"role.id")) + " : ");
        this.textRoleId = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textRoleId.setLayoutData((Object)gridData);
        this.textRoleId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                RoleDialog.this.update();
            }
        });
        this.mode = this.isModifyDialog ? (this.permission ? 1 : 2) : 0;
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"role.name")) + " : ");
        this.textRoleName = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textRoleName.setLayoutData((Object)gridData);
        this.textRoleName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                RoleDialog.this.update();
            }
        });
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"description")) + " : ");
        this.textDescription = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textDescription.setLayoutData((Object)gridData);
        this.textDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                RoleDialog.this.update();
            }
        });
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        RoleInfo info = null;
        if (this.roleId != null) {
            try {
                info = AccessEndpointWrapper.getRoleInfo(this.roleId);
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (Exception e) {
                m_log.warn((Object)("customizeDialog(), " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        } else {
            info = new RoleInfo();
        }
        this.setInputData(info);
    }

    @Override
    protected ValidateResult validate() {
        this.inputData = this.createInputData();
        if (this.inputData != null) {
            return super.validate();
        }
        return null;
    }

    @Override
    protected boolean action() {
        boolean result = false;
        RoleInfo roleInfo = this.inputData;
        if (roleInfo == null) {
            return result;
        }
        if (!this.isModifyDialog) {
            try {
                AccessEndpointWrapper.addRoleInfo(roleInfo);
                result = true;
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.accesscontrol.26"));
            }
            catch (RoleDuplicate_Exception roleDuplicate_Exception) {
                Object[] args = new String[]{roleInfo.getId()};
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.33", (Object[])args));
            }
            catch (FacilityDuplicate_Exception facilityDuplicate_Exception) {
                Object[] args = new String[]{roleInfo.getId()};
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.repository.26", (Object[])args));
            }
            catch (Exception e) {
                String errMessage = "";
                if (e instanceof InvalidRole_Exception) {
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                } else {
                    errMessage = ", " + e.getMessage();
                }
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.accesscontrol.27")) + errMessage));
            }
        } else {
            try {
                AccessEndpointWrapper.modifyRoleInfo(roleInfo);
                result = true;
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.accesscontrol.28"));
            }
            catch (Exception e) {
                String errMessage = "";
                if (e instanceof InvalidRole_Exception) {
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                } else if (e instanceof UnEditableRole_Exception) {
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.40"));
                } else {
                    errMessage = ", " + e.getMessage();
                }
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.accesscontrol.29")) + errMessage));
            }
        }
        return result;
    }

    public void update() {
        if ("".equals(this.textRoleId.getText())) {
            this.textRoleId.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.textRoleId.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.textRoleName.getText())) {
            this.textRoleName.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.textRoleName.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    protected void setInputData(RoleInfo roleInfo) {
        this.inputData = roleInfo;
        if (roleInfo.getId() != null) {
            this.textRoleId.setText(roleInfo.getId());
        }
        if (roleInfo.getName() != null) {
            this.textRoleName.setText(roleInfo.getName());
        }
        if (roleInfo.getDescription() != null) {
            this.textDescription.setText(roleInfo.getDescription());
        }
        if (this.mode == 2 || this.mode == 1) {
            this.textRoleId.setEnabled(false);
        } else {
            this.textRoleId.setEnabled(true);
        }
        this.update();
    }

    private RoleInfo createInputData() {
        RoleInfo info = new RoleInfo();
        info.setId(this.textRoleId.getText());
        info.setName(this.textRoleName.getText());
        info.setDescription(this.textDescription.getText());
        return info;
    }

    @Override
    protected String getOkButtonText() {
        if (this.isModifyDialog) {
            return Messages.getString((String)"modify");
        }
        return Messages.getString((String)"register");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }
}

