#!/bin/bash

#Copyright (C) 2013 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or 
#Modify it under the terms of the GNU General Public License 
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful, 
#but WITHOUT ANY WARRANTY; without even the implied warranty of 
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
#GNU General Public License for more details

SCRIPT_DIR=$(cd $(dirname $0);pwd)

. ${SCRIPT_DIR}/scripts/cloud_install_function.sh

set_hinemos_home

. ${HINEMOS_HOME}/hinemos.cfg
. ${SCRIPT_DIR}/scripts/conf.sh

check_version ${DEPENDENCY_VER_FILE} ${REQUIRED_VERSION} ${DEPENDENCY_MODULE_NAME}

echo ----- ${OPTION_PACKAGE_NAME} start ----------
install_settings ${SCRIPT_DIR} ${HINEMOS_HOME}

install_libraries ${LIBDIR} ${PLUGINS_DIR} ${PLUGINS_IN_PACKAGE_DIR} ${INSTALL_USER} ${INSTALL_GROUP} "${INSTALL_LIBRARIES}"

echo ${VERSION_NUMBER} | cat > ${HINEMOS_HOME}/${VERSION_FILE_NAME} 
chown ${INSTALL_USER}:${INSTALL_GROUP} ${HINEMOS_HOME}/${VERSION_FILE_NAME}

echo ----- ${OPTION_PACKAGE_NAME} end   ----------
echo
echo ----- db start  ------------

unset PGPASSWORD
if [ -n "${TABLE_SCRIPT}" ]; then
	db_manipulate ${PG_HOME} ${PG_USER} "${TABLE_SCRIPT}"
fi
if [ -n "${DATA_SCRIPT}" ]; then
	db_manipulate ${PG_HOME} ${PG_USER} "${DATA_SCRIPT}"
fi

echo ----- db end   -------------
echo
echo install succeeded !
exit 0
